define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('AppSelectController', function ($rootScope, $scope, $state, $q, globalDelayTracker, appSelectService, userSessionService, localStorageService, sessionStorageService, carouselService, mediaRequestTypes) {
		$scope.globalDelayTracker = globalDelayTracker;
		$scope.imageRequestsCount = 0;
		$scope.videoRequestsCount = 0;
		var modalInstance;

		$scope.openTourTheAppModal = function() {
			carouselService.openModal();
		}

		if (!localStorage.getItem(localStorageService.keys['no-show-carousel'])
			&& !sessionStorage.getItem(sessionStorageService.keys['no-show-carousel'])) {
			userSessionService.fetch().then(function(user) {
				if(sessionStorageService.showModal(user,'no-show-carousel',null) === true
					&& localStorageService.showModal(user,'no-show-carousel',null) === true) {
					$scope.openTourTheAppModal();
				}
			});
		}

		appSelectService.fetchMediaRequestCounts(mediaRequestTypes.Image).then(function(response) {
			if (response && !isNaN(response)) {
				$scope.imageRequestsCount = response;
			}
		});

		appSelectService.fetchMediaRequestCounts(mediaRequestTypes.Video).then(function(response) {
			if (response && !isNaN(response)) {
				$scope.videoRequestsCount = response;
			}
		});

		$scope.myTelederm = function() {
			$state.go('main.mytelederm');
        }
        
        $scope.myVideo = function() {
			$state.go('main.myvideo');
		}
		
	});
});
