define(['appSelectService'], function() {
    'use strict';

    describe("The AppSelect Service", function () {
        var service,
            httpMock,
            localResourceDirectoryServiceMock,
			formattedStartDate,
			formattedEndDate;

        beforeEach(function () {
            module('angularTemplateApp');

            localResourceDirectoryServiceMock = jasmine.createSpyObj('localResourceDirectoryServiceMock', ['fetch']);

            localResourceDirectoryServiceMock.fetch.and.returnValue({
                then: function (callback) {
                    callback({
                        'requests-count': '/media-request-service/v1/patients/{icn}/requests/count'
                    });
                }
            });

            module(function ($provide) {
                $provide.value('localResourceDirectoryService', localResourceDirectoryServiceMock);
            });

			var startDate = new Date();
			startDate.setDate(startDate.getDate() - 90);
			var endDate = new Date();
			endDate.setDate(endDate.getDate() + 270);

			formattedStartDate = startDate.getFullYear() + "-" + ("0" + (startDate.getMonth() + 1)).slice(-2) + "-" + ("0" + startDate.getDate()).slice(-2);
			formattedEndDate = endDate.getFullYear() + "-" + ("0" + (endDate.getMonth() + 1)).slice(-2) + "-" + ("0" + endDate.getDate()).slice(-2);

			inject(function(appSelectService, $httpBackend) {
                service = appSelectService;
                httpMock = $httpBackend;
			});
        });

        describe("fetch Telederm Counts resolve", function (){
            it ("should resolve with the count of pending mediaRequests", function() {
                var response;

                httpMock.expectGET('/media-request-service/v1/patients/{icn}/requests/count?endDate='+formattedEndDate+'&requestStatus=pending&requestType=IMAGE&startDate='+formattedStartDate).respond(200, 5);
                service.fetchMediaRequestCounts('IMAGE').then(function (data) {
                    response = data;
                });

                httpMock.flush();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
                expect(response).toEqual(5);
            });          
        });
        
        describe("fetch Telederm Counts reject", function (){
            it ("should reject with an error", function() {
                var response;

				httpMock.expectGET('/media-request-service/v1/patients/{icn}/requests/count?endDate='+formattedEndDate+'&requestStatus=pending&requestType=IMAGE&startDate='+formattedStartDate).respond(400, 'error');
                service.fetchMediaRequestCounts('IMAGE').then(function (data) {
                    //Empty success function
                }, function (error){
                    response = error;
                });

                httpMock.flush();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
                expect(response).toEqual('error');
			});
		});
    });
});