define(['AppSelectController'], function() {
    'use strict';

    describe("The AppSelect Controller", function () {
        var controller,
            scope,
            stateMock,
            $modalMock,
            globalDelayTrackerMock,
            appSelectServiceMock,
            $q,
            rootScope,
            pendingCount=0,
            carouselServiceMock,
            focusServiceMock,
            userSessionServiceMock,
            localStorageServiceMock = {
                keys: [],
                showModal: function () {}
            },
			sessionStorageServiceMock = {
				keys: [],
				showModal: function () {
				}
            },
            mediaRequestTypesMock = {Image: 'IMAGE', Vieo: 'VIDEO'};

        //Unit tests for showing the app tour carousel have not been done in anticipation of MTD-91 - Tour the App
        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('state', ['go']);
            $modalMock = jasmine.createSpyObj('$modal', ['open']);
            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
            appSelectServiceMock = jasmine.createSpyObj('appSelectService', ['fetchMediaRequestCounts']);
			carouselServiceMock = jasmine.createSpyObj('carouselService', ['openModal']);
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
            userSessionServiceMock = jasmine.createSpyObj('userSessionService', ['fetch']);

            appSelectServiceMock.fetchMediaRequestCounts.and.returnValue({
                then: function (callback) {
                    callback(
                        pendingCount
                    );
                }
            });

            userSessionServiceMock.fetch.and.returnValue({
                then: function (callback) {
                    callback({});
                }
            });

			spyOn(localStorage, 'getItem').and.callFake(function (key) {
				return null;
			});

			spyOn(sessionStorage, 'getItem').and.callFake(function (key) {
				return null;
			});

			module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('$modal', $modalMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
                $provide.value('appSelectService', appSelectServiceMock);
                $provide.value('carouselService', carouselServiceMock);
                $provide.value('focusService', focusServiceMock);
                $provide.value('userSessionService', userSessionServiceMock);
                $provide.value('localStorageService', localStorageServiceMock);
                $provide.value('sessionStorageService', sessionStorageServiceMock);
                $provide.value('mediaRequestTypes', mediaRequestTypesMock);
            });

            inject(function($controller, $rootScope, $state, globalDelayTracker, _$q_) {
                scope = $rootScope.$new();
                rootScope = $rootScope;
                $q = _$q_;
                controller = $controller;
            });
        });

		describe("myTelederm function", function (){
            it ("should navigate the user to the MyTelederm route", function() {
                controller = controller('AppSelectController', {$scope: scope});
                scope.myTelederm();
                expect(stateMock.go).toHaveBeenCalledWith('main.mytelederm');                
			});
        });

		describe("myVideo function", function (){
            it ("should navigate the user to the MyVideo route", function() {
                controller = controller('AppSelectController', {$scope: scope});
                scope.myVideo();
                expect(stateMock.go).toHaveBeenCalledWith('main.myvideo');   
			});
        });
        
        describe("appSelectService.fetchMediaRequestCounts function", function (){
            it ("should fetch the mediaRequests object and get the number of pending items", function() {
                pendingCount = 4;
                controller = controller('AppSelectController', {$scope: scope});
                scope.$apply();
                expect(scope.imageRequestsCount).toBe(4);
            });          
        });
        
        describe("appSelectService.fetchMediaRequestCounts fail function", function (){
            it ("should fetch the mediaRequests object which has no pending items", function() {
                pendingCount = 0;
                controller = controller('AppSelectController', {$scope: scope});
                scope.$apply();
                expect(scope.imageRequestsCount).toBe(0);
			});
        });

		describe("appSelectService.fetchMediaRequestCounts function", function (){
			it ("should fetch the mediaRequests object and get the number of pending items", function() {
				pendingCount = 3;
				controller = controller('AppSelectController', {$scope: scope});
				scope.$apply();
				expect(scope.videoRequestsCount).toBe(3);
			});
		});

		describe("appSelectService.fetchMediaRequestCounts fail function", function (){
			it ("should fetch the mediaRequests object which has no pending items", function() {
				pendingCount = 0;
				controller = controller('AppSelectController', {$scope: scope});
				scope.$apply();
				expect(scope.videoRequestsCount).toBe(0);
			});
		});


		it('should call openTourTheAppModal function if both local and storage sessions have not been set', function () {
			spyOn(localStorageServiceMock, 'showModal').and.returnValue(true);
			spyOn(sessionStorageServiceMock, 'showModal').and.returnValue(true);
			controller = controller('AppSelectController', {$scope: scope});
			expect(carouselServiceMock.openModal).toHaveBeenCalled();
        });

		it('should not call openTourTheAppModal function if session storage was set', function () {
			spyOn(localStorageServiceMock, 'showModal').and.returnValue(false);
			spyOn(sessionStorageServiceMock, 'showModal').and.returnValue(true);
			controller = controller('AppSelectController', {$scope: scope});
			expect(carouselServiceMock.openModal).not.toHaveBeenCalled();
		});

		it('should not call openTourTheAppModal function if local storage was set', function () {
			spyOn(localStorageServiceMock, 'showModal').and.returnValue(true);
			spyOn(sessionStorageServiceMock, 'showModal').and.returnValue(false);
			controller = controller('AppSelectController', {$scope: scope});
			expect(carouselServiceMock.openModal).not.toHaveBeenCalled();
		});
    });
});