define([
		'app',
		'LandingController',
		'AppSelectController',
		'appSelectService',
		'carouselService'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, $urlRouterProvider) {
			$urlRouterProvider.otherwise("/home");
			$stateProvider
				.state('main.landing', {
					url: '/',
					views: {
						"": {
							templateUrl: 'modules/container/components/content/single-column_template.html'
						},
						'primary@main.landing': {
							templateUrl: 'modules/applets/home/pages/landing/landing_template.html',
							controller: 'LandingController'
						}
					},
					module: 'preventNavigation'
				})
				.state('main.app-select', {
					url: '/home',
					appNavIndex: 1,
                    data: {
                        appletName: "Home"
                    },
					views: {
						"": {
							templateUrl: 'modules/container/components/content/single-column_template.html'
						},
						'primary@main.app-select': {
							templateUrl: 'modules/applets/home/pages/app-select/app-select_template.html',
							controller: 'AppSelectController'
						}
					}
				})
				.state('tour', {
					url: '/tour',
					data: {
						appletName: "My VA Images",
						requiresAuth: false
					},
					templateUrl: 'modules/applets/home/carousel-tour/carousel_template.html',
					controller: 'TourController'
				})
		});
	});