define(['app'], function (app) {
	'use strict';

	app.controller('TourController', function ($state, $scope, $modalInstance, $modal, focusService, config, localStorageService, sessionStorageService) {
		$scope.appTitle = config.app.title;
		$scope.neverDisable = true;
		$scope.tourSlides = [
			{
				image: '_assets/images/tour/0000_tour.jpg',
                text:  'Welcome to the App Tour. This application (app) allows the user to respond to electronic requests from their providers by submitting images and/or videos, assessment questions and comments for review. Learn about app navigation. Review key app features. Click "Don\'t show me this again" to hide tour. Tour can always be reviewed through user menu.'
			},
			{
				image: '_assets/images/tour/0001_menus.jpg',
				text:  'Selecting Menu provides main app navigation options. Selecting Options provides user menu navigation options. Choose My Telederm or My Video to respond to a new (pending) request or check status of a previous request. Select logout to exit the application'
			},
			{
				image: '_assets/images/tour/0002_filter.jpg',
				text: 'Select Filter to show or hide filter criteria as needed. Select Pending for new requests. You can also view by All or Completed to view status to include responses from your providers.'
			},
			{
				image: '_assets/images/tour/0003_email.jpg',
				text: 'Update contact information so the app can send you reminders and your healthcare team can contact you, if needed.'
			}
		];
		
		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		$scope.onClicked = function () {
			var state = localStorageService.toState && localStorageService.toState.name !==  $state.current.name ? localStorageService.toState : 'main.app-select';
			localStorage.setItem(localStorageService.keys['no-show-carousel'], true);
			$state.go(state);
			$modalInstance.close();
			focusService.focusMain();
		};

		$scope.okCancel = function () {
			sessionStorage.setItem(sessionStorageService.keys['no-show-carousel'], true);
			$modalInstance.close();
			if(angular.element('#main-content-div').attr('aria-hidden') === "true")
				focusService.focusElement($('#tour'));
			else
				focusService.focusElement('#btnShowTour');
		};
	});
});
