define(['angular', 'angularSnap', 'accessibleTimePickerServices', 'TimeControls', 'AppLinks'], function (angular) {
	'use strict';

	var app = angular.module('myvaimages', [
		'ngSanitize',
		'ngTouch',
		'ui.router',
		'ui.bootstrap',
		'ui.mask',
		'snap',
		'unsavedChanges',
		'delayManager',
		'focusManager',
		'accessibleDatePickerServices',
		'accessibleTimePickerServices',
		'TimeControls',
		'AccessibleAccordion',
		'CalendarDatePicker',
		'InputCalendarDatePicker',
		'AppLinksModule'
	]);

	app.config(function ($controllerProvider, $provide, $httpProvider) {

        if (!!navigator.userAgent.match(/Trident\/7\./)) {
            if (!$httpProvider.defaults.headers.get) {
                $httpProvider.defaults.headers.get = {};
            }

            $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache, no-store, must-revalidate';
            $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';
        };

        $httpProvider.defaults.useXDomain = true;
        delete $httpProvider.defaults.headers.common['X-Requested-With'];
        $httpProvider.interceptors.push('httpInterceptor');
        $httpProvider.interceptors.push('busyHttpInterceptor');
    });

	app.directive('scrollContainer', function ($window, $timeout) {
		return function (scope, element) {
			angular.element($window).bind("resize", function(){
				$timeout(function(){
					element.height("calc(100% - " + (angular.element('.main-header').height() + angular.element('.main-footer').height() + 20) + "px)");
				});
			});
			scope.$watch(function(){
				return $window.innerHeight + $window.innerWidth;
			}, function(){
				angular.element($window).trigger("resize");
			})
		};
	});

	return app;
});
