=begin
# This file was generated by the `rspec --init` command. Conventionally, all
# specs live under a `spec` directory, which RSpec adds to the `$LOAD_PATH`.
# Require this file using `require "spec_helper"` to ensure that it is only
# loaded once.
#
# See http://rubydoc.info/gems/rspec-core/RSpec/Core/Configuration
RSpec.configure do |config|
  config.treat_symbols_as_metadata_keys_with_true_values = true
  config.run_all_when_everything_filtered = true
  config.filter_run :focus

  # Run specs in random order to surface order dependencies. If you find an
  # order dependency and want to debug it, you can fix the order by providing
  # the seed, which is printed after each run.
  #     --seed 1234
  config.order = 'random'
end
=end














require 'rubygems'
require "json"
require 'selenium-webdriver'
require 'rspec'

require_relative  "../pages/login_screen"
require_relative  "../pages/eula"
require_relative  "../pages/roa"
require_relative  "../pages/main"
require_relative  "../pages/menu"
require_relative  "../pages/nav_menu"
require_relative  "../pages/common"
require_relative  "../pages/landing_screen"
require_relative  "../module/DriverUtility"
require_relative  "../module/MongoUtility"
require_relative  "../module/DBUtility"


# RSpec.configure do |config|
#
#   fetch_current_example = RSpec.respond_to?(:current_example) ? proc { RSpec.current_example } : proc { |context| context.example }
#
#   config.after(:each) do
#     example = fetch_current_example.call(self);
#
#     if example.exception
#       meta = example.metadata
#       filename = File.basename(meta[:file_path])
#       line_number = meta[:line_number]
#       buildJobUrl = ENV["JOB_URL"]
#       buildJobNumber = ENV["BUILD_NUMBER"]
#       screenshot_name = "screenshot-#{filename}-#{line_number}.png"
#       screenshot_dir = "screenshots" + (buildJobNumber != nil ? ("_" + buildJobNumber.to_s) : "")
#       screenshot_path = screenshot_dir + "/#{screenshot_name}"
#
#       if !Dir.exists?(screenshot_dir)
#         Dir.mkdir screenshot_dir
#       end
#
#       @driver.save_screenshot(screenshot_path)
#
#       puts "----Screenshot ------------------------------------------------------------------------"
#       puts meta[:full_description] + "\n  Screenshot: #{screenshot_path}\n  " + (buildJobUrl != nil ? buildJobUrl.to_s : "") + "/ws/acceptance_test/selenium-ruby/" + screenshot_path
#       puts "---------------------------------------------------------------------------------------"
#     end
#   end
# end

require 'selenium-webdriver'
require 'allure-rspec'
require 'uuid'
require 'pathname'

RSpec.configure do |c|
    # declare an exclusion filter
    c.filter_run_excluding :broken => false
    c.filter_run_excluding :bug => false
    c.filter_run_excluding :regression => false
    c.filter_run_excluding :acceptance => false
    c.filter_run_excluding :smoketest => false
end

RSpec.configure do |config|
    config.include AllureRSpec::Adaptor
end

AllureRSpec.configure do |config|
    config.output_dir = 'allure_results'
    config.clean_dir = true # this is the default value
end

$DEMO = "http://vet.mobilehealthdemo.com/launchpad"
$LOCAL = "http://IP      /my-va-health/#/"

### Pick between demo and local below

BASE_URL = $LOCAL

# def loginMyVAHealth
#     @driver = Selenium::WebDriver.for :firefox
#     @base_url = "http://IP      /my-va-health/#/"
#     @driver.navigate.to "http://IP      /my-va-health/#/"
#     sleep 2
#     @accept_next_alert = true
#     @driver.manage.timeouts.implicit_wait = 3
#     @driver.manage.window.maximize
#     @driver.find_element(:xpath, "//button[@class='btn btn-primary accept-btn pull-right']").click
#     sleep 3
#
#     @driver.manage.timeouts.page_load = 5
#
#     @driver.find_element(:xpath, "//button[@class='login btn btn-default']").click
#     @driver.manage.timeouts.page_load = 5
#     @driver.find_element(:xpath, "//input[@name='j_username']").clear
#     @driver.find_element(:xpath, "//input[@name='j_username']").send_keys "zztest.patient05"
#     sleep 2
#     @driver.find_element(:xpath, "//input[@id='password']").clear
#     @driver.find_element(:xpath, "//input[@id='password']").send_keys "pass"
#     @driver.find_element(:xpath, "//button[@id='loginButton']").click
#     sleep 10
#     @driver.find_element(:xpath, "//span[@role='button']").click
#     sleep 10
#     @driver.find_element(:xpath, "//button[@ng-click='acceptClicked()']").click
#     @driver.manage.timeouts.page_load = 5
#     @driver.find_element(:xpath, "//button[@ng-click='okCancel()']").click
#     @driver.manage.timeouts.page_load = 5
#     sleep 5
# end