require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-60: Weight: Enter Delete Edit]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-745: Generate PDF for Weight List]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")

    @baseNav = "Weight"
    @expectedHeaders = {"add" => "Add Weight Entry", "edit" => "Edit Weight Entry", "summary" => "Weight", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Weight (lbs)", "Date Entered"]
    @phoneTableHeaders = ["Weight (lbs)", "Date Entered"]

    @addDataSet = [{"Weight" => "150"},
      {"Weight" => "190"},
      {"Weight" => "300"}]

    @editDataSet = [{"Weight" => "300"},
      {"Weight" => "200"},
      {"Weight" => "100"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["Weight", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "pdf" => "summary",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Weight (lbs)"]
      }
    }

    @fields = {
      "Weight" => {
        "label" => "Weight (lbs):",
        "type" => "keyboard",
        "required" => true,
        "min" => "0.0",
        "max" => "999.9",
        "minDelta" => 0.1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

  end

  # after (:all) do
  #   quitDriver()
  # end

  # Obsolete
  # it "AC #JRNL-391|TC #JRNL-602: Weight will be a topic under Vitals from the left Navigation Menu" do
  # end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC#JRNL-392|TC#JRNL-602|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required fields validation; User will be able to ADD/EDIT/DELETE entries; Display 'Weight' with '(lbs)' Boundary Test for Weight; Verify the max allowed characters for Note" do

    it ".Display 'Weight' with '(lbs)' Boundary Test for Weight", :broken => true do
      fieldLabelTests(@fields)
    end

    it ".Error message presentation and Required fields validation
        .Verify the max allowed characters for Note", :broken => true do
      fieldRestrictionTests(@fields)
    end

    it ".header 'Add <personal tracker name> Entry'
        .User will be able to ADD entries", :broken => true do
      addTest(@fields, @addDataSet)
      #unsavedWarningModalTests()
    end

    it ".header 'Edit <personal tracker name> Entry'
        .User will be able to EDIT entries", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end
  end

  ##### OBSOLETE - PDF is now part of Health Reminders - Generated PDF Report
  # context "AC #JRNL-870|TC #JRNL-951: View PDF - Weight" do
  #   it ".View PDF - Weight", :broken => true do
  #     pdfTest()
  #   end
  # end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do

    it ".header '<personal tracker name>'", :broken => true do
      navigationTests()
    end

    it ".default filter state", :broken => true do
      refreshBrowser()

      !5.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to be true

      filterLabelsAndPlaceholdersTest()
    end

    it ".filtering data", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Weight")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end
  end

  context "AC #JRNL-393|TC #JRNL-602 Entries will be sorted in reverse chronological order
          AC #JRNL-393|TC #JRNL-602: Display User Entered Data" do

    it ".table headers", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Entries will be sorted in reverse chronological order
        .Display User Entered Data", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end
  end

  context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
           AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
           AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830: Text description guidance text update" do
    it ".The graph will display the date range that is currently being displayed
        .Display Graph in detail pane
        .Table View can be selected
        .Text description guidance text update", :broken => true do
      graphTest()
    end
  end

  context "AC #JRNL-392|TC #JRNL-602: User should be able to DELETE entries" do
    it ".User should be able to DELETE entries", :broken => true do
      deleteTest()
    end
  end

end













