require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-58: Temperature: Enter Delete Edit Validate]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")
    
    @baseNav = "Temperature"
    @expectedHeaders = {"add" => "Add Temperature Entry", "edit" => "Edit Temperature Entry", "summary" => "Temperature", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Temperature (\u00B0F)", "Type", "Date Entered"]
    @phoneTableHeaders = ["Temperature (\u00B0F)", "Date Entered"]

    @addDataSet = [{"Temperature" => "95", "Type" => "Oral"},
      {"Temperature" => "99.9", "Type" => "Rectal"},
      {"Temperature" => "98", "Type" => "Axillary"}]

    @editDataSet = [{"Temperature" => "106", "Type" => "Tympanic"},
      {"Temperature" => "97.3", "Type" => "Axillary"},
      {"Temperature" => "99", "Type" => "Oral"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["Temperature", "Type", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Temperature (\u00B0F)"]
      }
    }

    @fields = {
      "Temperature" => {
        "label" => "Temperature (\u00B0F):",
        "type" => "keyboard",
        "required" => true,
        "min" => "95.0",
        "max" => "106.0",
        "minDelta" => 0.1
      },
      "Type" => {
        "label" => "Type:",
        "type" => "select",
        "options" => ["", "Oral", "Tympanic", "Rectal", "Axillary"]
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  # after (:all) do
  #   quitDriver()
  # end

  # Obsolete
  # it "AC #JRNL-385|TC #JRNL-609: Temperature will be a topic under Vitals from the left Navigation Menu" do
  # end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
            AC#JRNL-386|TC #JRNL-609|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries; Display 'Temperature' with (\u00B0F); Boundary Test for Temperature; Verify the max allowed characters for Note" do

    it ".Display 'Temperature' with (\u00B0F)", :broken => true do
      fieldLabelTests(@fields)
    end

    it ".Error message presentation and Required field testing
        .Boundary Test for Temperature
        .Verify the max allowed characters for Note", :broken => true do

      #fieldRestrictionTests(@fields)
        @main.clickNavMenu()
        fieldLabelTests(@fields)
        waitForPageToFinishLoading
        @driver.find_element(:id, "PersonalTrackers").click
        waitForPageToFinishLoading
        @driver.find_element(:css, "button[class='btn btn-default temperature']").click
        waitForPageToFinishLoading
    end

    it ".header 'Add <personal tracker name> Entry'
        .User will be able to ADD entries", :broken => true do
      addTest(@fields, @addDataSet)

      unsavedWarningModalTests()
    end

    it ".header 'Edit <personal tracker name> Entry'
        .User will be able to EDIT entries", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end
  end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do

    it ".header '<personal tracker name>'", :broken => true do
      #navigationTests()
      @nav_menu.navigate(@baseNav)

      !MAX_WAIT_LOOPS.times { break if (getMainHeader() == @expectedHeaders["title"]); sleep WAIT_LOOP_SLEEP_TIME }

      expect(getMainHeader()).to eq("Personal Trackers")
      expect(getSecondaryHeader()).to eq(@expectedHeaders["secondary"])
      expect(getPrimaryHeader()).to eq("Temperature")
    end

    it ".default filter state", :broken => true do
      refreshBrowser()

      !5.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to be true

      filterLabelsAndPlaceholdersTest()
    end

    it ".filtering data", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end
  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !5.times { break if (getFocusedElementText().include?("Temperature")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end
  end

  context "AC #JRNL-387|TC #JRNL-609 Entries will be sorted in reverse chronological order
          AC #JRNL-387|TC #JRNL-609: Display User Entered Data" do

    it ".table headers", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Display User Entered Data
        .Entries will be sorted in reverse chronological order" , :broken => true do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end
  end

  context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
           AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
           AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830:  Text description guidance text update" do
    it ".User can select date range for pain graph view
        .User will be able to see table view
        .User can select graph and see graph view", :broken => true do
      graphTest()
    end
  end

  context "AC #JRNL-386|TC #JRNL-609: User should be able to DELETE entries" do
    it ".User should be able to DELETE entries", :broken => true do
      deleteTest()
    end
  end

end