require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1784: Stress List View and Filter]", :regression => true  do

  before(:all) do
    @FILTER_EXPANDED = [
        "* required field",
        "Date Range:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Filter Reset"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("stress", "medicalhistorydb", "stress")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1601|TC JRNL-1548: Sub Feature Selection" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("Stress")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Stress"]["navButton"])).to eq("Stress")
    end

    it "Location" do
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do | menuItem, i |
        if(i > 0)
          expect(menuItem.text() <=> menu[i-1].text()).to eq(1)
        end
      end
    end
    
  end

  describe "AC JRNL-1600|TC JRNL-1548: Filter and Table" do

    it "Screen Header" do
      @nav_menu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == StressFilter::HEADER); sleep 1 }
      expect(getPrimaryHeader()).to eq(StressFilter::HEADER)
    end

    it "Focus" do
      expect(getFocusedElementText()).to eq(StressFilter::HEADER)
    end

    it "Content (Filter Expanded)", :broken => true do
      filterScreen = @stressFilter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Default", :broken => true do
      expect(@stressFilter.isFilterAccordionExpanded()).to be(true)
      expect(@stressFilter.getFilterAccordionTitle()).to eq("Collapse filter options")

      @stressFilter.clickFilterAccordion()
      sleep 1
      expect(@stressFilter.isFilterAccordionExpanded()).to be(false)
      expect(@stressFilter.getFilterAccordionTitle()).to eq("Expand filter options")

      @stressFilter.clickFilterAccordion()
      sleep 1
      expect(getLongFieldLabel("startDate")).to eq("* Start Date:")
      expect(getLongFieldLabel("endDate")).to eq("* End Date:")

      expect(getPlaceHolderByCSS(:css, StressFilter::START_DATE)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, StressFilter::END_DATE)).to eq("MM/DD/YYYY")
    end

    it "Content (Filter Collapsed)", :broken => true do
      filterCollapsed = []

      @stressFilter.clickFilterAccordion()
      sleep 1
      filterScreen = @stressFilter.getScreenContent().split("\n")

      filterCollapsed.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Button", :broken => true do
      @stressFilter.clickFilterAccordion()
      sleep 1
      expect(@stressFilter.getFilterButtonLabel()).to eq("Filter")
    end

    describe "Filter Options" do

      it "Start Date" do
        thenDate = DateTime.now() - 30

        expect(@stressFilter.getTextFromInput(:css, StressFilter::START_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
        expect(@stressFilter.isFieldRequired(:css, StressFilter::START_DATE)).to eq(true)
      end

      it "End Date" do
        now = DateTime.now()

        expect(@stressFilter.getTextFromInput(:css, StressFilter::END_DATE)).to eq(now.strftime("%m/%d/%Y"))
        expect(@stressFilter.isFieldRequired(:css, StressFilter::END_DATE)).to eq(true)
      end

      it "Date Validation", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @stressFilter.setInput(StressFilter::START_DATE, "")
        @stressFilter.setInput(StressFilter::END_DATE, "")

        @stressFilter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        @stressFilter.setInput(StressFilter::START_DATE, "12")
        @stressFilter.setInput(StressFilter::END_DATE, "12")

        @stressFilter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        @stressFilter.click(:css, StressFilter::START_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep(1) }
        @date_picker.setDateFromGUI(12, 12, 2013)
        sleep(2)

        @stressFilter.click(:css, StressFilter::END_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep(1) }
        @date_picker.setDateFromGUI(12, 12, 2012)
        sleep(2)

        @stressFilter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @stressFilter.setInput(StressFilter::START_DATE, futureDate)
          @stressFilter.setInput(StressFilter::END_DATE, futureDate)

          @stressFilter.clickFilterBtn()
          !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end
      end

    end

  end

  describe "AC JRNL-1599|TC JRNL-1548: Filter Action and Results Display" do

    it "Table Headers", :broken => true do
      @stressFilter.setDateRangeAndFilter("01/01/2010", "11/11/2014")
      !10.times{ break if (@stressFilter.getFocusedElementText().include?("Stress Rating")); sleep 1 }
      expect(@stressFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getTableHeaders()).to eq(["Stress Rating (0=Low, 10=High)", "Date Entered"])
    end

    describe "When Records Are Found" do

      it "Sorted Reverse Chronologically (All Dates Within Filter Range)", :broken => true do
        expect(getCount()).to eq(8)

        verifyList(getList(), getFilteredList("2010-01-01", "2014-11-11"))
      end

      it "Date Equal To Start Date Filter", :broken => true do
        @stressFilter.setFromDate("12/12/2012")

        @stressFilter.clickFilterBtn()
        !10.times{ break if (@stressFilter.getFocusedElementText().include?("Stress Rating")); sleep 1 }
        expect(@stressFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
        expect(getCount()).to eq(6)

        verifyList(getList(), getFilteredList("2012-12-12", "2014-11-11"))
      end

      it "Date Equal To End Date Filter", :broken => true do
        @stressFilter.setEndDate("12/12/2013")

        @stressFilter.clickFilterBtn()
        !10.times{ break if (@stressFilter.getFocusedElementText().include?("Stress Rating")); sleep 1 }
        expect(@stressFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
        expect(getCount()).to eq(4)

        verifyList(getList(), getFilteredList("2012-12-12", "2013-12-12"))
      end

    end

    describe "When No Records Found" do

      it "Message" do
        @stressFilter.setDateRangeAndFilter("05/05/2013", "06/06/2013")
        !10.times{ break if (@stressFilter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@stressFilter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyList(getList(), getFilteredList("2013-05-05", "2013-06-06"))
      end

    end

    describe "Story JRNL-1696|AC JRNL-1583: Reset Button" do

      it "Visible" do
        expect(@stressFilter.isResetButtonPresent()).to eq(true)
      end

      it "Label" do
        expect(@stressFilter.getResetButtonLabel()).to eq("Reset")
      end

      it "Result" do
        nowDate = DateTime.now()
        thenDate = nowDate - 30

        @stressFilter.clickResetBtn()
        !10.times {
          break if (@stressFilter.getFocusedElementText().include?("Stress Rating") or
                    @stressFilter.getFocusedElementText().include?("No results"));
          sleep 1
        }
        verifyList(getList(), getFilteredList(thenDate.strftime("%Y-%m-%d"), nowDate.strftime("%Y-%m-%d")))

        # DEFAULT
        expect(@stressFilter.getTextFromInput(:css, StressFilter::START_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
        expect(@stressFilter.getTextFromInput(:css, StressFilter::END_DATE)).to eq(nowDate.strftime("%m/%d/%Y"))
      end

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllRecordsInDBSorted
    def sortByKeys(x,y)
      if y["entryDate"].strftime('%Y%m%d%H%M') == x["entryDate"].strftime('%Y%m%d%H%M')
        return x["severity"] <=> y["severity"]
      end
      return y["entryDate"].strftime('%Y%m%d%H%M') <=> x["entryDate"].strftime('%Y%m%d%H%M')
    end

    return retreiveAllDocumentsInCollection("stress", "medicalhistorydb").sort { |x, y| sortByKeys(x,y) }
  end

  def getFilteredList(startDate, endDate)
    dateMatch = []
    # puts getAllRecordsInDBSorted()
    getAllRecordsInDBSorted.each_with_index do |event, i|
      if event["entryDate"].strftime('%Y%m%d%H%M') >= DateTime.parse(startDate).strftime('%Y%m%d0000') && event["entryDate"].strftime('%Y%m%d%H%M') <= DateTime.parse(endDate).strftime('%Y%m%d2359')
        dateMatch << event
      end
    end

    return dateMatch
  end

  def verifyList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip).to eq(dbrow["severity"].to_s() + " out of 10")
      expect(screenRow[3].strip).to eq(formatFullDateTime(dbrow["entryDate"]))
    end
  end

end
