require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1783: Personal Trackers - Stress - Graph]", :broken => true, :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("stress", "medicalhistorydb", "stress")
    initializeAllObjects

    @graphInfo = {
        "xAxisLabels" => ["Date/Time"],
        "yAxisLabels" => ["Stress Rating (0=Low, 10=High)"]
    }

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @nav_menu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
    !45.times{ break if (getPrimaryHeader() == "Stress"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Stress")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1360|TC JRNL-1327: Graph Button and Features" do

    it "Button Visibility" do
      expect(is_element_present(:css, graphButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, graphButton())).to eq("Graph")
    end

    it "Button Alt Text" do
      expect(getElement(:css, graphButton()).attribute("title")).to eq("Graph")
    end

    it "Toggle" do
      from = "01/01/2010"
      to = "01/01/2015"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getFocusedElementText().include?("Stress Rating")); sleep 1 }
      expect(getFocusedElementText().include?("Stress Rating")).to eq(true)

      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(false)

      click(:css, graphButton())
      !30.times{ break if(isElementPresentAndVisible(:css, graphContainer()) == true); sleep 1 }
      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(true)
    end

    it "Button Visibility" do
      expect(is_element_present(:css, tableButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, tableButton())).to eq("Table")
    end

    it "Button Alt Text" do
      expect(getElement(:css, tableButton()).attribute("title")).to eq("Table")
    end

    it "Informational Text" do
      expect(getTextForElement(:css, viewTableMessage())).to eq("A text description of the information on this page is available in the table view.")
    end

    it "Graph Title" do
      expect(getGraphTitle()).to eq("Stress Ratings from 01/01/2010 to 01/01/2015")
    end

    it "Plot Point Count" do
      expect(getNumberOfPoints()).to eq(8)
    end


    it "X-Axis Label" do
      xAxisLabels = getXAxisLabels()

      for i in 0...@graphInfo["xAxisLabels"].length
        expect(xAxisLabels[i]).to eq(@graphInfo["xAxisLabels"][i])
      end
    end

    it "Y-Axis Label" do
      yAxisLabels = getYAxisLabels()

      for i in 0...@graphInfo["yAxisLabels"].length
        expect(yAxisLabels[i]).to eq(@graphInfo["yAxisLabels"][i])
      end
    end

    it "Y-Axis Ticks" do
      yTicks = getYAxisTicks()

      expect(yTicks.length).to eq(11)

      ## Need to verify every y axis tick since they will always be the same (according to the AC)
      for i in 0...yTicks.length
        expect(yTicks[i].to_i).to eq(i)
      end
    end

    it "X-Axis Ticks" do
      xTicks = getXAxisTicks()

      ## Don't need to verify every x axis tick since they will change with the filter dates.
      ## Just verify that the first and last are consistent with the filter start and end date
      expect(xTicks[0]).to eq("Jan 2010")
      expect(xTicks[xTicks.length - 1]).to eq("Jan 2015")
    end

    it "Scalable X-Axis Ticks - MMM DD" do
      from = "12/10/2013"
      to = "01/01/2014"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getGraphTitle()) == "Stress Ratings from #{from} to #{to}" }
      expect(getGraphTitle()).to eq("Stress Ratings from #{from} to #{to}")

      xTicks = getXAxisTicks()
      expect(xTicks[0]).to eq("Dec 10")
      expect(xTicks[xTicks.length - 1]).to eq("Jan 1")
    end

    it "Scalable X-Axis Ticks - MMM DD HH:MM AM/PM" do
      from = "01/01/2014"
      to = "01/01/2014"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getGraphTitle()) == "Stress Ratings from #{from} to #{to}" }
      expect(getGraphTitle()).to eq("Stress Ratings from #{from} to #{to}")

      xTicks = getXAxisTicks()
      tickMarks = [ "Jan 1", "Jan 1 03:00 AM", "Jan 1 06:00 AM", "Jan 1 09:00 AM",
                    "Jan 1 12:00 PM", "Jan 1 03:00 PM", "Jan 1 06:00 PM",
                    "Jan 1 09:00 PM", "Jan 2"
      ]
      tickMarks.each_with_index do | tickMark, i|
        expect(xTicks[i]).to eq(tickMark)
      end
    end

   it "Y-Axis Ticks Remains Unchanged with X-Axis Scaling" do
      yTicks = getYAxisTicks()

      expect(yTicks.length).to eq(11)

      ## Need to verify every y axis tick since they will always be the same (according to the AC)
      for i in 0...yTicks.length
        expect(yTicks[i].to_i).to eq(i)
      end
    end


    it "Legend Visibility" do
      expect(isLegendDisplayed?()).to eq(true)
    end

    it "Legend Content" do
      expect(getLegendContent()).to eq("Stress")
    end

  end

  describe "AC JRNL-1359|TC JRNL-1327: Graph Data Display" do

    it "Change Filter Dates" do
      from = "12/01/2012"
      to = "12/31/2013"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getGraphTitle()) == "Stress Ratings from #{from} to #{to}" }
      expect(getGraphTitle()).to eq("Stress Ratings from #{from} to #{to}")

      expect(getNumberOfPoints()).to eq(4)
    end

    it "Row Count" do
      click(:css, tableButton())
      !30.times{ break if(isElementPresentAndVisible(:css, graphContainer()) == false); sleep 1 }
      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(false)

      expect(getCount()).to eq(4)
    end

    it "Filter Persists" do
      expect(@date_filter.getStartDate()).to eq("12/01/2012")
      expect(@date_filter.getEndDate()).to eq("12/31/2013")
    end

  end

end
