require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1677: Stress - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do

    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "Stress (0=Low, 10=High):",
        "0",
        "Slider on",
        "10",
        "Note:",
        "250 character maximum",
        "250 characters left"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("stress", "medicalhistorydb", "stress")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
    !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
    expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

    @numberOfRecords = 8
    
    @stressFilter.setInput(StressFilter::START_DATE, "01/01/2010")
    @stressFilter.clickFilterBtn()
    !10.times{ break if (@stressFilter.getFocusedElementText().include?("Stress Rating")); sleep 1 }
    expect(@stressFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
    
    expect(getCount()).to eq(@numberOfRecords)

    @countBeforeDelete = retreiveAllDocumentsInCollection("stress", "medicalhistorydb").length()
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1596|TC JRNL-1544: When Selecting An Entry" do

    it "Header" do
      clickNthRow(8)
      !45.times{ break if( @stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1}
      expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)
    end

    it "Previously-Saved Values" do
      expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("01/01/2012")
      expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("12:00 AM")
      expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("10")
      expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("")
      expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
    end

    describe "Entry Page" do

      it "Content" do
        @stress.getScreenContent().split("\n").each_with_index do | screenRow, i |
          break if (screenRow == "250 characters left" )
          expect(screenRow).to eq(@ENTRY_FORM[i])
        end
      end

      it "Required" do
        expect(@stress.isFieldRequired(:css, Stress::DATE)).to eq(true)
        expect(@stress.isFieldRequired(:css, Stress::TIME)).to eq(true)
        expect(@stress.isFieldRequired(:css, Stress::STRESS)).to eq(false)
        expect(@stress.isFieldRequired(:css, Stress::NOTE)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @stress.setInput(Stress::DATE, "")
        @stress.setInput(Stress::TIME, "")

        @stress.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        @stress.setInput(Stress::DATE, "11/01")
        @stress.setInput(Stress::TIME, "03")

        @stress.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @stress.setInput(Stress::DATE, futureDate)
          @stress.setInput(Stress::TIME, formatTimeAMPM(Time.now()))
          @stress.clickSaveButton()

          !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
        end

        @stress.setInput(Stress::DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @stress.setInput(Stress::TIME, time)

        @stress.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end

    end

    describe "AC JRNL-1595|TC JRNL-1544: Standard Functions Available" do

      it "Cancel" do
        expect(@stress.isCancelButtonVisible()).to eq(true)

        @stress.clickCancelButton()
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(8)
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

        expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("01/01/2012")
        expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("12:00 AM")
        expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("10")
        expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("")
        expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")

        expect(@stress.isCancelButtonVisible()).to eq(true)

        @stress.clickCancelButton()
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Delete" do
        clickNthRow(1)
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

        expect(@stress.isDeleteButtonVisible()).to eq(true)

        @stress.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@stress.getFocusedElementText()).to eq("Delete")

        @stress.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        expect(retreiveAllDocumentsInCollection("stress", "medicalhistorydb").length()).to eq(@countBeforeDelete)
      end

      describe "Save" do

        it "Min" do
          clickNthRow(7)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          @stress.setInput(Stress::DATE, "11/11/2010")
          @stress.setInput(Stress::TIME, "03:30 PM")
          @stress.moveArrowInputRangeToLeft("stress", 10)

          @stress.clickSaveButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

        it "Verify Saved Data" do
          clickNthRow(7)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("11/11/2010")
          expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("03:30 PM")
          expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("0")
          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("")
        end

        it "Max" do
          @stress.setInput(Stress::DATE, "11/18/2014")
          @stress.setInput(Stress::TIME, "07:10 AM")
          @stress.moveArrowInputRangeToRight("stress", 10)
          @stress.setInput(Stress::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

          @stress.setInput(Stress::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@stress.getTextFromInput(:css, Stress::NOTE).length()).to eq(250)
          expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          @stress.clickSaveButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("11/18/2014")
          expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("07:10 AM")
          expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("10")
          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@stress.getTextFromInput(:css, Stress::NOTE).length()).to eq(250)
          expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
        end

      end

    end

    describe "AC JRNL-1594|TC JRNL-1544: Navigation" do

      describe "Clicking Menu" do

        it "No Changes" do
          @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)
        end

        it "Changes" do
          clickNthRow(1)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          @stress.setInput(Stress::NOTE, "XYZ")

          @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
        end

      end

      describe "Back Button" do

        it "Alt Text" do
          expect(@stress.getBackButtonAltText()).to eq("Return to Previous Screen")
        end

        it "No Changes" do
          @common.clickBackButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)
        end

        it "Changes" do
          clickNthRow(1)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          @stress.setInput(Stress::NOTE, "XYZ")

          @stress.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          @stress.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")

          @stress.clickCancelButton()
          !45.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)
        end

      end

    end

  end

end
