require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1677: Stress - Add]", :broken => true, :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        "* required field",
        "*",
        "Required: Date: M M / D D / Y Y Y Y:",
        "Date:",
        "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
        "Day selected is Wednesday",
        "Wednesday",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "Stress (0=Low, 10=High):",
        "0",
        "10",
        "Slider on",
        "5",
        "Note:",
        "250 character maximum",
        "250 characters left"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("stress", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest")

    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    waitForPageToFinishLoading
    @driver.find_element(:id, "PersonalTrackers").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
    !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
    expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

    expect(getCount()).to eq(0)

    @stressFilter.setDateRangeAndFilter("01/01/2012", "11/17/2014")
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1597|TC-3281: Add Button" do

    it "Visible" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

    it "Alt Text" do
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

  end

  describe "AC JRNL-1597|TC-3281: When Selecting Add" do

    it "Header" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[title='Add']").click
      waitForPageToFinishLoading
      !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
      expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)
    end

    describe "Detailed Fields" do

      it "Screen Content" do
        @stress.getScreenContent().split("\n").each_with_index do | screenRow, i |
          break if (screenRow == "250 characters left" )
          expect(screenRow).to eq(@ENTRY_FORM[i])
        end
      end

      it "Date" do
        expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq(Time.new().strftime("%m/%d/%Y"))
        expect(@stress.isFieldRequired(:css, Stress::DATE)).to eq(true)
      end

      it "Time" do
        #expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq(formatTimeAMPM(Time.new()))
        expect(@stress.isFieldRequired(:css, Stress::TIME)).to eq(true)
      end

      it "Stress" do
        expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("5")
        expect(@stress.isFieldRequired(:css, Stress::STRESS)).to eq(false)
      end

      it "Note" do
        expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("")
        expect(@stress.isFieldRequired(:css, Stress::NOTE)).to eq(false)
        expect(@stress.is_element_present(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq(true)
        expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @stress.setInput(Stress::DATE, "")
        @stress.setInput(Stress::TIME, "")

        @stress.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        @stress.setInput(Stress::DATE, "11/01")
        @stress.setInput(Stress::TIME, "03")

        @stress.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @stress.setInput(Stress::DATE, futureDate)
          @stress.setInput(Stress::TIME, formatTimeAMPM(Time.now()))
          @stress.clickSaveButton()

          !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
        end

        @stress.setInput(Stress::DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @stress.setInput(Stress::TIME, time)

        @stress.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end

    end

    describe "AC JRNL-1595|TC JRNL-1549: Standard Save and Cancel Options" do

      it "Cancel" do
        expect(@stress.isCancelButtonVisible()).to eq(true)

        @stress.clickCancelButton()
        !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)
      end

      describe "Save" do

        it "Min" do
          @common.clickAddButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @driver.find_element(:id, "date").clear
          @driver.find_element(:id, "date").send_keys "11/11/2014"
          expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("11/11/2014")

          @driver.find_element(:id, "time").clear
          @driver.find_element(:id, "time").send_keys "02:35 PM"
          expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("02:35 PM")

          @stress.moveArrowInputRangeToLeft("stress", 5)

          @stress.clickSaveButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getFocusedElementText()).to eq(Stress::HEADER)
        end

        it "Verify Saved Data" do
          @driver.find_element(:xpath, "//span[@class='table-last-col icon icon-nav-right-arrow']").click
          waitForPageToFinishLoading
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("11/12/2014")
          expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("07:10 AM")
          expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("10")
          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
        end

        it "Max" do
          @stress.clickCancelButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)

          @common.clickAddButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @stress.setInput(Stress::DATE, "11/12/2014")
          @stress.setInput(Stress::TIME, "07:10 AM")
          @stress.moveArrowInputRangeToRight("stress", 5)
          @stress.setInput(Stress::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

          @stress.setInput(Stress::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@stress.getTextFromInput(:css, Stress::NOTE).length()).to eq(250)
          expect(@stress.getTextForElement(:css, Stress::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          waitForPageToFinishLoading
          @driver.find_element(:css, "button[ng-click='confirmSave()']").click
          waitForPageToFinishLoading
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getFocusedElementText()).to eq(Stress::HEADER)
        end

        it "Verify Saved Data" do
          waitForPageToFinishLoading
          @driver.find_element(:xpath, "//span[@class='table-last-col icon icon-nav-right-arrow']").click
          waitForPageToFinishLoading
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::EDIT_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::EDIT_HEADER)

          expect(@stress.getTextFromInput(:css, Stress::DATE)).to eq("11/12/2014")
          expect(@stress.getTextFromInput(:css, Stress::TIME)).to eq("07:10 AM")
          expect(@stress.getTextFromInput(:css, Stress::STRESS)).to eq("10")
          expect(@stress.getTextFromInput(:css, Stress::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@stress.getTextFromInput(:css, Stress::NOTE).length()).to eq(250)
        end
      end
    end

    describe "AC JRNL-1594|TC JRNL-1549: Navigation Without Saving" do

      it "Back Button Alt Text" do
        expect(@stress.getBackButtonAltText()).to eq("Return to Previous Screen")
      end

      context "Clicking Back Button" do

        it "No changes" do
          @stress.clickBackButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        end

        it "Changes" do
          @common.clickAddButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @stress.setInput(Stress::NOTE, "XYZ")

          @stress.clickBackButton()
          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
          expect(@modal.getCancelButtonText()).to eq("Return to Form")

          @modal.clickReturnButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @stress.clickBackButton()
          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
          expect(@modal.getCancelButtonText()).to eq("Return to Form")

          @modal.clickContinueButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::HEADER)
        end
      end

      context "Clicking Menu Item" do

        it "No changes" do
          waitForPageToFinishLoading
          @driver.find_element(:css, "button[title='Add']").click
          waitForPageToFinishLoading
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::HEADER); sleep 1 }
        end

        it "Changes" do
          waitForPageToFinishLoading
          @driver.find_element(:css, "button[title='Add']").click
          waitForPageToFinishLoading
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)

          @stress.setInput(Stress::NOTE, "XYZ")

          @navMenu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
          expect(@modal.getCancelButtonText()).to eq("Return to Form")

          @modal.clickReturnButton()
          !5.times{ break if (@stress.getPrimaryHeader() == Stress::ADD_HEADER); sleep 1 }
          expect(@stress.getPrimaryHeader()).to eq(Stress::ADD_HEADER)
          waitForPageToFinishLoading
          @driver.find_element(:css, "button[ng-click='cancel()']").click
          waitForPageToFinishLoading
        end
      end
    end
  end
end
