require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1782: [Sleep Tracker - List and Filter View]", :regression => true do

  header_text = "Personal Trackers"
  sleep_header_text = "sleep"
  startDate = "startDate"
  startTime = "startTime"
  endDate = "endDate"
  endTime = "endTime"
  notes = "Note"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("sleep", "medicalhistorydb")

    initializeAllObjects
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{break if(@nav_menu.getNavMenuHeading()== "App Options"); sleep 1}
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context 'AC#JRNL-1593,JRNL-1592,JRNL-1591|TC #JRNL-1646:Sub Feature Selection for Sleep Tracker; Sub Feature Default View for Sleep Tracker; Filter Action and Results Display for Sleep Tracker' do

    it "Personal Trackers table list inside 'Sleep' view", :broken => true do
      waitForPageToFinishLoading
      @driver.find_element(:id, "PersonalTrackers").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default sleep']").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader()== sleep_header_text); sleep 1}
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")
#      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

    end

    it "Filter Control", :broken => true do
      @date_filter.clickFilterAccordion()
      !3.times{ break if(@date_filter.isFilterAccordionExpanded() == false); sleep 1 }
      expect(@date_filter.isFilterAccordionExpanded()).to eq(false)
      expect(@date_filter.isFilterButtonVisible()).to eq(false)

      @date_filter.clickFilterAccordion()
      !3.times{ break if(@date_filter.isFilterAccordionExpanded()); sleep 1 }
      expect(@date_filter.isFilterAccordionExpanded()).to eq(true)
    end

    it "Start Date", :broken => true do
      expect(@date_filter.getStartDateLabel()).to eq("")
      expect(@date_filter.isStartDateRequiredField()).to eq(true)
      expect(@date_filter.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")
    end

    it "End Date", :broken => true do
      expect(@date_filter.getEndDateLabel()).to eq("")
      expect(@date_filter.isEndDateRequiredField()).to eq(true)
      expect(@date_filter.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")
    end

    it "Filter and Reset button", :broken => true do
      expect(@date_filter.isFilterButtonPresent()).to eq(true)
#      expect(@date_filter.isFilterButtonVisible()).to eq(true)
      expect(@date_filter.isResetButtonPresent()).to eq(true)
#      expect(@date_filter.isResetButtonVisible()).to eq(true)
    end

    it "Prevent Future date", :broken => true do
      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      errorHeader = "The following errors were found:"

      @date_filter.setFromDate(dayAfterTomorrow)
      @date_filter.setEndDate(tomorrow)

      @date_filter.clickFilterBtn()
      !3.times{ break if(@error.getValidationSummaryHeader("filterForm") == errorHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("filterForm")).to eq(errorHeader)
      @error.isErrorMessageDisplayed("filterForm","To Date must occur before End Date")
      @error.isErrorMessageDisplayed("filterForm","To date must be between 01/01/1900 and " + today + ".")
      @error.isErrorMessageDisplayed("filterForm","From date must be between 01/01/1900 and " + today + ".")

      sleep 2

      @date_filter.setFromDate("11/31/2013")
      @date_filter.setEndDate("09/31/2014")

      @date_filter.clickFilterBtn()
      !3.times{ break if(@error.getValidationSummaryHeader("filterForm") == errorHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("filterForm")).to eq(errorHeader)
      @error.isErrorMessageDisplayed("filterForm","Start Date is an invalid date")
      @error.isErrorMessageDisplayed("filterForm","End Date is an invalid date")

      sleep 2
    end

    it "Add Entry", :broken => true do
      #1st entry
      @common.clickAddButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
                         startDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
                         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
                         startTime => "01:00 AM",
                         endTime => "07:00 AM",
                         notes => "This is my sleeping log",
                     });

      @common.clickSaveButton()
      waitForPageToFinishLoading()

      #2nd entry
      @common.clickAddButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         startDate => getDateNthDaysAgo(2, "%m/%d/%Y"),
                         endDate => getDateNthDaysAgo(2, "%m/%d/%Y"),
                         startTime => "01:00 AM",
                         endTime => "07:30 AM",
                         notes => "This is my sleeping log",
                     });

      @common.clickSaveButton()
      waitForPageToFinishLoading()

      #3rd entry
      @common.clickAddButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         startDate => getDateNthDaysAgo(3, "%m/%d/%Y"),
                         endDate => getDateNthDaysAgo(3, "%m/%d/%Y"),
                         startTime => "12:10 AM",
                         endTime => "07:00 AM",
                         notes => "This is my sleeping log",
                     });

      @common.clickSaveButton()
      waitForPageToFinishLoading()
    end

    it "Filter Action and Results Display", :broken => true do
      @date_filter.clickResetBtn()
      waitForPageToFinishLoading()

      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
      twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
      threeDaysAgo = getDateNthDaysAgo(3, "%m/%d/%Y")
      sevenDaysAgo = getDateNthDaysAgo(7, "%m/%d/%Y")

      @date_filter.setFromDate(sevenDaysAgo)
      @date_filter.setEndDate(today)

      @date_filter.clickFilterBtn()
      waitForPageToFinishLoading()

      expect(getTableHeaders()).to eq(["Start Date/Time", "End Date/Time", "Time Slept"])

      expect(getTextForRowColumn(1,1)).to eq(yesterday + " 01:00 AM")
      expect(getTextForRowColumn(2,1)).to eq(twoDaysAgo + " 01:00 AM")
      expect(getTextForRowColumn(3,1)).to eq(threeDaysAgo + " 12:10 AM")

      # Expect false here because it is sorted reverse chronologically
      expect(isSortedByChronologicalOrder("%m/%d/%Y", 1)).to eq(false)
    end

    context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

      it "Visible", :broken => true do
        expect(@date_filter.isResetButtonPresent()).to eq(true)
      end

      it "Label", :broken => true do
        expect(@date_filter.getResetButtonLabel()).to eq("Reset")
      end

      it "Result", :broken => true do
        @date_filter.clickResetBtn()
        waitForPageToFinishLoading()

        expect(@date_filter.isDefaultDateRange()).to eq(true)
      end

    end

  end

  context 'AC #JRNL-1590 |TC #JRNL-1646: Navigation for Sleep Tracker ' do

    it "Verifying '<' button", :broken => true do
      #Resizing the window to phone size to verify button is present
      #resizeWindowTo(320, 480)
      expect(@common.isBackButtonVisible()).to eq(true)
    end

  end

end
