require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1781: Personal Trackers - Sleep - Graph]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("sleep", "medicalhistorydb", "sleep")

    initializeAllObjects

    @graphInfo = {
        "xAxisLabels" => ["Date"],
        "yAxisLabels" => ["Hours Slept"]
    }

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "PersonalTrackers").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    # Add Sleep that spans multiple days
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[class='btn btn-default sleep']").click
    waitForPageToFinishLoading
    !5.times{ break if(getPrimaryHeader() == "Sleep"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Sleep")

    @common.clickAddButton()
    !5.times{ break if (@personaltracker_form.getPrimaryHeader() == "Add Sleep Entry"); sleep 1 }
    expect(@personalTracker_form.getPrimaryHeader()).to eq("Add Sleep Entry")

    setInput(Sleep::STARTDATE, getDateNthDaysAgo(3, "%m/%d/%Y"))
    setInput(Sleep::STARTTIME, "06:00 AM")
    setInput(Sleep::ENDDATE, getDateNthDaysAgo(1, "%m/%d/%Y"))
    setInput(Sleep::ENDTIME, "06:00 PM")

    waitForPageToFinishLoading
    @driver.find_element(:css, "textarea[name='Note']").send_keys "Demo"
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[@ng-click='confirmSave()']").click
    waitForPageToFinishLoading


    !5.times{ break if (getPrimaryHeader() == "Sleep"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Sleep")
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1358|TC JRNL-1332: Graph button and Features for Sleep" do

    it "Screen Header" do
      @nav_menu.clickSleep()
      !5.times{ break if(getPrimaryHeader() == "Sleep"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Sleep")
    end

    it "Verify graph button is visible" do
      expect(is_element_present(:css, graphButton())).to eq(true)
    end

    it "Verify Button Text" do
      expect(getTextForElement(:css, graphButton())).to eq("Graph")
    end

    it "Verify button alt text" do
      expect(getElement(:css, graphButton()).attribute("title")).to eq("Graph")
    end

    it "Verify if clicked, toggles to Table button", :broken => true do
      @date_filter.setDateRangeAndFilter("11/11/1900", "01/25/2015")
      !5.times{ break if(getCount() == 7); sleep 1 }
      expect(getCount()).to eq(7)

      click(:css, graphButton())
      expect(is_element_present(:css, graphButton())).to eq(false)
      expect(is_element_present(:css, tableButton())).to eq(true)
      expect(getTextForElement(:css, tableButton())).to eq("Table")
      expect(getElement(:css, tableButton()).attribute("title")).to eq("Table")
    end

    it "Verify Graph Title", :broken => true do
      expect(getGraphTitle()).to eq("Quantity and Quality of Sleep from 11/11/1900 to 01/25/2015")
    end

    it "Verify text below filter", :broken => true do
      expect(getTextForElement(:css, viewTableMessage())).to eq("A text description of the information on this page is available in the table view.")
    end

    it "Plot Point Count", :broken => true do
      expect(getNumberOfBars()).to eq(11)
    end

    it "Verify x-axis label", :broken => true do
      xAxisLabels = getXAxisLabels()

      numXAxisLabels = @graphInfo["xAxisLabels"].length

      for i in 0...numXAxisLabels
        expect(xAxisLabels[i]).to eq(@graphInfo["xAxisLabels"][i])
      end

    end

    it "Verify y-axis label", :broken => true do
      yAxisLabels = getYAxisLabels()

      numYAxisLabels = @graphInfo["yAxisLabels"].length

      for i in 0...numYAxisLabels
        expect(yAxisLabels[i]).to eq(@graphInfo["yAxisLabels"][i])
      end
    end

    it "Verify legend", :broken => true do
      expect(isBarLegendDisplayed?()).to eq(true)
      legendContent = getBarLegendContent()

      expect(legendContent.include? "Color Quality Rating (1=Poor, 10=Excellent)").to eq(true)
      expect(legendContent.include? "1-2").to eq(true)
      expect(legendContent.include? "3-4").to eq(true)
      expect(legendContent.include? "5-6").to eq(true)
      expect(legendContent.include? "5-6").to eq(true)
      expect(legendContent.include? "7-8").to eq(true)
      expect(legendContent.include? "9-10").to eq(true)
    end

    it "Verify Y-Axis Ticks" do
      hours_slept_ticks = ["01:00 PM", "04:30 PM", "08:00 PM", "11:30 PM", "03:00 AM", "06:30 AM", "10:00 AM", "12:59 PM"]

      getYAxisTicks().each_with_index do | tickMark, i|
        expect(tickMark).to eq(hours_slept_ticks[i])
      end
    end

    it "Verify X-Axis Ticks", :broken => true do
      from = getDateNthDaysAgo(30, "%m/%d/%Y")
      to = getDateNthDaysAgo(0, "%m/%d/%Y")

      @date_filter.clickResetBtn()
      sleep 2
      !3.times{ break if(getGraphTitle() == "Quantity and Quality of Sleep from #{from} to #{to}"); sleep 1}
      expect(getGraphTitle()).to eq("Quantity and Quality of Sleep from #{from} to #{to}")

      xAxisTicks = getXAxisTicks()
      #Tick marks always start with an even day, so if date range starts on an odd day, set dec
      #initially to 1 so that the start day (which is odd) minus 1 is an even day
      dec = 0
      start = getDateNthDaysAgo(30, "%d").to_i.odd? ? 30 : 31
      xAxisTicks.each_with_index do | tickMark, i|
        if(tickMark != "")
          expect(tickMark).to eq(getDateNthDaysAgo(start-dec, "%m/%d") + " -" + getDateNthDaysAgo(start-dec-1, "%m/%d"))
        end
        dec += 2
      end
    end

  end

  describe "AC JRNL-1357|TC JRNL-1332: Graph data display for Sleep Graph" do

    it "Change date filers and verify x & y axis", :broken => true do
      xAxisValues = getXAxisTicks()
      yAxisValues = getYAxisTicks()
      from = getDateNthDaysAgo(3, "%m/%d/%Y")
      to = getDateNthDaysAgo(0, "%m/%d/%Y")

      @date_filter.setDateRangeAndFilter(from, to)

      expect(getGraphTitle()).to eq("Quantity and Quality of Sleep from #{from} to #{to}")

      xAxisValuesNew = getXAxisTicks()
      yAxisValuesNew = getYAxisTicks()

      for i in 0...xAxisValuesNew.length
        expect(xAxisValuesNew[i]).to_not eq(xAxisValues[i])
      end

      for i in 0...yAxisValuesNew.length
        expect(yAxisValues[i]).to eq(yAxisValuesNew[i])
      end

      hours_slept_ticks = ["01:00 PM", "04:30 PM", "08:00 PM", "11:30 PM", "03:00 AM", "06:30 AM", "10:00 AM", "12:59 PM"]

      yAxisValuesNew.each_with_index do | tickMark, i|
        expect(tickMark).to eq(hours_slept_ticks[i])
      end

      xAxisValuesNew.each_with_index do | tickMark, i|
        expect(tickMark).to eq(getDateNthDaysAgo(4-i, "%m/%d") + " -" + getDateNthDaysAgo(4-(i+1), "%m/%d"))
      end
    end

    it "Verify bar count in graph view", :broken => true do
      ## -1 because there is a hidden bar
      expect(getNumberOfBars() - 1).to eq(3)
    end

    it "Verify row count in table view", :broken => true do
      click(:css, tableButton())

      expect(getCount()).to eq(1)
    end

    it "Verify filter is the same in table view", :broken => true do
      from = getDateNthDaysAgo(3, "%m/%d/%Y")
      to = getDateNthDaysAgo(0, "%m/%d/%Y")

      expect(@date_filter.getStartDate()).to eq(from)
      expect(@date_filter.getEndDate()).to eq(to)
    end

  end

  ##########################################

  def isBarLegendDisplayed?()
    return isElementVisible(:css, "#sleep-graph-legend")
  end

  def getBarLegendContent()
    return getTextForElement(:css, "#sleep-graph-legend")
  end

end