require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1672,JRNL-1569: [PersonalTrackers_Sleep_Add_Edit_Delete_JRNL_1672_1569_spec.rb] Sleep Quality", :broken => true, :regression => true do
  include DriverUtility
  include CommonTests
  include MongoUtility
  include Table

  header_text = "Personal Trackers"
  sleep_header_text = "Sleep"
  add_header_text = "Add Sleep Entry"
  edit_header_text = "Edit Sleep Entry"
  startDate = "startDate"
  startTime = "startTime"
  endDate = "endDate"
  endTime = "endTime"
  sleep_quality = "sleepQuality"
  note = "Note"

  before(:all) do
    @ENTRY_FORM_SLEEP = [
        "* required field",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Start Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "Time Slept:",
        "Hours:",
        "Minutes:",
        "Sleep Quality (1=Poor, 10=Excellent):",
        "1",
        "10",
        "Slider on",
        "5",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("sleep", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading()== "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1589|TC #JRNL-1511: Add New Entry for Sleep Tracker' do

    it "Sleep Tracker table list view" do
      @nav_menu.clickPersonalTrackers()
      !15.times { break if (getPrimaryHeader()== header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq(header_text)

      #Verify '+' button is visible and Alt Text is present
      @nav_menu.clickSleep()
      !15.times { break if (getPrimaryHeader()== sleep_header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq(sleep_header_text)
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

    it "Clicking the '+' button displays the Detail View" do
      @common.clickAddButton()
      !15.times { break if (getPrimaryHeader()== add_header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq(add_header_text)
    end

    it "Screen Content" do
      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        break if (screenRow == "250 characters left" )
        expect(screenRow).to eq(@ENTRY_FORM_SLEEP[i])
      end

      expect(@entry_form.getFormContent().split("\n").last).to eq(@ENTRY_FORM_SLEEP[-1])
    end

    it "Required Field Error Message Validation" do
      #Clicking the 'Save' button without entering any data
      @entry_form.clickSaveButton()
      !15.times { break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }

      #Verifying Error Messages
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
      # expect(@error.isErrorMessageDisplayed("form", "Category field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Start Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "End Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "End Time field is required.")).to eq(true)
    end

    it "Start Date Field" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(startDate, true)).to eq("Start Date:")
      expect(isFieldRequired(:css, Sleep::STARTDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Sleep::STARTDATE)).to eq("MM/DD/YYYY")
    end

    it "Start Time Field" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(startTime, true)).to eq("Start Time:")
      expect(isFieldRequired(:css, Sleep::STARTTIME)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Sleep::STARTTIME)).to eq("HH:MM AM/PM")
    end

    it "End Date Field" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(endDate, true)).to eq("End Date:")
      expect(isFieldRequired(:css, Sleep::ENDDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Sleep::ENDDATE)).to eq("MM/DD/YYYY")
    end

    it "End Time Field" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(endTime, true)).to eq("End Time:")
      expect(isFieldRequired(:css, Sleep::ENDTIME)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Sleep::ENDTIME)).to eq("HH:MM AM/PM")
    end

    it "Time Slept Read Only Display" do
      #Verifying Field labels for Time Slept, Hours and Minutes
      expect(getTextForElement(:css, Sleep::TIMESLEPT)).to eq("Time Slept:")
      expect(getTextForElement(:css, Sleep::HOURS)).to eq("Hours:")
      expect(getTextForElement(:css, Sleep::MINUTES)).to eq("Minutes:")
    end

    it "Story#JRNL-1569 Sleep Quality" do
      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("5")
      expect(@entry_form.isFieldRequired(:css, Sleep::SLEEP_QUALITY)).to eq(false)
    end

    it "Note" do
      expect(isFieldRequired(:css, Sleep::NOTE)).to eq(false)
      textareaMaxLengthTest(note, 250, true)
    end

    it "Save and Cancel buttons" do
      expect(@entry_form.isSaveButtonVisible()).to eq(true)
      expect(@entry_form.isCancelButtonVisible()).to eq(true)

      @entry_form.clickCancelButton()
      !15.times { break if (getPrimaryHeader() == sleep_header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq(sleep_header_text)
    end

  end

  context 'AC#JRNL-1587, JRNL-1588|TC #JRNL-1511: Save Sleep entry; Edit Sleep Entry; Cancel Sleep Entry., Story#3257 AC#JRNL-1458|TC#JRNL-1511: Sleep Quality' do

    it "Save Sleep Entry." do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"06:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 PM",
         note => "My Daily Nap."
      });

      #Clicking Save button
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      !30.times{ break if (getTextForRowColumn(1,3) == "12 hrs   0 mins"); sleep 1 }

      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,3)).to eq("12 hrs   0 mins")
    end

    it "Verify Sleep Quality" do
      #Selecting the previously saved entry from the table
      clickNthRow(1)
      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(edit_header_text)

      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("5")
      @entry_form.moveArrowInputRangeToRight(sleep_quality, 5)

      @entry_form.clickSaveButton()

      waitForPageToFinishLoading()
    end

    it "Cancel Sleep Entry" do
      #Selecting the previously saved entry from the table
      clickNthRow(1)
      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(edit_header_text)

      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("10")
      @entry_form.moveArrowInputRangeToLeft(sleep_quality, 9)

      #Editing all Required Fields
      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"02:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 AM",
         note => "My Daily Nap."
      });

      #Clicking Cancel and verifying that nothing was changed
      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()

      !30.times{ break if (getTextForRowColumn(1,3) == "12 hrs   0 mins"); sleep 1 }
      expect(getTextForRowColumn(1,3)).to eq("12 hrs   0 mins")
    end

    it "Edit Sleep Entry" do
      #Selecting the previously saved entry from the table
      clickNthRow(1)
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(edit_header_text)

      #Editing all Required Fields
      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"02:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 AM",
         note => "My Daily Nap."
      });

      #--Sleep Quality Value
      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("10")
      @entry_form.moveArrowInputRangeToLeft(sleep_quality, 9)
      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("1")

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      !30.times{ break if (getTextForRowColumn(1,3) == "4 hrs   0 mins"); sleep 1 }
      expect(getTextForRowColumn(1,3)).to eq("4 hrs   0 mins")
    end

  end

  context 'AC#JRNL-1587, JRNL-1588|TC #JRNL-1511: Delete Sleep Entry' do

    it "Delete Sleep Entry" do
      #Selecting a previously saved Entry
      clickNthRow(1)
      expect(getPrimaryHeader()).to eq(edit_header_text)

      expect(@entry_form.getTextFromInput(:css, Sleep::SLEEP_QUALITY)).to eq("1")

      #Verifying 'Delete' button is present
      expect(@entry_form.isDeleteButtonVisible()).to eq(true)

      #Deleting the Entry
      @entry_form.clickDeleteButton()

      #Vefirying the Confirmation Modal
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      #Clicking 'No' to return to the Edit Screen
      @modal.clickNoButton()
      expect(getPrimaryHeader()).to eq(edit_header_text)

      #Clicking Delete button again and Clicking 'Yes' in the Modal to Delete the entry
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(sleep_header_text)

      #Verifying the table is empty
      expect(getNoResultsFoundMessage()). to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

  end

  context 'AC#JRNL-1586|TC #JRNL-1511: Navigation for Sleep Entry.' do

    it "Verifying '<' button is present for Add View and it functions as expected" do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(add_header_text)

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(sleep_header_text)

      #Verifying No Results Message
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      #Verifying '<' button functionality after making changes on Add Screen
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(add_header_text)

      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"06:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 PM",
         note => "My Daily Nap."
      });

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Add View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq(add_header_text)

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(sleep_header_text)

      #Verifying no results message to check nothing was added
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

    it "Verifying '<' button is present for Edit View and it functions as expected" do
      #Adding and Saving an Entry to Edit
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(add_header_text)

      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"06:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 PM",
         note => "My Daily Nap."
      });

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,3)).to eq("12 hrs   0 mins")

      #Clicking on the Saved entry to open it in Edit View
      clickNthRow(1)
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(edit_header_text)

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()
      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(sleep_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,3)).to eq("12 hrs   0 mins")

      #Clicking on the Saved entry one more time to open it in Edit View
      clickNthRow(1)
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(edit_header_text)

      #Making changes and clicking the '<' button
      setEntryValues({
         startDate =>getDateNthDaysAgo(1, "%m/%d/%Y"),
         startTime=>"02:00 AM",
         endDate => getDateNthDaysAgo(1, "%m/%d/%Y"),
         endTime => "06:00 AM",
         note => "My Daily Nap."
      });

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Edit View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq(edit_header_text)

      waitForPageToFinishLoading()

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(sleep_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,3)).to eq("12 hrs   0 mins")
    end

  end

end