require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-39: Respiration Rate: Enter Delete Edit Validate]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")

    @baseNav = "Respiration"
    @expectedHeaders = {"add" => "Add Respiration Entry", "edit" => "Edit Respiration Entry", "summary" => "Respiration", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Respiration (breaths/min)", "Date Entered"]
    @phoneTableHeaders = ["Respiration (breaths/min)", "Date Entered"]

    @addDataSet = [{"Respiration" => "16"},
      {"Respiration" => "32"},
      {"Respiration" => "60"}]

    @editDataSet = [{"Respiration" => "24"},
      {"Respiration" => "34"},
      {"Respiration" => "54"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["Respiration", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Respiration (breaths/min)"]
      }
    }

    @fields = {
      "Respiration" => {
        "label" => "Respiration (breaths/min):",
        "type" => "keyboard",
        "required" => true,
        "min" => "4",
        "max" => "60",
        "minDelta" => 1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  # it "AC #JRNL-388|TC #JRNL-574: Respiration will be a topic under Vitals from the left Navigation Menu" do
  # end
#  fieldRestrictionTests(@fields)
end

it ".header 'Add <personal tracker name> Entry'
        .User will be able to ADD entries", :broken => true do
    respiration_NewEntry
    #addTest(@fields, @addDataSet)
    #unsavedWarningModalTests()
end

it ".header 'Edit <personal tracker name> Entry'
        .User will be able to EDIT entries", :broken => true do
    @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
end


context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
          AC#JRNL-389|TC#JRNL-574|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required fields validation; User will be able to ADD/EDIT/DELETE entries; Display 'Respiration' with '(breaths/min)' Boundary Test for Respiration; Verify the max allowed characters for Note" do

    it ".Error message presentation and Required fields validation
        .Display 'Respiration' with '(breaths/min)' Boundary Test for Respiration
        .Verify the max allowed characters for Note", :broken => true do
    @driver.find_element(:xpath, "//button[@alt-text='Navigation Menu']").click
    waitForPageToFinishLoading
    @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
    waitForPageToFinishLoading
    @driver.find_element(:xpath, "//button[@class='btn btn-default respiration']").click
    waitForPageToFinishLoading
    @driver.find_element(:xpath, "//button[@aria-label='Add']").click
    waitForPageToFinishLoading
    fieldLabelTests(@fields)
    #fieldRestrictionTests(@fields)
    #respirationFieldRestrictions_date
  end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do

    it ".header '<personal tracker name>'", :broken => true do
      navigationTests()
    end

    it ".default filter state", :broken => true do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to be true

      filterLabelsAndPlaceholdersTest()
    end

    it ".filtering data", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Respiration")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC #JRNL-390|TC #JRNL-574 Entries will be sorted in reverse chronological order
          AC #JRNL-2399: Display User Entered Data" do

    it ".table headers", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Display User Entered Data
        .Entries will be sorted in reverse chronological order" , :broken => true do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
           AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
           AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830:  Text description guidance text update" do
    it ".User can select date range for pain graph view
        .User will be able to see table view
        .User can select graph and see graph view", :broken => true do
      graphTest()
    end
  end

  context "AC #JRNL-389|TC #JRNL-574: User should be able to DELETE entries" do
    it ".User should be able to DELETE entries", :broken => true do
      deleteTest()
    end
  end

end