require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2506: Move Pain to the grouped Personal Tracker View]
          [Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-42: Pain Level: Enter Delete Edit Validate]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-751: Update detail view default screen message]
          [Story #JRNL-480: Graph My Pain Entries]", :regression => true do

    before(:all) do
        initializeConfigurations(BASE_URL)
        removeCollection("vitalsigns", "medicalhistorydb")

        @baseNav = "Pain"
        @expectedHeaders = {"add" => "Add Pain Entry", "edit" => "Edit Pain Entry", "summary" => "Pain", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
        @normalTableHeaders = ["Pain Rating (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain)", "Date Entered"]
        @phoneTableHeaders = ["Pain Rating (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain)", "Date Entered"]

        @addDataSet = [{"pain" => 4},
                       {"pain" => 3},
                       {"pain" => 9}]

        @editDataSet = [{"pain" => 10},
                        {"pain" => 0},
                        {"pain" => 6}]

        @metaData = {
            "baseNav" => @baseNav,
            "orderedColumnsList" => ["pain", "Date Entered"],
            "normalOrderedColumnLabels" => @normalTableHeaders,
            "phoneOrderedColumnLabels" => @phoneTableHeaders,
            "expectedHeaders" => @expectedHeaders,
            "formName" => "form",
            "graph" => {
                "xAxisLabels" => nil,
                "yAxisLabels" => ["Pain (0=None - 10=Agonizing)"]
            }
        }

        @fields = {
            "pain" => {
                "label" => "Pain (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain):",
                "type" => "slider"
            },
            "date" => {
                "label" => "Date:",
                "type" => "date",
                "required" => true
            },
            "time" => {
                "label" => "Time:",
                "type" => "time",
                "required" => true
            },
            "Note" => {
                "label" => "Note:",
                "type" => "keyboard",
                "maxLength" => 250,
                "hasCounter" => true
            }
        }

        @crossBlockSharing = {
            "expectedRowStrings" => nil
        }

        initializeAllObjects

        init(@metaData)

        @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
    end

    # after (:all) do
    #     quitDriver()
    # end

    # Obsolete
    # it "AC#JRNL-788,791|TC#JRNL-812: Display default message" do
    # end

    context "#AC #JRNL-1889|TC #JRNL-1814: Add Entry for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1890|TC #JRNL-1814: Selecting a Pain entry
           #AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC #JRNL-345|TC#JRNL-371|AC#JRNL-359|TC#JRNL-468: User can Add/Edit/Delete entries;Today's system date and time should be populated in the new item
           AC #JRNL-348 |TC #JRNL-371|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Required fields testing on Date/Time; Narrative will be limited to 250 characters with a countdown display" do

        it ".Required fields testing on Date/Time
        .Narrative will be limited to 250 characters with a countdown display
        .Today's system date and time should be populated in the new item", :broken => true do
            fieldLabelTests(@fields)
            @main.clickNavMenu()
            waitForPageToFinishLoading
            @driver.find_element(:id, "PersonalTrackers").click
            waitForPageToFinishLoading
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[class='btn btn-default pain']").click
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[ng-click='getDetails()']").click
            waitForPageToFinishLoading
            fieldRestrictionTests(@fields)
        end

        it ".header reads 'Add <personal tracker name> Entry'
        .Add Entry for Move Pain to the grouped Personal Tracker
        .User can Add/Edit entries", :broken => true do
            addTest(@fields, @addDataSet)
            unsavedWarningModalTests()
        end

        it ".header reads 'Edit <personal tracker name> Entry'
        .User can edit a entries
        .Selecting a Pain entry", :broken => true do
            @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
        end

    end

    context "#AC #JRNL-1894|TC #JRNL-1814: Filter Feature for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1893|TC #JRNL-1814: Date Range for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1892|TC #JRNL-1814: Filter Button for Move Pain to the grouped Personal Tracker
           AC #JRNL-347 | TC #JRNL-371: Default display to last 30 days" do

        it ".header reads '<personal tracker name>'
        .Verify Screen Headers", :broken => true do
            navigationTests()
        end

        it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
            refreshBrowser()

            !5.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

            expect(@date_filter.isDefaultDateRange()).to be true

            filterLabelsAndPlaceholdersTest()
        end

        # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
        #   Tested in Guidance_Text_JRNL_620_spec.rb
        # end

        it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
            filterTest(@crossBlockSharing["expectedRowStrings"])
        end

    end

    context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

        it "Visible", :broken => true do
            expect(@date_filter.isResetButtonPresent()).to eq(true)
        end

        it "Label", :broken => true do
            expect(@date_filter.getResetButtonLabel()).to eq("Reset")
        end

        it "Result", :broken => true do
            @date_filter.clickResetBtn()
            !3.times { break if (getFocusedElementText().include?("Pain Rating")); sleep 1 }
            expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))

            # DEFAULT
            expect(@date_filter.isDefaultDateRange()).to eq(true)
        end

    end

    context "AC #JRNL-550|TC #JRNL-755: User can select date range for pain graph view
           AC #JRNL-553|TC #JRNL-755: User will be able to see table view
           AC #JRNL-554|TC #JRNL-755: User can select graph and see graph view" do
        it ".User can select date range for pain graph view
        .User will be able to see table view
        .User can select graph and see graph view", :broken => true do
            graphTest()
        end
    end

    context "AC #JRNL-346 | TC #JRNL-371: Multiple pain entries can be displayed in reverse chronological order
           #AC #JRNL-1891|TC #JRNL-1814: Pain entries in a table" do

        it ".Pain entries in a table", :broken => true do
            tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
        end

        it ".Multiple pain entries can be displayed in reverse chronological order", :broken => true do
            sortTest(@crossBlockSharing["expectedRowStrings"])
        end

    end

    context "AC #JRNL-345|TC#JRNL-371: User can Add/Edit/Delete entries" do
        it ".The user will be able to remove(delete) entries", :broken => true do
            deleteTest()
        end
    end

end














































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2506: Move Pain to the grouped Personal Tracker View]
          [Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-42: Pain Level: Enter Delete Edit Validate]
          [Story #JRNL-497: Convert pop-up error messages to on page] 
          [Story #JRNL-751: Update detail view default screen message]
          [Story #JRNL-480: Graph My Pain Entries]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")

    @baseNav = "Pain"
    @expectedHeaders = {"add" => "Add Pain Entry", "edit" => "Edit Pain Entry", "summary" => "Pain", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Pain Rating (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain)", "Date Entered"]
    @phoneTableHeaders = ["Pain Rating (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain)", "Date Entered"]

    @addDataSet = [{"pain" => 4},
      {"pain" => 3},
      {"pain" => 9}]

    @editDataSet = [{"pain" => 10},
      {"pain" => 0},
      {"pain" => 6}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["pain", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Pain (0=None - 10=Agonizing)"]
      }
    }

    @fields = {
      "pain" => {
        "label" => "Pain (0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain):",
        "type" => "slider"
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  # it "AC#JRNL-788,791|TC#JRNL-812: Display default message" do    
  # end

  context "#AC #JRNL-1889|TC #JRNL-1814: Add Entry for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1890|TC #JRNL-1814: Selecting a Pain entry
           #AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC #JRNL-345|TC#JRNL-371|AC#JRNL-359|TC#JRNL-468: User can Add/Edit/Delete entries;Today's system date and time should be populated in the new item
           AC #JRNL-348 |TC #JRNL-371|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Required fields testing on Date/Time; Narrative will be limited to 250 characters with a countdown display" do

    it ".Required fields testing on Date/Time
        .Narrative will be limited to 250 characters with a countdown display
        .Today's system date and time should be populated in the new item", :broken => true do
      fieldLabelTests(@fields)
      fieldRestrictionTests(@fields)
    end

    it ".header reads 'Add <personal tracker name> Entry'
        .Add Entry for Move Pain to the grouped Personal Tracker
        .User can Add/Edit entries", :broken => true do
      addTest(@fields, @addDataSet)
      unsavedWarningModalTests()
    end

    it ".header reads 'Edit <personal tracker name> Entry'
        .User can edit a entries
        .Selecting a Pain entry", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1894|TC #JRNL-1814: Filter Feature for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1893|TC #JRNL-1814: Date Range for Move Pain to the grouped Personal Tracker
           #AC #JRNL-1892|TC #JRNL-1814: Filter Button for Move Pain to the grouped Personal Tracker
           AC #JRNL-347 | TC #JRNL-371: Default display to last 30 days" do

    it ".header reads '<personal tracker name>'
        .Verify Screen Headers", :broken => true do
      navigationTests()
    end

    it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to be true

      filterLabelsAndPlaceholdersTest()
    end

    # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
    #   Tested in Guidance_Text_JRNL_620_spec.rb
    # end
    
    it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Pain Rating")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end
  
  context "AC #JRNL-550|TC #JRNL-755: User can select date range for pain graph view
           AC #JRNL-553|TC #JRNL-755: User will be able to see table view
           AC #JRNL-554|TC #JRNL-755: User can select graph and see graph view" do
    it ".User can select date range for pain graph view
        .User will be able to see table view
        .User can select graph and see graph view", :broken => true do
      graphTest()
    end
  end

  context "AC #JRNL-346 | TC #JRNL-371: Multiple pain entries can be displayed in reverse chronological order
           #AC #JRNL-1891|TC #JRNL-1814: Pain entries in a table" do

    it ".Pain entries in a table", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Multiple pain entries can be displayed in reverse chronological order", :broken => true do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC #JRNL-345|TC#JRNL-371: User can Add/Edit/Delete entries" do
    it ".The user will be able to remove(delete) entries", :broken => true do
      deleteTest()
    end
  end

end
=end