require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2507: Move Mood to the grouped Personal Tracker View]
[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
[Story #JRNL-22: My Mood: Enter Edit Delete Validate]
[Story #JRNL-751: Update detail view default screen message]
[Story #JRNL-1424: Update Mood Tracker]
[Story #JRNL-1340: Change Mood Scale]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("mood", "medicalhistorydb")

    @baseNav = "Mood"
    @expectedHeaders = {"add" => "Add Mood Entry", "edit" => "Edit Mood Entry", "summary" => "Mood", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    # JRNL-1424 changes table header to 'Mood Rating (1=Very Good, 10=Very Bad)'
    # JRNL-1340 further changes label to Mood '(1=Very Bad, 10=Very Good)'
    @normalTableHeaders = ["Mood Rating (1=Very Bad, 10=Very Good)", "Date Entered"]
    @phoneTableHeaders  = ["Mood Rating (1=Very Bad, 10=Very Good)", "Date Entered"]

    @addDataSet = [{"mood" => 4},
      {"mood" => 3},
      {"mood" => 9}]

    @editDataSet = [{"mood" => 10},
      {"mood" => 1},
      {"mood" => 6}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["mood", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form"
    }

    @fields = {
      # JRNL-1424 changes label to 'Mood Rating (1=Very Good, 10=Very Bad)'
      # JRNL-1340 further changes label to Mood '(1=Very Bad, 10=Very Good)'
      "mood" => {
        "label" => "Mood (1=Very Bad, 10=Very Good):",
        "type" => "slider",
        "min" => "1",
        "max" => "10"
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      # JRNL-1424 adds 'Time' field
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end

  # Obsolete 
  # it "AC#JRNL-339|TC#JRNL-370|AC#JRNL-788TC#JRNL-812: Mood will appear as an option on the app menu; Default message is displayed" do
  # end

  context "AC #JRNL-1883|TC #JRNL-1816: Add Mood Entry
  AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
  AC #JRNL-237| TC #JRNL-370:  Narrative will be limited to 250 characters with a countdown display
  AC #JRNL-719,720,723|TC #JRNL-744: Error message presentation; Required field validation; Validation information in error messages
  AC #JRNL-511| TC #JRNL-540: Allow date time change for date entry
  AC #JRNL-340|TC #JRNL-370|AC#JRNL-359|TC#JRNL-468|TC#JRNL-812: Today's system date and time should be populated in the new item
  AC #JRNL-1398|TC #JRNL-1391: Add Time Field
  AC #JRNL-1395|TC #JRNL-1391: Revise Mood Scale
  AC #JRNL-1317|TC #JRNL-1391: Update Filter and List View, Detail View and Graph" do

    it ".header '<personal tracker name>'
        .Verify Screen Headers", :broken => true do
      navigationTests()
    end

    it ".Error message presentation
        .Required field validation
        .Validation information in error messages
        .Narrative will be limited to 250 characters with a countdown display
        .Today's system date and time should be populated in the new item", :broken => true do
      fieldLabelTests(@fields)
      fieldRestrictionTests(@fields)
    end

    it ".header reads 'Add <personal tracker name> Entry'
        .Add Mood Entry
        .Display user entered data
        .Allow date time change for date entry", :broken => true do
      addTest(@fields, @addDataSet)
      unsavedWarningModalTests()
    end

    it ".header reads 'Edit <personal tracker name> Entry'
        .User can edit a entries", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1887|TC #JRNL-1816: Filter Feature for Move Mood to the grouped Personal Tracker
           #AC #JRNL-1886|TC #JRNL-1816: Date Range for Move Mood to the grouped Personal Tracker
           #AC #JRNL-1885|TC #JRNL-1816: Filter Button for Move Mood to the grouped Personal Tracker
           AC #JRNL-342 | TC #JRNL-370: Default display to last 30 days" do

    it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to eq(true)

      filterLabelsAndPlaceholdersTest()
    end

    # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
    #   Tested in Guidance_Text_JRNL_620_spec.rb
    # end

    it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Mood Rating")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC #JRNL-341| TC #JRNL-370: Multiple entries in reverse chronological order
  AC #JRNL-1184|TC #JRNL-1816: Mood entries in a table
  AC #JRNL-1397|TC #JRNL-1391: Update Mood Tracker Filter and List View
  AC #JRNL-1317|TC #JRNL-1391: Update Filter and List View, Detail View and Graph" do

    it ".Mood entries in a table", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Multiple entries in reverse chronological order", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC#JRNL-340|TC#JRNL-370: User can Add/Edit/Delete entries" do
    it ".The user will be able to remove(delete) entries", :broken => true do
      deleteTest()
    end
  end

end