require_relative '../../../globalized'
include Globalized

describe "*PersonalTrackers_Move_Daily_Events_To_Personal_Tracker_JRNL_2505_spec.rb
          [Story #JRNL-1370: Transition Daily Events Front End to Use Mongo HTS]
          [Story #JRNL-2505: Move Daily Events to the grouped Personal Tracker View]
          [Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-41: Daily Events: Enter Delete Edit]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-469: Allow date/time to be changed for data entry]
          [Story #JRNL-751: Update detail view default screen message]
          [Story #JRNL-746: Generate PDF for Daily Event Entry]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("notes", "medicalhistorydb")


    @baseNav = "DailyEvents"
    @expectedHeaders = {"add" => "Add Daily Events Entry", "edit" => "Edit Daily Events Entry", "summary" => "Daily Events", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Title", "Date Entered"]
    @phoneTableHeaders = ["Title", "Date Entered"]

    @addDataSet = [{"eventTitle" => "Server Side Development"},
      {"eventTitle" => "Client Side Development"},
      {"eventTitle" => "Automated Testing"}]

    @editDataSet = [{"eventTitle" => "Nothing"},
      {"eventTitle" => "Everything"},
      {"eventTitle" => "Something"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["eventTitle", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "pdf" => "edit"
    }

    @fields = {
      "eventTitle" => {
        "label" => "Title:",
        "type" => "keyboard",
        "required" => true,
        "maxLength" => 50,
        "hasCounter" => false
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }


    initializeAllObjects

    init(@metaData)
    @common.fastLoginEndsOnLandingPage("zztest.patient01", "zztest", "patient01", "D123401")

  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  # it "AC #JRNL-256 | TC #JRNL-222: Include titles for main screen ('Events') and detailed screen ('Event Detail')" do
  # end

  context "AC #JRNL-1895|TC #JRNL-1810: Add entry for Move Daily Events to the grouped Personal Tracker View
           AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC #JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Required fields validation; Error message Presentation; Validation information shown in Error Messages
           AC #JRNL-174 |TC #JRNL-222: The user will be able to remove(delete) events : AC #JRNL-359 | TC #JRNL-468: Today's system date and time should be populated in the new item
           AC #JRNL-171|TC#JRNL-222|AC#JRNL-511|TC#JRNL-540|AC#JRNL-791,788|TC#812: User will be able to enter an event up to 50 characters; Allow date time change for date entry
           AC #JRNL-173 | TC #JRNL-222: The user will be able to Edit existing events, For each event entered, the system date and time stamp will be included, AC#JRNL517 | TC#JRNL537:Add Narrative field to Daily Events
           AC #JRNL-1341| TC #JRNL-1810: Verify JRNL-2505" do

    it ".Required fields validation
        .Error message Presentation
        .Validation information shown in Error Messages
        .Today's system date and time should be populated in the new item
        .User will be able to enter an event up to 50 characters
        .Add Narrative field to Daily Events
        .Today's system date and time should be populated in the new item" do
      fieldLabelTests(@fields)
      fieldRestrictionTests(@fields)
    end

    it ".header reads 'Add <personal tracker name> Entry'
        .Add entry for Move Daily Events to the grouped Personal Tracker View
        .Allow date time change for date entry
        .For each event entered, the system date and time stamp will be included" do
      addTest(@fields, @addDataSet)
      unsavedWarningModalTests()
    end

    it ".header reads 'Edit <personal tracker name> Entry'
        .The user will be able to Edit existing events" do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1899|TC #JRNL-1810: Filter Feature for Move Daily Events to the grouped Personal Tracker View
           #AC #JRNL-1898|TC #JRNL-1810: Date Range for Move Daily Events to the grouped Personal Tracker View
           #AC #JRNL-1897|TC #JRNL-1810: Filter Button for Move Daily Events to the grouped Personal Tracker View
           AC #JRNL-235 | TC #JRNL-222: Date Range for display of data
           AC #JRNL-175 | TC #JRNL-222: Events will be displayed" do

    it ".header reads '<personal tracker name>'
      .Verify Screen Headers" do
      navigationTests()
    end

    it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null
        .Date Range for display of data" do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to eq(true)

      filterLabelsAndPlaceholdersTest()
    end

    # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
    #   Tested in Guidance_Text_JRNL_620_spec.rb
    # end

    it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.
        .Events will be displayed" do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible" do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Title")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC #JRNL-862|TC #JRNL-989: PDF View button" do
    it ".PDF View button" do
      pdfTest()
    end
  end

  context "#AC #JRNL-1896|TC #JRNL-1810: Daily Event Entries for Move Daily Events to the grouped Personal Tracker View" do

    it ".Daily Event entries are displayed in a table format" do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".sorted in reverse chronological order using date and time values"  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC #JRNL-174 |TC #JRNL-222: The user will be able to remove(delete) events" do
    it ".The user will be able to remove(delete) events" do
      deleteTest()
    end
  end

  ##############################################################################
  ## 24 FEB 2015 - jnakama
  ## Remove below code when story JRNL-1370 is completed, because per AC in story JRNL-1370:
  ##
  ##    "Note: When this [story JRNL-1370] is completed, JRNL-63 will be obsolete."
  ##
  ##############################################################################
  ##  context "AC#JRNL-859,861|AC#542,543,544|TC#JRNL-976|TC#JRNL-586: Daily Events Attachment Fields|Attachment Upload|Error Messages
  ##           AC#JRNL-860|TC#JRNL-976|TC#JRNL-586: Display Device Browse Function" do
  ##
  ##    it ".Daily Events Attachment Fields" do
  ##
  ##      @nav_menu.navigate(@baseNav)
  ##      @personal_trackers.clickAddEntryButton()
  ##      waitForPageToFinishLoading()
  ##      #Verifying Label, Instructional Text and presence of Add Button
  ##      expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
  ##      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to be true
  ##
  ##      @entry_form.clickCancelButton()
  ##      waitForPageToFinishLoading()
  ##    end
  ##
  ##    it ".Attachment Upload" do
  ##      #Detail View Add Mode
  ##      addEntry(@addDataSet[0])
  ##
  ##      @personal_trackers.clickNthRow(1)
  ##      waitForPageToFinishLoading()
  ##
  ##      #Verifying Label, Instructional Text and presence of Add Button
  ##      expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
  ##      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to be true
  ##
  ##      #Adding an attachments and making sure user is returned to Detail View, Attached filename is visible and Delete buttons are visible next to the respective file names
  ##      imageList = ["spidey.jpg", "imgo.jpeg", "testSat.jpg", "johnS.jpg"]
  ##      imageListLength = imageList.length
  ##
  ##      for i in 0...imageListLength
  ##        # puts imageList[i]
  ##        addAttachment("addFile", imageList[i])
  ##        waitForPageToFinishLoading()
  ##        expect(isElementVisible(:css, @attachment.nthViewAttachmentButton(i))).to be true
  ##        expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to be true
  ##      end
  ##
  ##      #Making sure that the Add button has disappeared
  ##      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to be false
  ##
  ##      #Deleting Images in different order
  ##      deleteOrder = [3,1,2,1] #AKA 3,1,4,2
  ##      deleteOrderLength = deleteOrder.length
  ##      for i in 0...deleteOrderLength
  ##        deleteAttachment(deleteOrder[i])
  ##        waitForPageToFinishLoading()
  ##      end
  ##    end
  ##
  ##    it ".Error Messages" do
  ##      #Making sure file size > 10 MB is not allowed and verifying the Error Message
  ##      addAttachment(@attachment.addFileInputName, "bumblebee-poster-11mb.jpg")
  ##      waitForPageToFinishLoading()
  ##      checkingInlineError("Your file could not be added. Attachments must be image files (jpeg, jpg, png) that are no bigger than 10 MB. Only one file may be added at time. Please check the file and try again.")
  ##
  ##    end
  ##
  ##    it ".Display device browse function and saved entry required message" do
  ##
  ##      @nav_menu.navigate(@baseNav)
  ##      @personal_trackers.clickAddEntryButton()
  ##      waitForPageToFinishLoading()
  ##      #Clicking Add Attachment without saving
  ##      openAttachmentConfirmationModal()
  ##
  ##      #Verifying Cancel Button takes the user back to Detail View
  ##      @modal.clickReturnButton() #return == cancel
  ##
  ##      !45.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 0.5 }
  ##
  ##      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  ##      #Clicking Add Attachment and then clicking the Save button to verify the error message
  ##
  ##      openAttachmentConfirmationModal()
  ##
  ##      @modal.clickContinueButton() #continue == save
  ##
  ##      checkingInlineError("Title field is required.")
  ##
  ##      #Filling the Required field and clicking the Add Button
  ##      editField("eventTitle", "I want to add a few pictures.")
  ##
  ##      openAttachmentConfirmationModal() #continue == save
  ##
  ##      @modal.clickContinueButton()
  ##
  ##    end
  ##  end
  ##
  ##  def openAttachmentConfirmationModal()
  ##    click(:css, @attachment.addAttachmentButton)
  ##
  ##    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 0.5 }
  ##    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
  ##    expect(@modal.getConfirmationMessage()).to eq("In order to add an attachment, this Daily Event record must first be saved.")
  ##
  ##  end
  ##############################################################################
end