require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1419: Personal Trackers - Mood - Graph]
[Story #JRNL-1340: Change Mood Scale]", :broken => true, :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("mood", "medicalhistorydb", "mood")

    HEADER = "Mood"

    initializeAllObjects

    @graphInfo = {
        "xAxisTitles" => ["Date/Time"],
        "yAxisTitles" => ["Mood (1=Very Bad, 10=Very Good)"]
    }

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @nav_menu.click(:css, Nav_menu::NAV["Mood"]["navButton"])
    !45.times{ break if (getPrimaryHeader() == HEADER); sleep 1 }
    expect(getPrimaryHeader()).to eq(HEADER)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1393|TC JRNL-1388: Graph Button and Features; AC JRNL-1317|TC JRNL-1388" do

    it "Button Visibility" do
      expect(is_element_present(:css, graphButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, graphButton())).to eq("Graph")
    end

    it "Button Alt Text" do
      expect(getElement(:css, graphButton()).attribute("title")).to eq("Graph")
    end

    it "Toggle" do
      from = "01/01/2012"
      to = "12/12/2014"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getFocusedElementText().include?("Mood Rating")); sleep 1 }
      expect(getFocusedElementText().include?("Mood Rating")).to eq(true)

      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(false)

      click(:css, graphButton())
      !30.times{ break if(isElementPresentAndVisible(:css, graphContainer()) == true); sleep 1 }
      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(true)
    end

    it "Button Visibility" do
      expect(is_element_present(:css, tableButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, tableButton())).to eq("Table")
    end

    it "Button Alt Text" do
      expect(getElement(:css, tableButton()).attribute("title")).to eq("Table")
    end

    it "Informational Text" do
      expect(getTextForElement(:css, viewTableMessage())).to eq("A text description of the information on this page is available in the table view.")
    end

    it "Graph Title" do
      expect(getGraphTitle()).to eq("Mood Ratings from 01/01/2012 to 12/12/2014")
    end

    it "X-Axis Title" do
      xAxisTitles = getXAxisLabels()

      numXAxisTitles = @graphInfo["xAxisTitles"].length

      for i in 0...numXAxisTitles
        expect(xAxisTitles[i]).to eq(@graphInfo["xAxisTitles"][i])
      end
    end

    it "Y-Axis Title" do
      yAxisTitles = getYAxisLabels()

      numYAxisTitles = @graphInfo["yAxisTitles"].length

      for i in 0...numYAxisTitles
        expect(yAxisTitles[i]).to eq(@graphInfo["yAxisTitles"][i])
      end
    end

    it "Y-Axis Ticks" do
      yTicks = getYAxisTicks()

      for i in 0...yTicks.length
        expect(yTicks[i].to_i).to eq(i+1)
      end
    end

    it "X-Axis Ticks" do
      xTicks = getXAxisTicks()

      expect(xTicks[0]).to eq("Jan 2012")
      expect(xTicks[xTicks.length - 1]).to eq("Sep 2014")
    end

    it "Legend Visibility" do
      expect(isLegendDisplayed?()).to eq(true)
    end

    it "Legend Content" do
      expect(getLegendContent()).to eq("Mood")
    end

    it "Plot Point Count" do
      expect(getElements(:css, "g.highcharts-markers > path").length()).to eq(4)
    end

  end

  describe "AC JRNL-1392|TC JRNL-1388: Graph Data Display" do

    it "Change Filter Dates" do
      from = "12/01/2012"
      to = "12/31/2013"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getGraphTitle()) == "Mood Ratings from #{from} to #{to}" }
      expect(getGraphTitle()).to eq("Mood Ratings from #{from} to #{to}")

      expect(getElements(:css, "g.highcharts-markers > path").length()).to eq(2)
    end

    it "Row Count" do
      click(:css, tableButton())
      !30.times{ break if(isElementPresentAndVisible(:css, graphContainer()) == false); sleep 1 }
      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(false)

      expect(getCount()).to eq(2)
    end

    it "Filter Persists" do
      expect(@date_filter.getStartDate()).to eq("12/01/2012")
      expect(@date_filter.getEndDate()).to eq("12/31/2013")
    end

  end

end
