require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-57: Height: Enter Delete Edit]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")

    @baseNav = "Height"
    @expectedHeaders = {"add" => "Add Height Entry", "edit" => "Edit Height Entry", "summary" => "Height", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Height (in)", "Date Entered"]
    @phoneTableHeaders = ["Height (in)", "Date Entered"]

    @addDataSet = [{"Height" => "80"},
      {"Height" => "71"},
      {"Height" => "0"}]

    @editDataSet = [{"Height" => "96"},
      {"Height" => "40"},
      {"Height" => "30"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["Height", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Height (in)"]
      }
    }

    @fields = {
      "Height" => {
        "label" => "Height (in):",
        "type" => "keyboard",
        "required" => true,
        "min" => "0",
        "max" => "96",
        "minDelta" => 1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end
  
  # Obsolete 
  # it "AC #JRNL-394|TC #JRNL-601: Height will be a topic under Vitals from the left Navigation Menu" do
  # end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
          AC#JRNL-395|TC#JRNL-601|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586: Error message presentation and Required fields validation; User will be able to ADD/EDIT/DELETE entries; Display 'Height' with '(in)' Boundary Test for Height; Verify the max allowed characters for Note" do

    it ".Display 'Height' with '(in)'", :broken => true do
      fieldLabelTests(@fields)
    end

    it ".Error message presentation and Required fields validation
        .Boundary Test for Height
        .Verify the max allowed characters for Note", :broken => true do
      fieldRestrictionTests(@fields)
    end

    it ".header 'Add <personal tracker name> Entry'
        .User will be able to ADD entries", :broken => true do
      addTest(@fields, @addDataSet)

      unsavedWarningModalTests()
    end

    it ".header 'Edit <personal tracker name> Entry'
        .User will be able to EDIT entries", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do

    it ".header '<personal tracker name>'", :broken => true do
      navigationTests()
    end

    it "", :broken => true do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to be true

      filterLabelsAndPlaceholdersTest()
    end

    it "", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Height")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC #JRNL-396|TC #JRNL-601 Entries will be sorted in reverse chronological order
           AC #JRNL-396|TC #JRNL-601: Display User Entered Data" do

    it ".table headers", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".Entries will be sorted in reverse chronological order
        .Display User Entered Data", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
           AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
           AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830:  Text description guidance text update" do
    it ".User can select date range for pain graph view
        .User will be able to see table view
        .User can select graph and see graph view", :broken => true do
      graphTest()
    end
  end

  context "AC #JRNL-395|TC #JRNL-601: User should be able to DELETE entries" do
    it ".User should be able to DELETE entries", :broken => true do
      deleteTest()
    end
  end
end