require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1564: Glucose Tracker - Filter and List View]
[Story #JRNL-1425: Modify Fields]
[Story #JRNL-1399: Tracker Date Column Update]", :regression => true do

  before(:all) do
    ## JRNL-1425 changes "Test Condition" to "Tested" and options to: "Fasting (8 hours)", "After Meal" and "Unknown"
    @FILTER_EXPANDED = [
        "* required field",
        "Date Range:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Tested:",
        "Select",
        "Fasting (8 hours)",
        "After Meal",
        "Unknown",
        "Filter Reset"
    ]

    @FILTER_COLLAPSED = []

    initializeConfigurations(BASE_URL)
    resetCollection("chemlabs", "medicalhistorydb", "glucose")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1490|TC JRNL-1451: Sub Feature Selection" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("Glucose")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Glucose"]["navButton"])).to eq("Glucose (Self Tested)")
    end

    it "Location" do
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do | menuItem, i |
        if(i > 0)
          expect(menuItem.text() <=> menu[i-1].text()).to eq(1)
        end
      end
    end
  end

  describe "AC JRNL-1489|TC JRNL-1451: Filter and Table" do

    it "Screen Header" do
      @nav_menu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == Glucose::HEADER); sleep 1 }
      expect(getPrimaryHeader()).to eq(Glucose::HEADER)
    end

    it "Focus" do
      expect(getFocusedElementText()).to eq(Glucose::HEADER)
    end

    it "Content (Filter Expanded)", :broken => true do
      filterScreen = @glucose_filter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Default", :broken => true do
      expect(@glucose_filter.isFilterAccordionExpanded()).to be(true)
      expect(@glucose_filter.getFilterAccordionTitle()).to eq("Collapse filter options")

      @glucose_filter.clickFilterAccordion()
      sleep 1
      expect(@glucose_filter.isFilterAccordionExpanded()).to be(false)
      expect(@glucose_filter.getFilterAccordionTitle()).to eq("Expand filter options")

      @glucose_filter.clickFilterAccordion()
      sleep 1
      expect(getLongFieldLabel("startDate")).to eq("* Start Date:")
      expect(getLongFieldLabel("endDate")).to eq("* End Date:")
      ## JRNL-1425 changes field label from "Test Condition" to "Tested"
      expect(getLongFieldLabel("tested")).to eq("Tested:")

      expect(getPlaceHolderByCSS(:css, Glucose_Filter::FROM_DATE)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Glucose_Filter::TO_DATE)).to eq("MM/DD/YYYY")
      ## JRNL-1425 changes select box options from: "Fasting", "Before Meal" and "After Meal", to: "Fasting (8 hours)", "After Meal" and "Unknown"
      expect(getTextForElement(:css, Glucose_Filter::TESTED)).to eq("Select\nFasting (8 hours)\nAfter Meal\nUnknown")
      expect(@glucose_filter.getSelectBoxText(Glucose_Filter::TESTED)).to eq("Select")
    end

    it "Content (Filter Collapsed)", :broken => true do
      @glucose_filter.clickFilterAccordion()

      filterScreen = @glucose_filter.getScreenContent().split("\n")
      @FILTER_COLLAPSED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Button", :broken => true do
      @glucose_filter.clickFilterAccordion()
      sleep 1
      expect(@glucose_filter.getFilterButtonLabel()).to eq("Filter")
    end

    describe "Filter Options" do

      it "End Date" do
        daysFromToday = @date_picker.getDateNthDaysFromNow(-30, "%m/%d/%Y")

        expect(@glucose_filter.getTextFromInput(:css, Glucose_Filter::FROM_DATE)).to eq(daysFromToday)
        expect(@glucose_filter.isFieldRequired(:css, Glucose_Filter::FROM_DATE)).to eq(true)
      end

      it "Start Date", :broken => true do
        now = Time.new()

        expect(@glucose_filter.getTextFromInput(:css, Glucose_Filter::TO_DATE)).to eq(now.strftime("%m/%d/%Y"))
        expect(@glucose_filter.isFieldRequired(:css, Glucose_Filter::TO_DATE)).to eq(true)
      end

      it "Tested (single select, pick list, values: Fasting (8 hours), After Meal, Unknown)" do
      ## JRNL-1425 changes values
      # it "Test Condition (single select, pick list, values: Fasting, Before Meal, After Meal)" do
        expect(areAllTheseValuesAvailableInDropDown(Glucose_Filter::TESTED, "Select;Fasting (8 hours);After Meal;Unknown")).to eq(true)
        expect(@glucose_filter.isFieldRequired(:css, Glucose_Filter::TESTED)).to eq(false)
      end


      it "Date Validation", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @glucose_filter.setInput(Glucose_Filter::FROM_DATE, "")
        @glucose_filter.setInput(Glucose_Filter::TO_DATE, "")

        @glucose_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before To Date.")).to eq(false)

        @glucose_filter.setInput(Glucose_Filter::FROM_DATE, "12")
        @glucose_filter.setInput(Glucose_Filter::TO_DATE, "12")

        @glucose_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)

        # @date_picker.clickStartDateCalendarBtn()
        @glucose_filter.click(:css, Glucose_Filter::FROM_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2013)

        # @date_picker.clickEndDateCalendarBtn()
        @glucose_filter.click(:css, Glucose_Filter::TO_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2012)

        @glucose_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @glucose_filter.setInput(Glucose_Filter::FROM_DATE, futureDate)
          @glucose_filter.setInput(Glucose_Filter::TO_DATE, futureDate)

          @glucose_filter.clickFilterBtn()
          !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end
      end

    end

  end

  describe "AC JRNL-1488|TC JRNL-1451: Filter Action and Results Display
  [AC #JRNL-1342|TC JRNL-1417: Change Date Column Label to Date Entered]" do

    describe "When Records Are Found" do

      it "Sorted in reverse chronological order by date and time entered", :broken => true do
        @glucose_filter.setDateRangeAndFilter("11/11/2009", "12/02/2014")

        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(4)

        verifyList(getList(), getFilteredList("2009-11-11", "2014-11-11", ""))
      end

      it "Table Headers", :broken => true do
        #expect(getTableHeaders()).to eq(["Date/Time", "Glucose Level", "Tested"])
        expect(getTableHeaders()).to eq(["Glucose Level", "Tested","Date Entered"])
      end

      it "Search By selecting test condition", :broken => true do
        @glucose_filter.setSelectBoxValue(Glucose_Filter::TESTED, "Fasting (8 hours)")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "Fasting (8 hours)"))
      end

      it "Date Within Filter Range", :broken => true do
        @glucose_filter.setSelectBoxValue(Glucose_Filter::TESTED, "Select")
        @glucose_filter.setFromDate("01/01/2011")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(4)

        verifyList(getList(), getFilteredList("2011-01-01", "2014-11-11", ""))
      end

      it "Date Equal To Start Date Filter", :broken => true do
        @glucose_filter.setFromDate("12/30/2013")
        @glucose_filter.setEndDate("01/30/2014")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2013-12-30", "2014-01-30", ""))
      end

      it "Date Equal To End Date Filter", :broken => true do
        @glucose_filter.setFromDate("12/01/2013")
        @glucose_filter.setEndDate("12/30/2013")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2013-12-01", "2013-12-30", ""))
      end

      it "Multiple rows with Test Condition set", :broken => true do
        @glucose_filter.setFromDate("01/01/2012")
        @glucose_filter.setEndDate("12/12/2012")
        @glucose_filter.setSelectBoxValue(Glucose_Filter::TESTED, "After Meal")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("Glucose Level")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(2)

        verifyList(getList(), getFilteredList("2012-01-01", "2012-12-12", "After Meal"))
      end

    end

    describe "When No Records Found" do

      it "Message" do
        @glucose_filter.setFromDate("10/30/1980")
        @glucose_filter.setEndDate("01/01/1982")

        @glucose_filter.clickFilterBtn()
        !10.times{ break if (@glucose_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@glucose_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyList(getList(), getFilteredList("1980-10-30", "1982-01-01", ""))
      end

    end

  end

  describe "AC JRNL-1507|TC JRNL-1451: Reset Button" do

    it "Visible" do
      expect(@glucose_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(@glucose_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      nowDate = Time.new()
      daysFromToday = @date_picker.getDateNthDaysFromNow(-30, "%m/%d/%Y")

      @glucose_filter.clickResetBtn()
      !30.times { break if (@glucose_filter.getFocusedElementText().include?("No results")); sleep 1 }
      expect(@glucose_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      # DEFAULTS
      expect(@glucose_filter.getTextFromInput(:css, Glucose_Filter::FROM_DATE)).to eq(daysFromToday)
      expect(@glucose_filter.getTextFromInput(:css, Glucose_Filter::TO_DATE)).to eq(nowDate.strftime("%m/%d/%Y"))
      expect(@glucose_filter.getTextFromInput(:css, Glucose_Filter::TESTED)).to eq("")
    end
  end

  #######################
  ### Local Functions ###
  #######################

  def getAllRecordsInDBSorted
    def sortByKeys(x,y)
      return y["recorded"].strftime('%Y%m%d') <=> x["recorded"].strftime('%Y%m%d')
    end

    return retreiveAllDocumentsInCollection("chemlabs", "medicalhistorydb").sort { |x, y| sortByKeys(x,y) }
  end

  def getFilteredList(startDate, endDate, testCondition)
    dateMatch = []
    stringMatch = []
    getAllRecordsInDBSorted.each_with_index do |event, i|
      if event["recorded"].strftime('%Y%m%d') >= Date.parse(startDate).strftime('%Y%m%d') && event["recorded"].strftime('%Y%m%d') <= Date.parse(endDate).strftime('%Y%m%d')
        dateMatch << event
      end

      if testCondition != "" && event["method"].upcase().include?(testCondition.upcase())
        stringMatch << event
      end
    end

    return (dateMatch & stringMatch)
  end

  def verifyList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip.to_i).to eq(dbrow["valueQuantity"]["value"].to_i)
      expect(screenRow[5].strip).to eq(formatFullDateTime(dbrow["recorded"]))
    end
  end

end
