require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1551: Glucose Tracker - Graph][Story #JRNL-1425: Modify Fields]", :broken => true, :regression => true  do

  include DriverUtility
  include MongoUtility
  include Table
  include CommonTests

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("chemlabs", "medicalhistorydb", "glucose")

    initializeAllObjects

    @graphInfo = {
        "xAxisLabels" => ["Date/Time"],
        "yAxisLabels" => ["Glucose Level (mg/dl)"]
    }

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1476|TC JRNL-1438: Graph button for glucose tracker" do

    it "Screen Header" do
      @nav_menu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == Glucose::HEADER); sleep 1 }
      expect(getPrimaryHeader()).to eq(Glucose::HEADER)
    end

    it "Is graph button visible" do
      expect(@GlucoseFilter.isGraphButtonPresent()).to eq(true)
    end

    it "Verify Button Text" do
      expect(getTextForElement(:css, @GlucoseFilter.graphButton())).to eq("Graph")
    end

    it "Verify button alt text" do
      expect(@GlucoseFilter.getGraphButtonTitle()).to eq("Graph")
    end

    it "Verify text below filter" do
      click(:css, @GlucoseFilter.graphButton)
      @GlucoseFilter.setDateRangeAndFilter("11/11/2009", "12/02/2014")
      !10.times{ break if (@GlucoseFilter.getFocusedElementText().include?("A text description of the information on this page is available in the table view.")); sleep 1 }
      expect(@GlucoseFilter.getFocusedElementText()).to eq("A text description of the information on this page is available in the table view.")
    end

    it "Verify x-axis label" do
      xAxisLabels = @GlucoseFilter.getXAxisLabels()

      numXAxisLabels = @graphInfo["xAxisLabels"].length

      for i in 0...numXAxisLabels
        expect(xAxisLabels[i]).to eq(@graphInfo["xAxisLabels"][i])
      end

    end

    it "Verify y-axis label" do
      yAxisLabels = @GlucoseFilter.getYAxisLabels()

      numYAxisLabels = @graphInfo["yAxisLabels"].length

      for i in 0...numYAxisLabels
        expect(yAxisLabels[i]).to eq(@graphInfo["yAxisLabels"][i])
      end
    end

    it "Verify legend" do
      expect(@GlucoseFilter.isLegendDisplayed?()).to eq(true)
      legendContent = @GlucoseFilter.getLegendContent()
      ## JRNL-1425 changes legend values to: "Fasting (8 hours)", "After Meal" and "Unknown"
      expect(legendContent.include? "Fasting (8 hours)").to eq(true)
      expect(legendContent.include? "After Meal").to eq(true)
      expect(legendContent.include? "Unknown").to eq(true)
    end

  end

  describe "AC JRNL-1475|TC JRNL-1438: Graph button for glucose tracker" do

    it "change date filers and verify x/y axis" do
      xAxisValues = @GlucoseFilter.getXAxisValues()
      yAxisValues = @GlucoseFilter.getYAxisValues()

      @GlucoseFilter.setDateRangeAndFilter("11/11/1900", "12/02/2014")
      @GlucoseFilter.clickFilterBtn()
      sleep 3.0

      xAxisValuesNew = @GlucoseFilter.getXAxisValues()
      yAxisValuesNew = @GlucoseFilter.getYAxisValues()

      for i in 0...xAxisValuesNew.length
        expect(xAxisValuesNew[i]).to_not eq(xAxisValues[i])
      end

      for i in 0...yAxisValuesNew.length
        expect(yAxisValuesNew[i]).to eq(yAxisValues[i])
      end
    end

    it "Verify row count" do
      click(:css, @GlucoseFilter.tableButton)

      expect(getCount()).to eq(4)
    end

    it "Verify filter is the same" do
      expect(@GlucoseFilter.getStartDate()).to eq("11/11/1900")
      expect(@GlucoseFilter.getEndDate()).to eq("12/02/2014")
    end

  end

end
