 require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1563: Glucose - Edit/Delete/Nav][Story #JRNL-1425: Modify Fields]", :broken => true, :regression => true do

  before(:all) do
    ## JRNL-1425 changes "Test Condition" to "Tested" and options to: "Fasting (8 hours)", "After Meal" and "Unknown"
    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Glucose Level (mg/dl):",
        "Between 0 and 400",
        "* Tested:",
        "Select",
        "Fasting (8 hours)",
        "After Meal",
        "Unknown",
        "Note:",
        "250 character maximum",
        "230 characters left"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("chemlabs", "medicalhistorydb", "glucose")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
    !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
    expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

    @numberOfRecords = 4
    
    @glucoseFilter.setInput(Glucose_Filter::FROM_DATE, "01/01/1900")
    @glucoseFilter.clickFilterBtn()
    !10.times{ break if (@glucoseFilter.getFocusedElementText().include?(%(Date/Time))); sleep 1 }
    expect(@glucoseFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
    
    expect(getCount()).to eq(@numberOfRecords)

    @countBeforeDelete = retreiveAllDocumentsInCollection("chemlabs", "medicalhistorydb").length()
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1484|TC JRNL-1443: When Selecting An Entry" do

    it "Header" do
      clickNthRow(1)
      !45.times{ break if( @glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1}
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)
    end

    it "Previously-Saved Values" do
      expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("01/01/2014")
      expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("08:10 AM")
      expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("10")
      expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("Fasting (8 hours)")
      expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("Tested While Fasting")
      expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("230 characters left")
    end

    describe "Entry Page" do

      it "Content" do
        @glucose.getScreenContent().split("\n").each_with_index do | screenRow, i |
          break if (screenRow == "230 characters left" )
          expect(screenRow).to eq(@ENTRY_FORM[i])
        end
      end

      it "Required" do
        expect(@glucose.isFieldRequired(:css, Glucose::DATE)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::TIME)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::GLUCOSE_LEVEL)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::TESTED)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::NOTE)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @glucose.setInput(Glucose::DATE, "")
        @glucose.setInput(Glucose::TIME, "")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "")
        @glucose.setSelectBoxValue(Glucose::TESTED, "Select")

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        @glucose.setInput(Glucose::DATE, "11/01")
        @glucose.setInput(Glucose::TIME, "03")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "500")
        @glucose.setSelectBoxValue(Glucose::TESTED, "Fasting (8 hours)")

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @glucose.setInput(Glucose::DATE, futureDate)
          @glucose.setInput(Glucose::TIME, formatTimeAMPM(Time.now()))
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
          @glucose.clickSaveButton()

          !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
        end

        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
        @glucose.setInput(Glucose::DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @glucose.setInput(Glucose::TIME, time)

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end

    end

    describe "AC JRNL-1483|TC JRNL-1443: Standard Functions Available" do

      it "Cancel" do
        expect(@glucose.isCancelButtonVisible()).to eq(true)

        @glucose.clickCancelButton()
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

        expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("01/01/2014")
        expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("08:10 AM")
        expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("10")
        expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("Fasting (8 hours)")
        expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("Tested While Fasting")
        expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("230 characters left")

        @glucose.clickCancelButton()
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Delete" do
        clickNthRow(1)
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

        expect(@glucose.isDeleteButtonVisible()).to eq(true)

        @glucose.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@glucose.getFocusedElementText()).to eq("Delete")

        @glucose.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        expect(retreiveAllDocumentsInCollection("chemlabs", "medicalhistorydb").length()).to eq(@countBeforeDelete)
      end

      describe "Save" do

        it "Min" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          @glucose.click(:css, Glucose::DATE_BUTTON)
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @date_picker.setDateFromGUI(12, 3, 2014)
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          expect(@time_picker.areMinutesIn5MinIntervals()).to eq(false)
          @time_picker.setTimeFromGUI(2, 30, "PM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

          @glucose.setInput(Glucose::GLUCOSE_LEVEL, "0")
          @glucose.setSelectBoxValue(Glucose::TESTED, "Fasting (8 hours)")
          @glucose.setInput(Glucose::NOTE, "")

          @glucose.clickSaveButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("12/03/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("02:30 PM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("0")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("Fasting (8 hours)")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
        end

        it "Max" do
          @glucose.setInput(Glucose::DATE, "12/02/2014")
          @glucose.setInput(Glucose::TIME, "10:55 AM")
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
          @glucose.setSelectBoxValue(Glucose::TESTED, "After Meal")
          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE).length()).to eq(250)
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          @glucose.clickSaveButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("12/02/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("10:55 AM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("400")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("After Meal")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
        end

      end

    end

    describe "AC JRNL-1482|TC JRNL-1443: Navigation" do

      describe "Clicking Menu" do

        it "No Changes" do
          @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
        end

        it "Changes" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          @glucose.setInput(Glucose::NOTE, "XYZ")

          @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
        end

      end

      describe "Back Button" do

        it "Alt Text" do
          expect(@glucose.getBackButtonAltText()).to eq("Return to Previous Screen")
        end

        it "No Changes" do
          @common.clickBackButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
        end

        it "Changes" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          @glucose.setInput(Glucose::NOTE, "XYZ")

          @glucose.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          @glucose.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")

          @glucose.clickCancelButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
        end

      end

    end

  end

end
