require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1563: Glucose - Add][Story #JRNL-1425: Modify Fields]", :broken => true, :regression => true do

  before(:all) do
    ## JRNL-1425 changes "Test Condition" to "Tested" and options to: "Fasting (8 hours)", "After Meal" and "Unknown"
    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Glucose Level (mg/dl):",
        "Between 0 and 400",
        "* Tested:",
        "Select",
        "Fasting (8 hours)",
        "After Meal",
        "Unknown",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("chemlabs", "medicalhistorydb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    waitForPageToFinishLoading
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
    waitForPageToFinishLoading
    expect(getSecondaryHeader()).to eq("Personal Trackers")
    @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
    waitForPageToFinishLoading
    expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
    @glucoseFilter.setDateRangeAndFilter("01/01/2012", "11/17/2014")
    #expect(getCount()).to eq(0)
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1485|TC-3608: Add Button" do
    it "Visible" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

    it "Alt Text" do
      expect(@common.getAddButtonAltText()).to eq("Add")
    end
  end

  describe "AC JRNL-1485|TC-3608: When Selecting Add" do
    it "Header" do
      #@common.clickAddButton
      sleep 2
      @driver.find_element(:xpath, "//button[@aria-label='Add']").click
      waitForPageToFinishLoading
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)
    end

   describe "Detailed Fields" do
    it "Content" do
      @glucose.getScreenContent().split("\n").each_with_index do | screenRow, i |
      break if (screenRow == "250 characters left" )
      #expect(screenRow).to eq(@ENTRY_FORM[i])
      end
    end

    it "Required" do
      expect(@glucose.isFieldRequired(:css, Glucose::DATE)).to eq(true)
      expect(@glucose.isFieldRequired(:css, Glucose::TIME)).to eq(true)
      expect(@glucose.isFieldRequired(:css, Glucose::GLUCOSE_LEVEL)).to eq(true)
      #expect(@glucose.isFieldRequired(:css, Glucose::TESTED)).to eq(true)
      expect(@glucose.isFieldRequired(:css, Glucose::NOTE)).to eq(false)
    end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")
        @glucose.setInput(Glucose::DATE, "")
        @glucose.setInput(Glucose::TIME, "")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "")
        @driver.find_element(:xpath, "//select[@name='Tested']").send_keys "Select"
        waitForPageToFinishLoading
        @glucose.clickSaveButton
        waitForPageToFinishLoading
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        @glucose.setInput(Glucose::DATE, "11/01")
        @glucose.setInput(Glucose::TIME, "03")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "500")
        #@glucose.setSelectBoxValue(Glucose::TESTED, "Fasting (8 hours)")
        @driver.find_element(:xpath, "//select[@name='Tested']").send_keys "Fasting (8 hours)"
        waitForPageToFinishLoading
        @glucose.clickSaveButton
        @glucose.clickConfirmSave
        waitForPageToFinishLoading
        @glucose.clickSaveButton
        waitForPageToFinishLoading
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(true)
        #expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @glucose.setInput(Glucose::DATE, futureDate)
          @glucose.setInput(Glucose::TIME, formatTimeAMPM(Time.now()))
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
          @glucose.clickSaveButton
          waitForPageToFinishLoading
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
        end

        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
        @glucose.setInput(Glucose::DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @glucose.setInput(Glucose::TIME, time)
        @glucose.clickSaveButton
        waitForPageToFinishLoading
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        #expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end
    end

    describe "AC JRNL-1485|TC-3608: Standard Save and Cancel Options" do
      it "Cancel" do
        expect(@glucose.isCancelButtonVisible()).to eq(true)
        @glucose.clickCancelButton()
        waitForPageToFinishLoading
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
        #expect(getCount()).to eq(0)
      end

      describe "Save" do
        it "Min" do
          @common.clickAddButton()
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)
          waitForPageToFinishLoading
          @glucose.setInput(Glucose::DATE, "11/11/2014")
          waitForPageToFinishLoading
          @glucose.setInput(Glucose::TIME, "02:35 PM")
          waitForPageToFinishLoading
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, 50)
          waitForPageToFinishLoading
          @glucose.setSelectBoxTested("After Meal")
          waitForPageToFinishLoading
          @glucose.clickSaveButton
          waitForPageToFinishLoading
          expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)
        end

        it "Verify Saved Data" do
          #clickNthRow(1)
          @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[1]/span[4]").click
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)
          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/13/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("07:10 AM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("400")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("After Meal")
          #expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("")
          #expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")

          @glucose.clickCancelButton()
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
          #expect(getCount()).to eq(1)
        end

        it "Max" do
          @driver.find_element(:xpath, "//button[@aria-label='Add']").click
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)
          @glucose.setInput(Glucose::DATE, "11/13/2014")
          @glucose.setInput(Glucose::TIME, "07:10 AM")
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, 400)
          @glucose.setSelectBoxTested("After Meal")
          waitForPageToFinishLoading
          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")
          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE).length()).to eq(250)
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
          #@glucose.clickSaveButton()
          @driver.find_element(:xpath, "//button[@ng-click='confirmSave()']").click
          waitForPageToFinishLoading
          expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)
            waitForPageToFinishLoading
          #expect(getCount()).to eq(2)
        end

        it "Verify Saved Data" do
          #clickNthRow(1)
          @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[1]/span[4]").click
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)
          waitForPageToFinishLoading
          expect(isElementPresentAndVisible(:css, "form[name='form']")).to eq(true)
          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/13/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("07:10 AM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("400")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("After Meal")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE).length()).to eq(250)
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
          @glucose.clickCancelButton()
          waitForPageToFinishLoading
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)
          #expect(getCount()).to eq(2)
        end

      end
    end
   end
end






































=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1563: Glucose - Add][Story #JRNL-1425: Modify Fields]", :broken => true, :regression => true do

  before(:all) do
    ## JRNL-1425 changes "Test Condition" to "Tested" and options to: "Fasting (8 hours)", "After Meal" and "Unknown"
    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Glucose Level (mg/dl):",
        "Between 0 and 400",
        "* Tested:",
        "Select",
        "Fasting (8 hours)",
        "After Meal",
        "Unknown",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("chemlabs", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
    !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
    expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

    expect(getCount()).to eq(0)

    @glucoseFilter.setDateRangeAndFilter("01/01/2012", "11/17/2014")

    expect(getCount()).to eq(0)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1485|TC-3608: Add Button" do

    it "Visible" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

    it "Alt Text" do
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

  end

  describe "AC JRNL-1485|TC-3608: When Selecting Add" do

    it "Header" do
      @common.clickAddButton()
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::ADD_HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)
    end

    describe "Detailed Fields" do
      it "Content" do
        @glucose.getScreenContent().split("\n").each_with_index do | screenRow, i |
          break if (screenRow == "250 characters left" )
          expect(screenRow).to eq(@ENTRY_FORM[i])
        end
      end

      it "Required" do
        expect(@glucose.isFieldRequired(:css, Glucose::DATE)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::TIME)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::GLUCOSE_LEVEL)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::TESTED)).to eq(true)
        expect(@glucose.isFieldRequired(:css, Glucose::NOTE)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @glucose.setInput(Glucose::DATE, "")
        @glucose.setInput(Glucose::TIME, "")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "")
        @glucose.setSelectBoxValue(Glucose::TESTED, "Select")

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        @glucose.setInput(Glucose::DATE, "11/01")
        @glucose.setInput(Glucose::TIME, "03")
        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "500")
        @glucose.setSelectBoxValue(Glucose::TESTED, "Fasting (8 hours)")

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @glucose.setInput(Glucose::DATE, futureDate)
          @glucose.setInput(Glucose::TIME, formatTimeAMPM(Time.now()))
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
          @glucose.clickSaveButton()


          !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
        end

        @glucose.setInput(Glucose::GLUCOSE_LEVEL, "400")
        @glucose.setInput(Glucose::DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @glucose.setInput(Glucose::TIME, time)

        @glucose.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) field is required.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Glucose Level (mg/dl) is outside the expected range. Please enter a value between 0 and 400.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Tested field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end

    end

    describe "AC JRNL-1485|TC-3608: Standard Save and Cancel Options" do

      it "Cancel" do
        expect(@glucose.isCancelButtonVisible()).to eq(true)

        @glucose.clickCancelButton()
        !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
        expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

        expect(getCount()).to eq(0)
      end

      describe "Save" do

        it "Min" do
          @common.clickAddButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::ADD_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)

          @date_picker.click(:css, Glucose::DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
          @date_picker.setDateFromGUI(11, 11, 2014)
          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/11/2014")

          @time_picker.click(:css, Glucose::TIME_BUTTON)
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @time_picker.setTimeFromGUI(2, "35", "PM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("02:35 PM")

          @glucose.setInput(Glucose::GLUCOSE_LEVEL, 50)
          @glucose.setSelectBoxValue(Glucose::TESTED, "Fasting (8 hours)")

          @glucose.clickSaveButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(1)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/11/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("02:35 PM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("50")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("Fasting (8 hours)")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")

          @glucose.clickCancelButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(1)
        end

        it "Max" do
          @common.clickAddButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::ADD_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)

          @glucose.setInput(Glucose::DATE, "11/13/2014")
          @glucose.setInput(Glucose::TIME, "07:10 AM")
          @glucose.setInput(Glucose::GLUCOSE_LEVEL, 400)
          @glucose.setSelectBoxValue(Glucose::TESTED, "After Meal")
          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

          @glucose.setInput(Glucose::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE).length()).to eq(250)
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          @glucose.clickSaveButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(2)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)
          !45.times{ break if(isElementPresentAndVisible(:css, "form[name='form']")); sleep 1 }
          expect(isElementPresentAndVisible(:css, "form[name='form']")).to eq(true)

          expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/13/2014")
          expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("07:10 AM")
          expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("400")
          expect(@glucose.getSelectBoxText(Glucose::TESTED)).to eq("After Meal")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@glucose.getTextFromInput(:css, Glucose::NOTE).length()).to eq(250)
          expect(@glucose.getTextForElement(:css, Glucose::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          @glucose.clickCancelButton()
          !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
          expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

          expect(getCount()).to eq(2)
        end

      end

    end

  end

end
=end