require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2508: Move Exercise to the grouped Personal Tracker View]
          [Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-24: Exercise/activities: Enter Delete Edit]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-751: Update detail view default screen message]
          [Story #JRNL-1413: Update Exercise Tracker]
          [Story JRNL-1369: Exercise Filter View: Update Exercise Table Column Order]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    dropCollection("chemlabs", "medicalhistorydb")
    dropCollection("chemlabsbundles", "medicalhistorydb")
    dropCollection("vitalsigns", "medicalhistorydb")
    dropCollection("vitalsignsbundles", "medicalhistorydb")
    dropCollection("mood", "medicalhistorydb")
    dropCollection("fitness", "healthfactordb")

    @baseNav = "Exercise"
    @expectedHeaders = {
        "add" => "Add Exercise Entry",
        "edit" => "Edit Exercise Entry",
        "summary" => "Exercise",
        "secondary" => "Personal Trackers",
        "title" => "Personal Trackers"
    }
    @normalTableHeaders = [ "Activity", "Duration (min)", "Distance (miles)",
                            "Intensity", "Date Entered"
    ]

    @phoneTableHeaders = ["Activity", "Date Entered"]

    @addDataSet = [
      {"activityInput" => "Walking"              , "intensityInput" => ""              , "distanceInput" => "81.0" , "durationInput" => "0"  },
      {"activityInput" => "Running"              , "intensityInput" => "Very Easy"     , "distanceInput" => "82.9" , "durationInput" => "999"},
      {"activityInput" => "Cycling"              , "intensityInput" => "Easy"          , "distanceInput" => "99.9" , "durationInput" => "10" },
      {"activityInput" => "Swimming"             , "intensityInput" => "Somewhat Easy" , "distanceInput" => "84"   , "durationInput" => "0"  },
      {"activityInput" => "Dancing"              , "intensityInput" => "Somewhat Hard"                             , "durationInput" => "433"},
      {"activityInput" => "Tennis"               , "intensityInput" => "Hard"                                      , "durationInput" => "54" },
      {"activityInput" => "Hiking"               , "intensityInput" => "Very Hard"     , "distanceInput" => "0"    ,                         },
      {"activityInput" => "Gym"                  , "intensityInput" => ""                                          , "durationInput" => "5"  },
      {"activityInput" => "Housework"            , "intensityInput" => "Very Easy"                                 , "durationInput" => "56" },
      {"activityInput" => "Gardening"            , "intensityInput" => "Easy"                                      , "durationInput" => "0"  },
      {"activityInput" => "Golf"                 , "intensityInput" => "Somewhat Easy"                             , "durationInput" => "998"},
      {"activityInput" => "Yoga"                 , "intensityInput" => "Somewhat Hard"                             , "durationInput" => "0"  },
      {"activityInput" => "Rowing"               , "intensityInput" => "Hard"          , "distanceInput" => "0.0"  , "durationInput" => "0"  },
      {"activityInput" => "Stairs"               , "intensityInput" => "Very Hard"     , "distanceInput" => "0.1"  , "durationInput" => "0"  },
      {"activityInput" => "Sports"               , "intensityInput" => ""                                          , "durationInput" => "0"  },
    ]

    @editDataSet = [
      {"activityInput" => "General Calisthenics" , "intensityInput" => "Very Easy"                                 , "durationInput" => "0"  },
      {"activityInput" => "Weight Lifting"       , "intensityInput" => "Easy"                                      , "durationInput" => "0"  },
      {"activityInput" => "Other"                , "intensityInput" => "Somewhat Easy" , "distanceInput" => "0.5"  ,                         },
    ]

    @disable_distance_data_set = [
      {"activityInput" => "Dancing"    },
      {"activityInput" => "Tennis"     },
      {"activityInput" => "Gym"        },
      {"activityInput" => "Housework"  },
      {"activityInput" => "Gardening"  },
      {"activityInput" => "Golf"       },
      {"activityInput" => "Yoga"       },
      {"activityInput" => "Sports"     },
      {"activityInput" => "General Calisthenics"},
      {"activityInput" => "Weight Lifting"}
    ]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["activityInput", "durationInput", "distanceInput", "intensityInput", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form"
    }

    @fields = {
      "activityInput" => {
        "label" => "Activity:",
        "type" => "select",
        "options" => ["", "Walking", "Running", "Cycling", "Swimming",
                      "Dancing", "Tennis", "Hiking", "Gym", "Housework",
                      "Gardening", "Golf", "Yoga", "Rowing", "Stairs", "Sports",
                      "General Calisthenics", "Weight Lifting", "Other"],
        "required" => true
      },
      "intensityInput" => {
        "label" => "Intensity:",
        "type" => "select",
        "options" => ["", "Very Easy", "Easy", "Somewhat Easy", "Somewhat Hard",
                      "Hard", "Very Hard"]
      },
      "distanceInput" => {
        "label" => "Distance (miles):",
        "type" => "keyboard",
        "min" => "0.0",
        "max" => "99.9",
        "minDelta" => 0.1
      },
      "durationInput" => {
        "label" => "Duration (min):",
        "type" => "keyboard",
        "min" => "0",
        "max" => "999",
        "minDelta" => 1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  # after (:all) do
  #   quitDriver()
  # end

  # context "#AC #JRNL-1872|TC #JRNL-1824: Exercise entries in detail view
  #          #AC #JRNL-1871|TC #JRNL-1824: Add Exercise Entry for Move Exercise to the grouped Personal Tracker
  #          #AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
  #          AC#JRNL-377|TC#JRNL-519|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744|AC#JRNL-791|TC#JRNL-812: User can add and edit an exercise entry; Error message presentation; Required field validation and Boundary Test for Distance/Duration; Verify the max allowed character for Narrative; Display a message in the detailed pane when no items are selected
  #          AC #JRNL-1350 Change Intensity Field
  #          AC #JRNL-1349 Update Activity List
  #          AC #JRNL-1348 Amount Value field | TC #JRNL-1321
  #          AC #JRNL-1347 Update to Exercise Column Order Display | TC #JRNL-1321" do
  #
  #   it ".Intensity Info button", :broken => true do
  #     @main.clickNavMenu
  #     fieldLabelTests(@fields)
  #     waitForPageToFinishLoading
  #     @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
  #     waitForPageToFinishLoading
  #     expect(getSecondaryHeader()).to eq("Personal Trackers")
  #     waitForPageToFinishLoading
  #     @personal_trackers.clickExercise
  #     waitForPageToFinishLoading
  #     expect(getPrimaryHeader()).to eq("Exercise")
  #     waitForPageToFinishLoading
  #
  #     @common.clickAddButton()
  #     #!15.times { break if (getPrimaryHeader()== "Add Exercise Entry"); sleep 1 }
  #     waitForPageToFinishLoading
  #     expect(getPrimaryHeader()).to eq("Add Exercise Entry")
  #
  #     click(:css, "i.icon-info")
  #     sleep 2
  #     #!45.times { break if (@modal.getConfirmationHeading()== "Intensity Rating"); sleep 1 }
  #     waitForPageToFinishLoading
  #     expect(@modal.getConfirmationHeading()).to eq("Intensity Rating")
  #
  #     intensity_popup_screen_text = [
  #         "Very Hard",
  #         "Almost impossible to maintain, unable to talk",
  #         "Hard",
  #         "Difficult to maintain intensity, can speak a few words",
  #         "Somewhat Hard",
  #         "Labored breathing (uncomfortable), can speak a sentence",
  #         "Somewhat Easy",
  #         "Breathing noticeable, can hold a conversation",
  #         "Easy",
  #         "Breathing not noticeable, can hold a conversation",
  #         "Very Easy",
  #         "Anything other than sleeping"
  #     ]
  #
  #     @modal.getConfirmationMessage().split("\n").each_with_index do | screenRow, i |
  #       expect(screenRow.strip).to eq(intensity_popup_screen_text[i])
  #     end
  #
  #     expect(@modal.getConfirmationMessage().split("\n").length).to eq(intensity_popup_screen_text.length)
  #
  #     expect(@modal.getCancelButtonText()).to eq("")
  #
  #     expect(getElementColor(".very-hard","background-color")).to     eq("#FE3B00")
  #     expect(getElementColor(".hard","background-color")).to          eq("#F79033")
  #     expect(getElementColor(".somewhat-hard","background-color")).to eq("#D6EE1E")
  #     expect(getElementColor(".somewhat-easy","background-color")).to eq("#8EF632")
  #     expect(getElementColor(".easy","background-color")).to          eq("#25BEA1")
  #     expect(getElementColor(".very-easy","background-color")).to     eq("#95D0F1")
  #
  #     @modal.clickCancelButtonByFunctionName("modalContent.close()")  # The OK button
  #     sleep 2
  #     @entry_form.clickCancelButton()
  #     sleep 2
  #   end
  #
  #   it ".Re-label 'Distance (mi)' to 'Distance (miles)'", :broken => true do
  #     fieldLabelTests(@fields)
  #   end
  #
  #   it ".Boundary Test for Distance/Duration
  #      .Error message presentation and Required field validation
  #      .Verify the max allowed character for Narrative
  #      .Activity: add 'Select' to the list of values and default the drop down list to 'Select' when a new record is added; make the field required
  #      .Intensity: add 'Select' to the list of values and default the drop down list to 'Select' when a new record is added", :broken => true do
  #       @nav_menu.navigate(@baseNav)
  #       waitForPageToFinishLoading
  #       @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
  #       waitForPageToFinishLoading
  #       @personal_trackers.clickExercise
  #       waitForPageToFinishLoading
  #       @common.clickAddButton
  #       waitForPageToFinishLoading
  #       #fieldRestrictionTests(@fields)
  #   end
  #
  #   it ".Verify disabled Distance field.", :broken => true do
  #     @nav_menu.navigate(@baseNav)
  #     #click(:css, @misc.addEntryButton)
  #     waitForPageToFinishLoading
  #     @disable_distance_data_set.each{ | entryMap |
  #       setEntryValues(entryMap)
  #       expect(getField("distanceInput").enabled?).to eq(false)
  #     }
  #
  #     @entry_form.clickCancelButton()
  #   end
  #
  #
  #   it ".header 'Add <personal tracker name> Entry'
  #       .User can add entry
  #       .Display user entered data", :broken => true do
  #       refreshBrowser
  #       addTest(@fields, @addDataSet)
  #       unsavedWarningModalTests()
  #   end
  #
  #   it ".header 'Edit <personal tracker name> Entry'
  #       .User can edit a entries
  #       .Selecting a exercise entry from the table opens the exercise record in the detail view.", :broken => true do
  #     @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
  #   end
  #
  # end

  # context "#AC #JRNL-1876|TC #JRNL-1824: Filter Feature for Move Exercise to the Personal Tracker
  #          #AC #JRNL-1875|TC #JRNL-1824: Date Range for Move Exercise to the Personal Tracker
  #          #AC #JRNL-1874|TC #JRNL-1824: Filter Button for Move Exercise to the Personal Tracker
  #          AC#JRNL-376|TC#:JRNL-519|AC#JRNL-788|TC#JRNL-812: User can access Exercise from left Nav; Default displayed message" do
  #
  #   it ".header '<personal tracker name>'
  #       .When the user selects Exercise from the Personal Trackers list, the system displays the Exercise Filter fields and Exercise entry summary table in the Detail screen (header: Exercise)
  #       .Verify Screen Headers", :broken => true do
  #       @main.clickNavMenu
  #       waitForPageToFinishLoading
  #       @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
  #       waitForPageToFinishLoading
  #       @personal_trackers.clickExercise
  #       waitForPageToFinishLoading
  #       navigationTests()
  #   end
  #
  #   it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
  #       .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
  #       .Date Range (default to last 30 days)
  #       .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
  #       .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
  #     refreshBrowser()
  #
  #     #expect(@date_filter.isDefaultDateRange()).to eq(true)
  #     #expect(@date_filter.isDefaultDateRange()).to eq(false)
  #
  #
  #     filterLabelsAndPlaceholdersTest()
  #   end
  #
  #   # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
  #   #   Tested in Guidance_Text_JRNL_620_spec.rb
  #   # end
  #
  #   it ".Changing the date range and selecting Filter button updates the table view
  #       .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
  #       .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
  #     filterTest(@crossBlockSharing["expectedRowStrings"])
  #   end
  #
  # end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do


    it "Visible", :broken => true do
     @main.clickNavMenu
     waitForPageToFinishLoading
     @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
     waitForPageToFinishLoading
     @personal_trackers.clickExercise
     waitForPageToFinishLoading
     expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Activity")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      #expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC#JRNL-378|TC#JRNL-519: Entries will be sorted in reverse chronological order
           #AC #JRNL-1873|TC #JRNL-1824: Exercise Entries in a table" do

    it ".Exercise entries are displayed in a table format", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".sorted in reverse chronological order using date and time values", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC#JRNL-377|TC#JRNL-519: The user will be able to remove(delete) activity entries" do

    it ".The user will be able to remove(delete) activity entries", :broken => true do
      deleteTest()
    end

  end

end






































=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2508: Move Exercise to the grouped Personal Tracker View]
          [Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
          [Story #JRNL-24: Exercise/activities: Enter Delete Edit]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-751: Update detail view default screen message]
          [Story #JRNL-1413: Update Exercise Tracker]
          [Story JRNL-1369: Exercise Filter View: Update Exercise Table Column Order]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    dropCollection("chemlabs", "medicalhistorydb")
    dropCollection("chemlabsbundles", "medicalhistorydb")
    dropCollection("vitalsigns", "medicalhistorydb")
    dropCollection("vitalsignsbundles", "medicalhistorydb")
    dropCollection("mood", "medicalhistorydb")
    dropCollection("fitness", "healthfactordb")

    @baseNav = "Exercise"
    @expectedHeaders = {
        "add" => "Add Exercise Entry",
        "edit" => "Edit Exercise Entry",
        "summary" => "Exercise",
        "secondary" => "Personal Trackers",
        "title" => "Personal Trackers"
    }
    @normalTableHeaders = [ "Activity", "Duration (min)", "Distance (miles)",
                            "Intensity", "Date Entered"
    ]

    @phoneTableHeaders = ["Activity", "Date Entered"]

    @addDataSet = [
      {"activityInput" => "Walking"              , "intensityInput" => ""              , "distanceInput" => "81.0" , "durationInput" => "0"  },
      {"activityInput" => "Running"              , "intensityInput" => "Very Easy"     , "distanceInput" => "82.9" , "durationInput" => "999"},
      {"activityInput" => "Cycling"              , "intensityInput" => "Easy"          , "distanceInput" => "99.9" , "durationInput" => "10" },
      {"activityInput" => "Swimming"             , "intensityInput" => "Somewhat Easy" , "distanceInput" => "84"   , "durationInput" => "0"  },
      {"activityInput" => "Dancing"              , "intensityInput" => "Somewhat Hard"                             , "durationInput" => "433"},
      {"activityInput" => "Tennis"               , "intensityInput" => "Hard"                                      , "durationInput" => "54" },
      {"activityInput" => "Hiking"               , "intensityInput" => "Very Hard"     , "distanceInput" => "0"    ,                         },
      {"activityInput" => "Gym"                  , "intensityInput" => ""                                          , "durationInput" => "5"  },
      {"activityInput" => "Housework"            , "intensityInput" => "Very Easy"                                 , "durationInput" => "56" },
      {"activityInput" => "Gardening"            , "intensityInput" => "Easy"                                      , "durationInput" => "0"  },
      {"activityInput" => "Golf"                 , "intensityInput" => "Somewhat Easy"                             , "durationInput" => "998"},
      {"activityInput" => "Yoga"                 , "intensityInput" => "Somewhat Hard"                             , "durationInput" => "0"  },
      {"activityInput" => "Rowing"               , "intensityInput" => "Hard"          , "distanceInput" => "0.0"  , "durationInput" => "0"  },
      {"activityInput" => "Stairs"               , "intensityInput" => "Very Hard"     , "distanceInput" => "0.1"  , "durationInput" => "0"  },
      {"activityInput" => "Sports"               , "intensityInput" => ""                                          , "durationInput" => "0"  },
    ]

    @editDataSet = [
      {"activityInput" => "General Calisthenics" , "intensityInput" => "Very Easy"                                 , "durationInput" => "0"  },
      {"activityInput" => "Weight Lifting"       , "intensityInput" => "Easy"                                      , "durationInput" => "0"  },
      {"activityInput" => "Other"                , "intensityInput" => "Somewhat Easy" , "distanceInput" => "0.5"  ,                         },
    ]

    @disable_distance_data_set = [
      {"activityInput" => "Dancing"    },
      {"activityInput" => "Tennis"     },
      {"activityInput" => "Gym"        },
      {"activityInput" => "Housework"  },
      {"activityInput" => "Gardening"  },
      {"activityInput" => "Golf"       },
      {"activityInput" => "Yoga"       },
      {"activityInput" => "Sports"     },
      {"activityInput" => "General Calisthenics"},
      {"activityInput" => "Weight Lifting"}
    ]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["activityInput", "durationInput", "distanceInput", "intensityInput", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form"
    }

    @fields = {
      "activityInput" => {
        "label" => "Activity:",
        "type" => "select",
        "options" => ["", "Walking", "Running", "Cycling", "Swimming",
                      "Dancing", "Tennis", "Hiking", "Gym", "Housework",
                      "Gardening", "Golf", "Yoga", "Rowing", "Stairs", "Sports",
                      "General Calisthenics", "Weight Lifting", "Other"],
        "required" => true
      },
      "intensityInput" => {
        "label" => "Intensity:",
        "type" => "select",
        "options" => ["", "Very Easy", "Easy", "Somewhat Easy", "Somewhat Hard",
                      "Hard", "Very Hard"]
      },
      "distanceInput" => {
        "label" => "Distance (miles):",
        "type" => "keyboard",
        "min" => "0.0",
        "max" => "99.9",
        "minDelta" => 0.1
      },
      "durationInput" => {
        "label" => "Duration (min):",
        "type" => "keyboard",
        "min" => "0",
        "max" => "999",
        "minDelta" => 1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  # it "AC#JRNL-376|TC#:JRNL-519|AC#JRNL-788|TC#JRNL-812: User can access Exercise from left Nav; Default displayed message" do
  # end

  context "#AC #JRNL-1872|TC #JRNL-1824: Exercise entries in detail view
           #AC #JRNL-1871|TC #JRNL-1824: Add Exercise Entry for Move Exercise to the grouped Personal Tracker
           #AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC#JRNL-377|TC#JRNL-519|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744|AC#JRNL-791|TC#JRNL-812: User can add and edit an exercise entry; Error message presentation; Required field validation and Boundary Test for Distance/Duration; Verify the max allowed character for Narrative; Display a message in the detailed pane when no items are selected
           AC #JRNL-1350 Change Intensity Field
           AC #JRNL-1349 Update Activity List
           AC #JRNL-1348 Amount Value field | TC #JRNL-1321
           AC #JRNL-1347 Update to Exercise Column Order Display | TC #JRNL-1321" do

    it ".Intensity Info button", :broken => true do
      @nav_menu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")

      @nav_menu.clickExercise()
      !45.times{ break if (getPrimaryHeader() == "Exercise"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Exercise")

      @common.clickAddButton()
      !15.times { break if (getPrimaryHeader()== "Add Exercise Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Exercise Entry")

      click(:css, "i.icon-info")
      sleep 2
      !45.times { break if (@modal.getConfirmationHeading()== "Intensity Rating"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Intensity Rating")

      intensity_popup_screen_text = [
          "Very Hard",
          "Almost impossible to maintain, unable to talk",
          "Hard",
          "Difficult to maintain intensity, can speak a few words",
          "Somewhat Hard",
          "Labored breathing (uncomfortable), can speak a sentence",
          "Somewhat Easy",
          "Breathing noticeable, can hold a conversation",
          "Easy",
          "Breathing not noticeable, can hold a conversation",
          "Very Easy",
          "Anything other than sleeping"
      ]

      @modal.getConfirmationMessage().split("\n").each_with_index do | screenRow, i |
        expect(screenRow.strip).to eq(intensity_popup_screen_text[i])
      end

      expect(@modal.getConfirmationMessage().split("\n").length).to eq(intensity_popup_screen_text.length)

      expect(@modal.getCancelButtonText()).to eq("OK")

      expect(getElementColor(".very-hard","background-color")).to     eq("#FE3B00")
      expect(getElementColor(".hard","background-color")).to          eq("#F79033")
      expect(getElementColor(".somewhat-hard","background-color")).to eq("#D6EE1E")
      expect(getElementColor(".somewhat-easy","background-color")).to eq("#8EF632")
      expect(getElementColor(".easy","background-color")).to          eq("#25BEA1")
      expect(getElementColor(".very-easy","background-color")).to     eq("#95D0F1")

      @modal.clickCancelButtonByFunctionName("modalContent.close()")  # The OK button
      sleep 2
      @entry_form.clickCancelButton()
      sleep 2
    end

    it ".Re-label 'Distance (mi)' to 'Distance (miles)'", :broken => true do
      fieldLabelTests(@fields)
    end

    it ".Boundary Test for Distance/Duration
        .Error message presentation and Required field validation
        .Verify the max allowed character for Narrative
        .Activity: add 'Select' to the list of values and default the drop down list to 'Select' when a new record is added; make the field required
        .Intensity: add 'Select' to the list of values and default the drop down list to 'Select' when a new record is added", :broken => true do
      fieldRestrictionTests(@fields)
    end

    it ".Verify disabled Distance field.", :broken => true do
      @nav_menu.navigate(@baseNav)

      click(:css, @misc.addEntryButton)
      waitForPageToFinishLoading()

      @disable_distance_data_set.each{ | entryMap |
        setEntryValues(entryMap)
        expect(getField("distanceInput").enabled?).to eq(false)
      }

      @entry_form.clickCancelButton()
    end

    it ".header 'Add <personal tracker name> Entry'
        .User can add entry
        .Display user entered data", :broken => true do
      addTest(@fields, @addDataSet)

      unsavedWarningModalTests()
    end

    it ".header 'Edit <personal tracker name> Entry'
        .User can edit a entries
        .Selecting a exercise entry from the table opens the exercise record in the detail view.", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1876|TC #JRNL-1824: Filter Feature for Move Exercise to the Personal Tracker
           #AC #JRNL-1875|TC #JRNL-1824: Date Range for Move Exercise to the Personal Tracker
           #AC #JRNL-1874|TC #JRNL-1824: Filter Button for Move Exercise to the Personal Tracker
           AC#JRNL-376|TC#:JRNL-519|AC#JRNL-788|TC#JRNL-812: User can access Exercise from left Nav; Default displayed message" do

    it ".header '<personal tracker name>'
        .When the user selects Exercise from the Personal Trackers list, the system displays the Exercise Filter fields and Exercise entry summary table in the Detail screen (header: Exercise)
        .Verify Screen Headers", :broken => true do
      navigationTests()
    end

    it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
      refreshBrowser()

      expect(@date_filter.isDefaultDateRange()).to eq(true)

      filterLabelsAndPlaceholdersTest()
    end

    # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
    #   Tested in Guidance_Text_JRNL_620_spec.rb
    # end

    it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Activity")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC#JRNL-378|TC#JRNL-519: Entries will be sorted in reverse chronological order
           #AC #JRNL-1873|TC #JRNL-1824: Exercise Entries in a table" do

    it ".Exercise entries are displayed in a table format", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".sorted in reverse chronological order using date and time values", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC#JRNL-377|TC#JRNL-519: The user will be able to remove(delete) activity entries" do

    it ".The user will be able to remove(delete) activity entries", :broken => true do
      deleteTest()
    end

  end

end
=end