require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1422: Personal Trackers - Exercise - Graphs]
[Story #JRNL-1413: Update Exercise Tracker]", :broken => true, :regression => true  do

  ## Must declare globally due to the 'each' loop declaration below
  graphSpecifier = ["Minutes", "Miles"]

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("fitness", "healthfactordb", "exercise")

    initializeAllObjects

    @legendContent = [
        {
            "color" => "#fe3b00",
            "text" => "Very Hard"
        },
        {
            "color" => "#f79033",
            "text" => "Hard"
        },
        {
            "color" => "#d6ee1e",
            "text" => "Somewhat Hard"
        },
        {
            "color" => "#8ef632",
            "text" => "Somewhat Easy"
        },
        {
            "color" => "#25bea1",
            "text" => "Easy"
        },
        {
            "color" => "#95d0f1",
            "text" => "Very Easy"
        },
        {
            "color" => "#696969",
            "text" => "Unknown"
        }
    ]

    @graphInfo = [
        {
            "xAxisLabel" => "Date",
            "yAxisLabel" => "Minutes"
        },
        {
            "xAxisLabel" => "Date",
            "yAxisLabel" => "Miles"
        }
    ]

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @nav_menu.click(:css, Nav_menu::NAV["Exercise"]["navButton"])
    waitForPageToFinishLoading()
    sleep 1
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1346|TC JRNL-1316: Graph Button and Features" do

    it "Button Visibility" do
      expect(is_element_present(:css, graphButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, graphButton())).to eq("Graph")
    end

    it "Button Alt Text" do
      expect(getElement(:css, graphButton()).attribute("title")).to eq("Graph")
    end

    it "Toggle" do
      from = "12/01/2011"
      to = "01/31/2015"

      @date_filter.setDateRangeAndFilter(from, to)
      waitForPageToFinishLoading()

      click(:css, graphButton())
    end

    it "Button Visibility" do
      expect(is_element_present(:css, tableButton())).to eq(true)
    end

    it "Button Text" do
      expect(getTextForElement(:css, tableButton())).to eq("Table")
    end

    it "Button Alt Text" do
      expect(getElement(:css, tableButton()).attribute("title")).to eq("Table")
    end

    it "Informational Text" do
      expect(getTextForElement(:css, viewTableMessage())).to eq("A text description of the information on this page is available in the table view.")
    end

  end

  describe "AC JRNL-1345|AC JRNL-1344|TC JRNL-1316: Graphs
  AC-4417|Change Intensity Field|TC JRNL-1316" do
    ## Having this loop inside the describe with 'it' blocks inside of it will allow the test to keep running if one block fails.
    graphSpecifier.each_with_index do |specifier, i|

      it "Graph Visibility" do
        expect(isElementPresentAndVisible(:css, graphContainer(i+1))).to eq(true)
      end

      it "Graph Title" do
        expect(getGraphTitle(i+1)).to eq("#{specifier} Entered from 12/01/2011 to 01/31/2015")
      end

      it "X-Axis Label" do
        xAxisTitles = getXAxisLabels(i+1)

        for j in 0...xAxisTitles.length
          expect(xAxisTitles[j]).to eq(@graphInfo[i]["xAxisLabel"])
        end
      end

      it "Y-Axis Label" do
        yAxisTitles = getYAxisLabels(i+1)

        for j in 0...yAxisTitles.length
          expect(yAxisTitles[j].to_s).to eq(@graphInfo[i]["yAxisLabel"])
        end
      end

      it "Y-Axis Ticks" do
        yTicks = getYAxisTicks(i+1)
        ## Don't need to verify every y axis tick since they are determined by Highcharts.
        ## Just verify that the first and last are consistent with what the AC states.
        expect(yTicks[0]).to eq("0")
        ## Max should be at least 10% more than the highest y value
        if i == 0 ## Duration Graph
          expect(yTicks[yTicks.length - 1].to_i >= 231).to eq(true)
        else ## Distance Graph
          expect(yTicks[yTicks.length - 1].to_i >= 13).to eq(true)
        end
      end

      it "X-Axis Ticks" do
        xTicks = getXAxisTicks(i+1)
        ## Don't need to verify every x axis tick since they will change with the filter dates.
        ## Just verify that the first and last are consistent with the filter start and end date.
        if i == 0 ## Duration Graph
          expect(xTicks[0]).to eq("2012")
          expect(xTicks[xTicks.length - 1]).to eq("2014")
        else ## Distance Graph
          expect(xTicks[0]).to eq("Jan 2012")
          expect(xTicks[xTicks.length - 1]).to eq("Jan 2015")
        end
      end

      it "Legend Visibility" do
        expect(isLegendDisplayed?(i+1)).to eq(true)
      end

      it "Legend Content" do
        legendContent = getLegendTextAndColor(i+1)

        for j in 0...legendContent.length
          expect(legendContent[j]["color"]).to eq(@legendContent[j]["color"])
          expect(legendContent[j]["text"]).to eq(@legendContent[j]["text"])
        end
      end

      it "Plot Point Count" do
        if i == 0 ## Duration Graph
          expect(getNumberOfBars(i+1)).to eq(7)
        else ## Distance Graph
          expect(getNumberOfBars(i+1)).to eq(4)
        end
      end

    end

  end

  describe "AC JRNL-1343|TC JRNL-1316: Graph Data Display" do

    it "Change Filter Dates" do
      from = "12/01/2012"
      to = "12/31/2013"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getFocusedElementText() == "A text description of the information on this page is available in the table view."); sleep 1}
      expect(getFocusedElementText()).to eq("A text description of the information on this page is available in the table view.")
    end

    it "First Graph Title" do
      expect(getGraphTitle(1)).to eq(graphSpecifier[0] + " Entered from 12/01/2012 to 12/31/2013")
    end

    it "First Graph Row Count" do
      expect(getNumberOfBars(1)).to eq(3)
    end

    it "Second Graph Title" do
      expect(getGraphTitle(2)).to eq(graphSpecifier[1] + " Entered from 12/01/2012 to 12/31/2013")
    end

    it "Second Graph Row Count" do
      expect(getNumberOfBars(2)).to eq(1)
    end

    it "Row Count" do
      click(:css, tableButton())
      !30.times{ break if(getCount() == 4); sleep 1 }
      expect(getCount()).to eq(4)
    end

    it "Filter Persists" do
      expect(@date_filter.getStartDate()).to eq("12/01/2012")
      expect(@date_filter.getEndDate()).to eq("12/31/2013")
    end

  end

end
