require_relative '../../../globalized'
include Globalized
describe "Story#JRNL-24|JRNL-497|JRNL-751: [Exercise_JRNL_24_spec.rb]" do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteRecordsFromTable("EXERCISE", "D123401")
    initializeAllObjects

  end

  after(:all) do
    quitDriver()
  end


  it "AC#JRNL-376|TC#:JRNL-519|AC#JRNL-788|TC#JRNL-812: User can access Exercise from left Nav; Default displayed message" do
    !10.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !10.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !10.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !10.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !10.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    waitForPageToFinishLoading
    @nav_menu.clickPersonalTrackers

    #AC#:JRNL-379
    waitForPageToFinishLoading
    expect(@nav_menu.isDietButtonVisible()).to be true
    @nav_menu.clickExercise()


    ########################################################################################################################
    ########################################################################################################################
    ############################# TITLE IS DISPLAYING AS "Exercise" IN AUTOMATION ##########################################
    ############################# TITLE IS DISPLAYING AS "Personal Trackers" IN APP ########################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # !10.times{ break if (@exercise.getTitle() == "Exercise"); sleep 1 }
    # expect(@exercise.getTitle()).to eq("Exercise")

    ########################################################################################################################
    ########################################################################################################################
    ############################# TITLE IS DISPLAYING AS "Exercise" IN AUTOMATION ##########################################
    ############################# TITLE IS DISPLAYING AS "Personal Trackers" IN APP ########################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

  end

  it "TC#JRNL-519: Verify Screen Headers" do

    ########################################################################################################################
    ########################################################################################################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Activities" IN AUTOMATION #############################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Personal Trackers" IN APP #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # expect(@exercise.getSecondaryHeader()).to eq("Activities")

    ########################################################################################################################
    ########################################################################################################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Activities" IN AUTOMATION #############################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Personal Trackers" IN APP #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Activity Detail" IN AUTOMATION ##########################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Exercise" IN APP ########################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Activity Detail" IN AUTOMATION ##########################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Exercise" IN APP ########################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

    ########################################################################################################################
    ########################################################################################################################
    ############################# THE BELOW TEXT DOES NOT APPEAR ON THE APP ################################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # #display a message in the detailed pane when no items are seleted
    # !10.times{ break if (@exercise.getMessageInDetailScreen() == "Select the Add Entry button to add a new entry.\nSelect the button to add a new entry."); sleep 1 }
    # expect(@exercise.getMessageInDetailScreen()).to eq("Select the Add Entry button to add a new entry.\nSelect the button to add a new entry.")

    ########################################################################################################################
    ########################################################################################################################
    ############################# THE BELOW TEXT DOES NOT APPEAR ON THE APP ################################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################
  end

  it "AC#JRNL-377|TC#JRNL-519|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744|AC#JRNL-791|TC#JRNL-812: User can add and edit an exercise entry; Error message presentation; Required field validation and Boundary Test for Distance/Duration; Verify the max allowed character for Narrative; Display a message in the detailed pane when no items are selected", :broken => true do
    waitForPageToFinishLoading
    @exercise.clickAddActivitiesBtn()

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Activity Detail" IN AUTOMATION ##########################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Add Exercise Entry" IN APP ##############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

    # !10.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    # expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Activity Detail" IN AUTOMATION ##########################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Add Exercise Entry" IN APP ##############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################
    waitForPageToFinishLoading
    @exercise.clickCancelBtn()


    listCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")
    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    threeDaysAgo = getDateNthDaysAgo(3, "%m/%d/%Y")
    fourDaysAgo = getDateNthDaysAgo(4, "%m/%d/%Y")
    fiveDaysAgo = getDateNthDaysAgo(5, "%m/%d/%Y")

    morningTime = "08:00 AM"
    midAMTime = "10:00 AM"
    noonTime = "12:00 PM"
    afternoonTime = "03:00 PM"
    eveningTime = "08:00 PM"
    bedTime = "11:00 PM"

    # If section title shows for the primary header below. This bug is related to JRNL 963.
    waitForPageToFinishLoading
    expect(@exercise.getPrimaryHeader()).to_not eq("{{sectionTitle}}")

    #type: Walking
    enterAndVerifyActivityEntry(today, morningTime, "Walking", "Mild", "2", "60", "Nice walk.")

    #type: Running
    enterAndVerifyActivityEntry(oneDayAgo, noonTime, "Running", "Moderate", "3", "1", "My legs felt sore.")

    #type Bicycling
    enterAndVerifyActivityEntry(twoDaysAgo, afternoonTime, "Bicycling", "Strenuous", "5", "30", "Good work out")

    #type Swimming
    enterAndVerifyActivityEntry(threeDaysAgo, eveningTime, "Swimming", "Mild", "1", "30", "That felt great.")

    #type Weight Lifting
    enterAndVerifyActivityEntry(fourDaysAgo, eveningTime, "Weight Lifting", "Moderate", "0", "20", "5 lbs dumbbell")

    #type General Calisthenic
    enterAndVerifyActivityEntry(fiveDaysAgo, bedTime, "General Calisthenic", "Mild", "0", "30", "Belly crunches and burpees.")

    #validate max 250 characters for Narrative
    @exercise.clickAddActivitiesBtn()
    !10.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    expect(@exercise.verifyTotalCharacterInNarrative()).to be true

    #Boundary Test/Invalid value test
    # boundaryTest("Distance", "Distance must be between 0 and 99.9.") #function is defined at the bottom of this script
    #Currenlty boundary test for Duration has to be manual
    #boundaryTest("Duration")

    #Required fields test
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Exit out of Add a Meal
    @exercise.clickCancelBtn()

    #Can edit an existing meal
    @exercise.clickNthActivity(4)
    !10.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    #update the duration to 99
    @exercise.EditAnActivity(99)

    !10.times{ break if (@exercise.getMessageInDetailScreen() == "Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@exercise.getMessageInDetailScreen()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")

    sleep 2
    #Verify that from the meal entry list, the 4th entry has a new calories reading (1000)
    expect(@exercise.getNthDurationInList(4)).to eq("99 min")

  end

  it "AC#JRNL-378|TC#JRNL-519: Entries will be sorted in reverse chronological order ", :broken => true  do
    waitForPageToFinishLoading
    expect(@exercise.getNthActivityInList(1)).to eq("Walking")
    expect(@exercise.getNthActivityInList(2)).to eq("Running")
    expect(@exercise.getNthActivityInList(3)).to eq("Bicycling")
    expect(@exercise.getNthActivityInList(4)).to eq("Swimming")
    expect(@exercise.getNthActivityInList(5)).to eq("Weight Lifting")
    expect(@exercise.getNthActivityInList(6)).to eq("General Calisthenic")

  end


  it "AC#JRNL-377|TC#JRNL-519: The user will be able to remove(delete) activity entries", :broken => true do
    deleteNthActivity("Walking")
    deleteNthActivity("Running")
    deleteNthActivity("Bicycling")
    deleteNthActivity("Swimming")
    deleteNthActivity("Weight Lifting")
    deleteNthActivity("General Calisthenic")

  end


  it "AC#JRNL-378|TC#JRNL-519: Display user entered data", :broken => true do
    #Default display to last 30 days displaying start and end date
    #Allow user to change date range(date picker will be in another story)
    !10.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    #Verify that by default, the date range is set to last 30 days
    expect(@exercise.verifyDefautDateRangeIs30DaysBack()).to be true

    #Set the date range to 2 years back so all the entered meals will show up
    toDate = @exercise.getDateNthDaysAgo(0, "%m/%d/%Y")  #set it to Today
    fromDate = @exercise.getDateNthDaysAgo(730, "%m/%d/%Y") #set it to two year ago

    @exercise.setDateRange(fromDate, toDate)

    #Populate the list of the meals again
    listCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "12:00 AM"
    noonTime = "12:00 PM"
    dinnerTime = "06:00 PM"
    snackTime = "03:00 PM"

    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    sixtyDaysAgo = getDateNthDaysAgo(60, "%m/%d/%Y")

    enterAndVerifyActivityEntry(sixtyDaysAgo, dinnerTime, "Walking", "Mild", "2", "60", "Nice walk.")
    enterAndVerifyActivityEntry(thirtyDaysAgo, noonTime, "Running", "Moderate", "3", "1", "My legs felt sore.")
    enterAndVerifyActivityEntry(tenDaysAgo, morningTime, "Bicycling", "Strenuous", "5", "30", "Great work out.")
    enterAndVerifyActivityEntry(twoDaysAgo, snackTime, "Swimming", "Moderate", "0", "20", "5 lbs dumbbell.")

    setDateRangeAndValidate(3, 0, "Swimming") #to show the twoDaysAgo entry
    setDateRangeAndValidate(11, 3, "Bicycling") #to show the tenDaysAgo entry
    setDateRangeAndValidate(35, 29, "Running") #to show the thirtyDaysAgo entry
    setDateRangeAndValidate(65, 58, "Walking") #to show the sixtyDaysAgo entry

    refreshBrowser()

  end



  #Beginning of local functions definition block
  def boundaryTest(testArea, errMsg)

    case testArea
      when "Distance" then
        @exercise.setDistance(1000)
      when "Duration" then
        @exercise.setDuration(1000)

    end

    @exercise.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    # !10.times{ break if (@error.getValidationSummaryHeader("exerciseForm") == "The following errors were found:"); sleep 1 }
    # expect(@error.getValidationSummaryHeader("exerciseForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("exerciseForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Distance" then
        @driver.find_element(:css, "input[name='distanceInput']").clear
      when "Duration" then
        @driver.find_element(:css, "input[name='durationInput']").clear

    end

    sleep 2
  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @exercise.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !10.times{ break if (@error.getValidationSummaryHeader("exerciseForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("exerciseForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("exerciseForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  def enterAndVerifyActivityEntry(dateStr, timeStr, type, level, miles, minutes, text)

    @exercise.addAnActivity(dateStr, timeStr, type, level, miles, minutes, text)

    rowIndex = @exercise.findIndexWithAGivenActivityType(type)
    expect(@exercise.getNthActivityInList(rowIndex)).to eq(type)
    expect(@exercise.getNthIntensityInList(rowIndex)).to eq(level)
    expect(@exercise.getNthDistanceInList(rowIndex)).to eq(miles + " mi")
    expect(@exercise.getNthDurationInList(rowIndex)).to eq(minutes + " min")

  end


  def setDateRangeAndValidate(numOfDaysAgoFromDate, numOfDaysAgoToDate, activityTypeStr)
    listCount = @exercise.getTotalItemCountInList()

    toDate = @exercise.getDateNthDaysAgo(numOfDaysAgoToDate, "%m/%d/%Y")  #set it to Today
    fromDate = @exercise.getDateNthDaysAgo(numOfDaysAgoFromDate, "%m/%d/%Y")

    @exercise.setDateRange(fromDate, toDate)
    
    expect(@exercise.isThisItemDisplayed?(activityTypeStr)).to be true
        
    expect(@exercise.isDateWithinFilteredDateRange?()).to be true

    !10.times{ break if (@exercise.getTotalItemCountInList() == 1); sleep 1 }

  end

  def deleteNthActivity(activityType)
    listIndex = @exercise.findIndexWithAGivenActivityType(activityType)
    @exercise.clickNthActivity(listIndex)
    !10.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")

    selectedActivityType = @exercise.getNthActivityInList(listIndex)
    #puts "Selected Activity Type :" + selectedActivityType

    @exercise.clickDeleteBtn()
    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()
    sleep 5
    !10.times{ break if ( @exercise.getNthActivityInList(listIndex) == selectedActivityType); sleep 1 }
    expect(@exercise.getNthActivityInList(listIndex)).to eq(selectedActivityType)

    listCount = @exercise.getTotalItemCountInList()

    @exercise.clickDeleteBtn()
    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !10.times{ break if ( @exercise.getTotalItemCountInList() == (listCount - 1)); sleep 1 }
    expect(@exercise.getTotalItemCountInList()).to eq(listCount - 1)

    expect(@exercise.isThisItemDisplayed?(selectedActivityType)).to be false

  end

end
