require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2509: Move Diet to the grouped Personal Tracker View]
[Story #JRNL-2497: Standardize Add/Edit/Summary Screen Labels for Personal Trackers]
[Story #JRNL-10: Diet: Enter Delete Edit Validate]
[Story #JRNL-497: Convert pop-up error messages to on page]
[Story #JRNL-751: Update detail view default screen message]
[Story #JRNL-1418: Update Diet Tracker]
[Story #JRNL-1399: Tracker Date Column Update]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    dropCollection("chemlabs", "medicalhistorydb")
    dropCollection("chemlabsbundles", "medicalhistorydb")
    dropCollection("vitalsigns", "medicalhistorydb")
    dropCollection("vitalsignsbundles", "medicalhistorydb")
    dropCollection("mood", "medicalhistorydb")
    dropCollection("diet", "healthfactordb")

    @baseNav = "Diet"
    @expectedHeaders = {"add" => "Add Diet Entry", "edit" => "Edit Diet Entry", "summary" => "Diet", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Meal", "Calories (kcal)", "Carbs (g)", "Fat (g)", "Protein (g)", "Date Entered"]
    @phoneTableHeaders = ["Meal", "Date Entered"]

    @addDataSet = [{"mealType" => "Breakfast", "caloriesInput" => "0", "fatInput" => "0", "carbInput" => "0", "proteinInput" => "0"},
      {"mealType" => "Snack", "caloriesInput" => "9999", "fatInput" => "9999.0", "carbInput" => "9999", "proteinInput" => "9999"},
      {"mealType" => "Lunch", "caloriesInput" => "4903", "fatInput" => "5904", "carbInput" => "1939", "proteinInput" => "340"}]

    @editDataSet = [{"mealType" => "Dinner", "caloriesInput" => "8934", "fatInput" => "3218.8", "carbInput" => "1238", "proteinInput" => "9043"},
      {"mealType" => "Breakfast", "caloriesInput" => "3490", "fatInput" => "6840", "carbInput" => "3489", "proteinInput" => "5834"},
      {"mealType" => "Snack", "caloriesInput" => "4898", "fatInput" => "4890.9", "carbInput" => "9403", "proteinInput" => "832"}]

    @metaData = {
      "baseNav" => @baseNav,
      #"orderedColumnsList" => ["mealType", "Date Entered", "caloriesInput", "carbInput", "fatInput", "proteinInput"],
      "orderedColumnsList" => ["mealType", "caloriesInput", "carbInput", "fatInput", "proteinInput", "Date Entered" ],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form"
    }

    @fields = {
      "mealType" => {
        "label" => "Meal Type:",
        "type" => "select",
        "options" => ["", "Breakfast", "Lunch", "Dinner", "Snack"],
        "required" => true
      },
      "caloriesInput" => {
        "label" => "Calories (kcal):",
        "type" => "keyboard",
        "min" => "0",
        "max" => "9999",
        "minDelta" => 1
      },
      "fatInput" => {
        "label" => "Fat (g):",
        "type" => "keyboard",
        "min" => "0.0",
        "max" => "9999.0",
        "minDelta" => 0.1
      },
      "carbInput" => {
        "label" => "Carbs (g):",
        "type" => "keyboard",
        "min" => "0",
        "max" => "9999",
        "minDelta" => 1
      },
      "proteinInput" => {
        "label" => "Protein (g):",
        "type" => "keyboard",
        "min" => "0",
        "max" => "9999",
        "minDelta" => 1
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }

    @expectedScreenContent = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Meal Type:",
        "Select",
        "Breakfast",
        "Lunch",
        "Dinner",
        "Snack",
        "* Nutrition Information: (One entry is required to save)",
        "Calories (kcal):",
        "Between 0 and 9999",
        "Fat (g):",
        "Between 0.0 and 9999.0",
        "Carbs (g):",
        "Between 0 and 9999",
        "Protein (g):",
        "Between 0 and 9999",
        "Note:",
        "250 character maximum",
        "250 characters left",
    ]

    initializeAllObjects

    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  #it "Display a message in the detailed pane when no items are selected;" do
  #end

  context "AC JRNL-1386|TC JRNL-1384: Nutrition Information Label" do

    it "Visible", :broken => true do
      # @nav_menu.navigate(@baseNav)
      # @personal_trackers.clickAddEntryButton()
      # waitForPageToFinishLoading
      # @main.clickNavMenu()
      # fieldLabelTests(@fields)

      @main.clickNavMenu()
      fieldLabelTests(@fields)
      @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
      waitForPageToFinishLoading
      @driver.find_element(:xpath, "//button[@class='btn btn-default blood-pressure-and-pulse']").click
      waitForPageToFinishLoading
      @driver.find_element(:xpath, "//button[@aria-label='Add']").click
      waitForPageToFinishLoading
      @main.clickNavMenu()
      fieldLabelTests(@fields)
      waitForPageToFinishLoading

      @actualScreenContent = getTextForElement(:css, "form[name='#{@formName}']").split("\n")

      # for i in 0..(@actualScreenContent.length - 1)
      #   break if(@actualScreenContent[i] == "Notification:");
      #
      #   expect(@actualScreenContent[i]).to eq(@expectedScreenContent[i])
      # end
    end

    it "Boldness", :broken => true do
      expect(getElement(:css, "fieldset > legend").style('font-weight')).to eq('700')
      expect(getElement(:css, Diet::INSTRUCTION_TEXT).style('font-weight')).to eq('400')
      expect(getElement(:css, Diet::CALORIES_LABEL).style('font-weight')).to eq('400')
      expect(getElement(:css, Diet::FAT_LABEL).style('font-weight')).to eq('400')
      expect(getElement(:css, Diet::CARB_LABEL).style('font-weight')).to eq('400')
      expect(getElement(:css, Diet::PROTEIN_LABEL).style('font-weight')).to eq('400')
    end

  end


  context "AC JRNL-1385|TC-4160: Nutrition Information" do

    it "Validation", :broken => true do
      errorMessage = "You must enter a value in at least one of the following fields before you can save: Calories (kcal), Fat (g), Carbs (g), Protein (g)."

      @entry_form.clickSaveButton()
      checkingInlineError(errorMessage)

      setInput(Diet::CALORIES, "0")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading
      #!30.times{ break if (@error.isErrorSummaryElementPresent(@formName)); sleep 1 }
      expect(@error.isErrorMessageDisplayed(@formName, errorMessage)).to eq(false)

      setInput(Diet::CALORIES, "")
      setInput(Diet::FAT, "0")
      @entry_form.clickSaveButton()
      !30.times{ break if (@error.isErrorSummaryElementPresent(@formName)); sleep 1 }
      expect(@error.isErrorMessageDisplayed(@formName, errorMessage)).to eq(false)

      setInput(Diet::FAT, "")
      setInput(Diet::CARB, "0")
      @entry_form.clickSaveButton()
      !30.times{ break if (@error.isErrorSummaryElementPresent(@formName)); sleep 1 }
      expect(@error.isErrorMessageDisplayed(@formName, errorMessage)).to eq(false)

      setInput(Diet::CARB, "")
      setInput(Diet::PROTEIN, "0")
      @entry_form.clickSaveButton()
      !30.times{ break if (@error.isErrorSummaryElementPresent(@formName)); sleep 1 }
      expect(@error.isErrorMessageDisplayed(@formName, errorMessage)).to eq(false)

      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
    end

  end

  context "#AC #JRNL-1877|TC #JRNL-1820: Add Diet Entry for Move Diet to the grouped Personal Tracker
  #AC #JRNL-1878|TC #JRNL-1820: Diet entries in detail view
  #AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
  #AC#JRNL-380|TC#JRNL-489
  #AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744
  #AC#JRNL-791|TC#JRNL-812
  #AC#JRNL-380|TC#JRNL-489: User can add a meal entry; Boundary Test for Calories/Fat/Carbs/Protein; Error message presentation and Required fields testing on Date and Time; Verify the max allowed character for Narrative; Display user entered data" do

    it ".Boundary Test for Calories/Fat/Carbs/Protein
        .Error message presentation and Required fields testing on Date and Time
        .Verify the max allowed character for Narrative
        .Modify add/edit screen as follows (based on FDA nutritional labeling guidelines)
        .Meal Type: Add 'Select' as the default option, and make Meal required", :broken => true do
      fieldLabelTests(@fields)
      fieldRestrictionTests(@fields)
    end

    it ".header 'Add <personal tracker name> Entry'
        .User can add a meal entry
        .Display user entered data", :broken => true do
      addTest(@fields, @addDataSet)

      unsavedWarningModalTests()
    end

    it ".header 'Edit <personal tracker name> Entry'
        .User can edit a entries
        .Selecting a diet entry from the table opens the diet record in the detail view.", :broken => true do
      @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
    end

  end

  context "#AC #JRNL-1882|TC #JRNL-1820: Filter Feature for Move Diet to the grouped Personal Tracker
  #AC #JRNL-1881|TC #JRNL-1820: Date Range for Move Diet to the grouped Personal Tracker
  #AC #JRNL-1880|TC #JRNL-1820: Filter Button for Move Diet to the grouped Personal Tracker
  #TC#JRNL-489|AC#JRNL-788|TC#JRNL-812: Verify Screen Headers; Display default message" do


    it ".header '<personal tracker name>'
        .When the user selects Diet from the Personal Trackers list, the system displays the Diet Filter fields and Diet entry summary table in the Detail screen (header: Diet)
        .Verify Screen Headers", :broken => true do
      navigationTests()
    end

    it ".Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded
        .Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads Expand Filter options
        .Date Range (default to last 30 days)
        .Date Range field is shown with Start Date and End date as required fields. Text at the top of the screen (* required field) is shown
        .Date range field are date picker controls and formatted as MM/DD/YYYY; light gray guidance text indicating the format is shown when the field is null", :broken => true do
      refreshBrowser()

      !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

      expect(@date_filter.isDefaultDateRange()).to eq(true)

      filterLabelsAndPlaceholdersTest()
    end

    # it ".Start date must be before or equal to end date, otherwise an error message is shown when the Filter button is selected. The error message is located in the standard location, at the top of the detail screen."
    #   Tested in Guidance_Text_JRNL_620_spec.rb
    # end

    it ".Changing the date range and selecting Filter button updates the table view
        .If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view.
        .When the filter button is selected the focus moves to the first list item in the returned list, or the No results found message.", :broken => true do
      filterTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Meal")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
      expect(getCount()).to eq(3)

      # DEFAULT
      expect(@date_filter.isDefaultDateRange()).to eq(true)
    end

  end

  context "AC#JRNL-381|TC#JRNL-489: Entries will be sorted in reverse chronological order
  AC #JRNL-1879|TC #JRNL-1820: Diet entries in a table format
  AC #JRNL-1342|TC JRNL-1384: Change Date Column Label to Date Entered" do

    it ".Diet entries are displayed in a table format", :broken => true do
      tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
    end

    it ".sorted in reverse chronological order using date and time values", :broken => true  do
      sortTest(@crossBlockSharing["expectedRowStrings"])
    end

  end

  context "AC#JRNL-380|TC#JRNL-489: The user will be able to remove(delete) meal entries" do
    it ".The user will be able to remove(delete) meal entries", :broken => true do
      deleteTest()
    end
  end

end


