require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1421: Personal Trackers - Diet - Graphs]", :regression => true  do

  ## Must declare globally due to the 'each' loop declaration below
  dietGraphTitleSpecifier = ["Calories Intake", "Nutrients Consumed"]

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("diet", "healthfactordb", "diet")
    initializeAllObjects

    @graphInfo = [
        {
            "xAxisLabel" => "Date",
            "yAxisLabel" => "Calories (kCal)"
        },
        {
            "xAxisLabel" => "Date",
            "yAxisLabel" => "Grams (g)"
        }
    ]

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
    waitForPageToFinishLoading
    @nav_menu.click(:css, Nav_menu::NAV["Diet"]["navButton"])
    waitForPageToFinishLoading()
    sleep 1
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1355|TC JRNL-1323: Graph Button and Features" do


      ########################################################################################################################
      ########################################################################################################################
      ############################# GRAPH BUTTON FOR PERSONAL TRACKERS DIET SECTION IS MISSING ON THE APP BELOW CODE #########
      ########################################################################################################################
      ########################################################################################################################

    xit "Button Visibility", :broken => true do
      expect(is_element_present(:css, graphButton())).to eq(true)
    end

    xit "Button Text", :broken => true do
        expect(getTextForElement(:css, graphButton())).to eq("Graph")
    end

    xit "Button Alt Text", :broken => true do
        expect(getElement(:css, graphButton()).attribute("title")).to eq("Graph")
    end

      ########################################################################################################################
      ########################################################################################################################
      ############################# GRAPH BUTTON FOR PERSONAL TRACKERS DIET SECTION IS MISSING ON THE APP ABOVE CODE #########
      ########################################################################################################################
      ########################################################################################################################

    it "Toggle" do
      from = "01/10/2014"
      to = "01/10/2015"

      @date_filter.setDateRangeAndFilter(from, to)
      waitForPageToFinishLoading()

      click(:css, graphButton())
    end

      ########################################################################################################################
      ########################################################################################################################
      ############################# TABLE BUTTON FOR PERSONAL TRACKERS DIET SECTION IS MISSING ON THE APP BELOW CODE #########
      ########################################################################################################################
      ########################################################################################################################

    xit "Button Visibility", :broken => true do
      expect(is_element_present(:css, tableButton())).to eq(true)
    end

    xit "Button Text", :broken => true do
      expect(getTextForElement(:css, tableButton())).to eq("Table")
    end

    xit "Button Alt Text", :broken => true do
      expect(getElement(:css, tableButton()).attribute("title")).to eq("Table")
    end

      ########################################################################################################################
      ########################################################################################################################
      ############################# TABLE BUTTON FOR PERSONAL TRACKERS DIET SECTION IS MISSING ON THE APP ABOVECODE ##########
      ########################################################################################################################
      ########################################################################################################################

    it "Informational Text", :broken => true do
      expect(getTextForElement(:css, viewTableMessage())).to eq("A text description of the information on this page is available in the table view.")
    end

  end

  describe "AC JRNL-1354|AC JRNL-1353|TC JRNL-1323: Graphs" do
    ## Having this loop inside the describe with 'it' blocks inside of it will allow the test to keep running if one block fails.
    dietGraphTitleSpecifier.each_with_index do |specifier, i|

      it "Graph Visibility", :broken => true do
        waitForPageToFinishLoading
        expect(isElementPresentAndVisible(:css, graphContainer(i+1))).to eq(true)
      end

      it "Graph Title", :broken => true do
        expect(getGraphTitle(i+1)).to eq("#{specifier} from 01/10/2014 to 01/10/2015")
      end

      it "X-Axis Label" do
        xAxisLabels = getXAxisLabels(i+1)

        for j in 0...xAxisLabels.length
          expect(xAxisLabels[j]).to eq(@graphInfo[i]["xAxisLabel"])
        end
      end

      it "Y-Axis Label" do
        yAxisLabels = getYAxisLabels(i+1)

        for j in 0...yAxisLabels.length
          expect(yAxisLabels[j]).to eq(@graphInfo[i]["yAxisLabel"])
        end
      end

      it "Y-Axis Ticks", :broken => true do
        yTicks = getYAxisTicks(i+1)
        ## Don't need to verify every y axis tick since they are determined by Highcharts.
        ## Just verify that the first and last are consistent with what the AC states.
        expect(yTicks[0]).to eq("0")
        ## Max should be at least 10% more than the highest y value
        if i == 0 ## Calories Graph
          expect(yTicks[yTicks.length - 1].to_i >= 907).to eq(true)
        else ## Nutrients Graph
          expect(yTicks[yTicks.length - 1].to_i >= 330).to eq(true)
        end
      end

      it "X-Axis Ticks", :broken => true do
        xTicks = getXAxisTicks(i+1)
        ## Don't need to verify every x axis tick since they will change with the filter dates.
        ## Just verify that the first and last are consistent with the filter start and end date

        ## WARNING!! THIS EXPECT MAY FAIL LOCALLY BUT SHOULD PASS ON CI
        ## Workaround is to see if "MBP" is in the hostname (which stands for
        ## "MacBook Pro"). If so, then likely running locally.
        if `hostname`.strip.chomp.include?("MBP")
          #Assume running locally
          expect(xTicks[0]).to eq("Mar 2014")
        else
          #Assume running on CI build server
          expect(xTicks[0]).to eq("Feb 2014")
        end
          expect(xTicks[xTicks.length - 1]).to eq("Jan 2015")
      end

      it "Legend Visibility", :broken => true do
        expect(isLegendDisplayed?(i+1)).to eq(true)
      end

      it "Legend Content", :broken => true do
        legendContent = getLegendContent(i+1)

        if i == 0 ## Calories Graph
          expect(legendContent.include?("Breakfast")).to eq(true)
          expect(legendContent.include?("Lunch")).to eq(true)
          expect(legendContent.include?("Dinner")).to eq(true)
          expect(legendContent.include?("Snack")).to eq(true)
        else ## Nutrients Graph
          expect(legendContent.include?("Carbs")).to eq(true)
          expect(legendContent.include?("Fat")).to eq(true)
          expect(legendContent.include?("Protein")).to eq(true)
        end
      end

      it "Plot Point Count", :broken => true do
        expect(getNumberOfBars(i+1)).to eq(6)
      end

    end

  end

  describe "AC JRNL-1352|TC JRNL-1323: Graph Data Display" do

    it "Change Filter Dates", :broken => true do
      from = "01/02/2015"
      to = "02/01/2015"

      @date_filter.setDateRangeAndFilter(from, to)
      !30.times{ break if(getFocusedElementText() == "A text description of the information on this page is available in the table view."); sleep 1}
      expect(getFocusedElementText()).to eq("A text description of the information on this page is available in the table view.")
    end

    it "First Graph Title", :broken => true do
      expect(getGraphTitle(1)).to eq(dietGraphTitleSpecifier[0] + " from 01/02/2015 to 02/01/2015")
    end

    it "First Graph Row Count", :broken => true do
      expect(getNumberOfBars(1)).to eq(2)
    end

    it "Second Graph Title", :broken => true do
      expect(getGraphTitle(2)).to eq(dietGraphTitleSpecifier[1] + " from 01/02/2015 to 02/01/2015")
    end

    it "Second Graph Row Count", :broken => true do
      expect(getNumberOfBars(2)).to eq(3)
    end

    it "Row Count", :broken => true do
      click(:css, tableButton())
      !30.times{ break if(getCount() == 3); sleep 1 }
      expect(getCount()).to eq(3)
    end

    it "Filter Persists", :broken => true do
      expect(@date_filter.getStartDate()).to eq("01/02/2015")
      expect(@date_filter.getEndDate()).to eq("02/01/2015")
    end
  end
end
