require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-10|JRNL-497|JRNL-751: [Diet_JRNL_10_spec.rb]" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteFromDietTable("D123401")
    initializeAllObjects

    !10.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !10.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !10.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !10.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !10.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers

    #AC#:JRNL-379
    waitForPageToFinishLoading
    expect(@nav_menu.isDietButtonVisible()).to be true
    @nav_menu.clickDiet()

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Meal Detail" IN AUTOMATION ##############################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN APP ############################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN MANUAL TESTSCRIPTS #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # !10.times{ break if (@diet.getPrimaryHeader == "Meal Detail"); sleep 1 }
    # expect(@diet.getPrimaryHeader).to eq("Meal Detail")

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Meal Detail" IN AUTOMATION ##############################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN APP ############################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN MANUAL TESTSCRIPTS #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

  end

  after(:all) do
    quitDriver()
  end

  it "TC#JRNL-489|AC#JRNL-788|TC#JRNL-812: Verify Screen Headers; Display default message" do
    ########################################################################################################################
    ########################################################################################################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Meals" IN AUTOMATION ##################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Personal Trackers" IN APP #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # expect(@diet.getSecondaryHeader()).to eq("Meals")

    ########################################################################################################################
    ########################################################################################################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Meals" IN AUTOMATION ##################################
    ############################# SECONDARY HEADER IS DISPLAYING AS "Personal Trackers" IN APP #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################



    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Meal Detail" IN AUTOMATION ##############################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN APP ############################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER IS DISPLAYING AS "Meal Detail" IN AUTOMATION ##############################
    ############################# PRIMARY HEADER IS DISPLAYING AS "DIET" IN APP ############################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

    ########################################################################################################################
    ########################################################################################################################
    ############################# THE BELOW TEXT DOES NOT APPEAR ON THE APP ################################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################

    #display a message in the detailed pane when no items are seleted
    # !10.times{ break if (@diet.getMessageInEventDetail() == "Select the Add Entry button to add a new entry.\nSelect the button to add a new entry."); sleep 1 }
    # expect(@diet.getMessageInEventDetail()).to eq("Select the Add Entry button to add a new entry.\nSelect the button to add a new entry.")

    ########################################################################################################################
    ########################################################################################################################
    ############################# THE ABOVE TEXT DOES NOT APPEAR ON THE APP ################################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG ABOVE CODE ######################
    ########################################################################################################################
  end

  it "AC#JRNL-380|TC#JRNL-489|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744|AC#JRNL-791|TC#JRNL-812: User can add a meal entry; Boundary Test for Calories/Fat/Carbs/Protein; Error message presentation and Required fields testing on Date and Time; Verify the max allowed character for Narrative; Display a message in the detailed pane when no items are selected", :broken => true do
    waitForPageToFinishLoading
    @diet.clickAddMealBtn()


    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER HEADER IS DISPLAYING AS "Add Diet Entry" IN AUTOMATION ####################
    ############################# PRIMARY HEADER  HEADER IS DISPLAYING AS "Meal Detail" IN APP #############################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################

    # !10.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    # expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    ########################################################################################################################
    ########################################################################################################################
    ############################# PRIMARY HEADER  IS DISPLAYING AS "Add Diet Entry" IN AUTOMATION ##########################
    ############################# PRIMARY HEADER  IS DISPLAYING AS "Meal Detail" IN APP ####################################
    ############################# SHOULD THE AUTOMATION SCRIPT BE UPDATED OR IS THIS A BUG BELOW CODE ######################
    ########################################################################################################################
    waitForPageToFinishLoading
    @diet.clickCancelBtn()

    mealCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    #puts today
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    dinnerTime = "06:00 PM"
    snackTime = "03:00 PM"

    yesterday = @diet.getDateNthDaysAgo(1, "%m/%d/%Y")

    # If section title shows for the primary header below. This bug is related to JRNL 963.
    waitForPageToFinishLoading
    expect(@diet.getPrimaryHeader()).to_not eq("{{sectionTitle}}")

    #type: Breakfast
    enterAndVerifyAMealEntry(yesterday, morningTime, "Breakfast", "300", "10", "50", "14", "Delicious.")

    #type: Lunch
    enterAndVerifyAMealEntry(yesterday, noonTime, "Lunch", "600", "20", "50", "33", "I enjoyed the meal")

    #type Snack
    enterAndVerifyAMealEntry(yesterday, snackTime, "Snack", "150", "7", "30", "9", "Yummy protein bar.")

    #type Dinner
    enterAndVerifyAMealEntry(yesterday, dinnerTime, "Dinner", "800", "24", "55", "37", "I did not feel stuffed after dinner.")

    #validate max 250 characters for Narrative
    @diet.clickAddMealBtn()
    !10.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    expect(@diet.verifyTotalCharacterInNarrative()).to be true

    #Boundary Test
    # boundaryTest("Calories", "Calories must be between 0 and 9999.0.") #function is defined at the bottom of this script
    # boundaryTest("Carbs", "Carbs must be between 0 and 9999.0.")
    # boundaryTest("Fat", "Fat must be between 0 and 9999.0.")
    # boundaryTest("Protein", "Protein must be between 0 and 9999.0.")

    #Required fields test
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Exit out of Add a Meal
    @diet.clickCancelBtn()

    #Can edit an existing meal
    @diet.clickNthMeal(4)
    !10.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    #update the calories to 1000
    @diet.EditAMeal(1000)

    !10.times{ break if (@diet.getNthCaloriesInMealList(4) == "Calories: 1000 kcal" ); sleep 1 }
    #Verify that from the meal entry list, the 4th entry has a new calories reading (1000)
    expect(@diet.getNthCaloriesInMealList(4)).to eq("Calories: 1000 kcal")

  end

  it "AC#JRNL-381|TC#JRNL-489: Entries will be sorted in reverse chronological order ", :broken => true  do
    expect(@diet.getNthTypeInMealList(1)).to eq("Dinner")
    expect(@diet.getNthTypeInMealList(2)).to eq("Snack")
    expect(@diet.getNthTypeInMealList(3)).to eq("Lunch")
    expect(@diet.getNthTypeInMealList(4)).to eq("Breakfast")

  end

  it "AC#JRNL-380|TC#JRNL-489: The user will be able to remove(delete) meal entries", :broken => true do
    deleteNthMeal("Dinner")
    deleteNthMeal("Lunch")
    deleteNthMeal("Breakfast")
    deleteNthMeal("Snack")
  end

  it "AC#JRNL-381|TC#JRNL-489: Display user entered data", :broken => true do
    #Default display to last 30 days displaying start and end date
    #Allow user to change date range(date picker will be in another story)
    #@main.clickNavMenu()
    #@nav_menu.clickDiet()
    !10.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    #Verify that by default, the date range is set to last 30 days
    expect(@diet.verifyDefautDateRangeIs30DaysBack()).to be true

    #Set the date range to 2 years back so all the entered meals will show up
    toDate = @diet.getDateNthDaysAgo(0, "%m/%d/%Y")  #set it to Today
    fromDate = @diet.getDateNthDaysAgo(730, "%m/%d/%Y") #set it to two year ago

    @diet.setDateRange(fromDate, toDate)

    #Populate the list of the meals again
    mealCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    dinnerTime = "06:00 PM"
    snackTime = "03:00 PM"

    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    sixtyDaysAgo = getDateNthDaysAgo(60, "%m/%d/%Y")

    enterAndVerifyAMealEntry(sixtyDaysAgo, dinnerTime, "Dinner", "800", "24", "55", "37", "Meal delivery plan start - Day 1")
    enterAndVerifyAMealEntry(thirtyDaysAgo, noonTime, "Lunch", "600", "20", "50", "33", "Meal delivery plan start - Day 30")
    enterAndVerifyAMealEntry(tenDaysAgo, morningTime, "Breakfast", "300", "10", "50", "14", "Meal delivery plan start - Day 40")
    enterAndVerifyAMealEntry(twoDaysAgo, snackTime, "Snack", "150", "7", "30", "9", "Meal delivery plan start - Day 48")

    setDateRangeAndValidate(3, 0, "Snack") #to show the twoDaysAgo entry
    setDateRangeAndValidate(11, 3, "Breakfast") #to show the tenDaysAgo entry
    setDateRangeAndValidate(35, 29, "Lunch") #to show the thirtyDaysAgo entry
    setDateRangeAndValidate(65, 58, "Dinner") #to show the sixtyDaysAgo entry


    refreshBrowser()

  end

  #Beginning of local functions definition block
  def boundaryTest(testArea, errMsg)

    case testArea
      when "Calories" then
        @diet.setCalories(100000)
      when "Carbs" then
        @diet.setCarb(100000)
      when "Fat" then
        @diet.setFat(100000)
      when "Protein" then
        @diet.setProtein(100000)
    end

    @diet.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !10.times{ break if (@error.getValidationSummaryHeader("dietForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("dietForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("dietForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Calories" then
        @driver.find_element(:css, "input[name='caloriesInput']").clear
      when "Carbs" then
        @driver.find_element(:css, "input[name='carbInput']").clear
      when "Fat" then
        @driver.find_element(:css, "input[name='fatInput']").clear
      when "Protein" then
        @driver.find_element(:css, "input[name='proteinInput']").clear
    end

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @diet.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !10.times{ break if (@error.getValidationSummaryHeader("dietForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("dietForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("dietForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  def enterAndVerifyAMealEntry(dateStr, timeStr, type, calories, fat, carb, protein, note)
    mealCount = @diet.getTotalMealCount()
    #puts mealCount
    @diet.addAMeal(dateStr, timeStr, type, calories, fat, carb, protein, note)
    !10.times{ break if (@diet.getTotalMealCount() == ( mealCount + 1) ); sleep 1 }
    expect(@diet.getTotalMealCount()).to eq(mealCount + 1)

    rowIndex = @diet.findIndexWithAGivenMealType(type)
    expect(@diet.getNthTypeInMealList(rowIndex)).to eq(type)
    expect(@diet.getNthCaloriesInMealList(rowIndex)).to eq("Calories: " + calories.to_s + " kcal")
    expect(@diet.getNthFatInMealList(rowIndex)).to eq("Fat: " + fat.to_s + " g")
    expect(@diet.getNthCarbInMealList(rowIndex)).to eq("Carbs: " + carb.to_s + " g")
    expect(@diet.getNthProteinInMealList(rowIndex)).to eq("Protein: " + protein.to_s + " g")
    #expect(@diet.getNthDateTimeInMealList(rowIndex)).to eq(dateStr + " " + timeStr)
  end


  def setDateRangeAndValidate(numOfDaysAgoFromDate, numOfDaysAgoToDate, mealTypeStr)
    mealCount = @diet.getTotalMealCount()

    toDate = @diet.getDateNthDaysAgo(numOfDaysAgoToDate, "%m/%d/%Y")  #set it to Today
    fromDate = @diet.getDateNthDaysAgo(numOfDaysAgoFromDate, "%m/%d/%Y")

    @diet.setDateRange(fromDate, toDate)

    expect(@diet.isThisMealDisplayed?(mealTypeStr)).to be true

    expect(@diet.isDateWithinFilteredDateRange?()).to be true

    !10.times{ break if (@diet.getTotalMealCount() == 1); sleep 1 }

  end

  def deleteNthMeal(mealType)
    listIndex = @diet.findIndexWithAGivenMealType(mealType)
    @diet.clickNthMeal(listIndex)
    !10.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    expect(@diet.getPrimaryHeader()).to eq("Meal Detail")

    selectedMealType = @diet.getNthTypeInMealList(listIndex)
    #puts "Selected Meal Type :" + selectedMealType

    @diet.clickDeleteBtn()
    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    !10.times{ break if ( @diet.getNthTypeInMealList(listIndex) == selectedMealType); sleep 1 }
    expect(@diet.getNthTypeInMealList(listIndex)).to eq(selectedMealType)
    sleep 1

    mealCount = @diet.getTotalMealCount()

    @diet.clickDeleteBtn()
    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !10.times{ break if ( @diet.getTotalMealCount() == (mealCount - 1)); sleep 1 }
    expect(@diet.getTotalMealCount()).to eq(mealCount - 1)

    expect(@diet.isThisMealDisplayed?(selectedMealType)).to be false

  end

end