require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1370: Personal Trackers - Daily Events - Transition Front End to Mongo HTS]
          [Story #JRNL-1326: Personal Trackers - Daily Events - Transition PDF to Mongo]", :broken => true, :regression => true do

    before(:all) do
        initializeConfigurations(BASE_URL)
        removeCollection("attachments.chunks", "attachmentsdb")
        removeCollection("attachments.files", "attachmentsdb")
        removeCollection("notes", "medicalhistorydb")

        @baseNav = "DailyEvents"

        @expectedHeaders = {
            "add" => "Add Daily Events Entry",
            "edit" => "Edit Daily Events Entry",
            "summary" => "Daily Events",
            "secondary" => "Personal Trackers",
            "title" => "Personal Trackers"
        }

        @tableHeaders = ["Title", "Date Entered"]

        @addDataSet = [
            {"eventTitle" => "Server Side Development"},
            {"eventTitle" => "Client Side Development"},
            {"eventTitle" => "Automated Testing"}
        ]

        @editDataSet = [
            {"eventTitle" => "Nothing"},
            {"eventTitle" => "Everything"},
            {"eventTitle" => "Something"}
        ]

        @metaData = {
            "baseNav" => @baseNav,
            "orderedColumnsList" => ["eventTitle", "Date Entered"],
            "normalOrderedColumnLabels" => @tableHeaders,
            "phoneOrderedColumnLabels" => @tableHeaders,
            "expectedHeaders" => @expectedHeaders,
            "formName" => "form",
            "pdf" => "edit"
        }

        @IMAGE_LIST = ["spidey.jpg", "imgo.jpeg", "testSat.jpg", "johnS.jpg"]

        @NO_ATTACHMENTS_UPLOADED = [
            "* required field",
            "* Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* Time:",
            "hh:mm AM/PM",
            "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
            "* Title:",
            "50 character maximum",
            "Note:",
            "250 character maximum",
            "250 characters left",
            "Attachments:",
            "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
            "Add",
            "Notification:",
            "Status: Off",
            "",
            "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
            "Save Delete Cancel"
        ]

        @TWO_ATTACHMENTS_UPLOADED = [
            "* required field",
            "* Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* Time:",
            "hh:mm AM/PM",
            "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
            "* Title:",
            "50 character maximum",
            "Note:",
            "250 character maximum",
            "250 characters left",
            "Attachments:",
            "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
            "pinball9mb.jpg Delete",
            "Waterfall.jpg Delete",
            "Add",
            "Notification:",
            "Status: Off",
            "",
            "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
            "Save Delete Cancel"
        ]

        @FOUR_ATTACHMENTS_UPLOADED = [
            "* required field",
            "* Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* Time:",
            "hh:mm AM/PM",
            "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
            "* Title:",
            "50 character maximum",
            "Note:",
            "250 character maximum",
            "250 characters left",
            "Attachments:",
            "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
            "spidey.jpg Delete",
            "imgo.jpeg Delete",
            "testSat.jpg Delete",
            "johnS.jpg Delete",
            "Notification:",
            "Status: Off",
            "",
            "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
            "Save Delete Cancel"
        ]

        initializeAllObjects

        init(@metaData)
        @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    end

    # after (:all) do
    #     quitDriver()
    # end

    context "AC #JRNL-1341| TC #JRNL-1221: Mongo HTS: Add/Edit/Delete Event Tracker Entries/Attachments" do

        it "Daily Events Attachment Fields" do
            waitForPageToFinishLoading
            @main.clickNavMenu()
            waitForPageToFinishLoading
            @driver.find_element(:id, "PersonalTrackers").click
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[class='btn btn-default daily-events']").click
            waitForPageToFinishLoading
            @dailyEvents.clickAddEntryButton
            waitForPageToFinishLoading

            expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
            expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)
            expect(getElement(:css, @attachment.addAttachmentButton).attribute('aria-label')).to eq("Add attachment")

            @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
                expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i].gsub(/Save Delete Cancel/,'Save Cancel'))
            end
            expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)

            @entry_form.clickCancelButton()
            waitForPageToFinishLoading()
        end

        it "Attachment Upload - Focus on added attachment" do
            @personal_trackers.clickAddEntryButton()
            waitForPageToFinishLoading()

            setKeyboardField("eventTitle", "Add Attachmenents Event!")

            expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
            expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

            for i in 0...@IMAGE_LIST.length
                addAttachment("addFile", @IMAGE_LIST[i])
                waitForPageToFinishLoading()
                expect(getFocusedElementText()).to eq(@IMAGE_LIST[i])
                expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
            end
        end

        it "Add button hidden after four uploads" do
            expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(false)
            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()
        end

        it "View Attachment visible" do
            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()
            for i in 0...@IMAGE_LIST.length
                expect(isElementVisible(:css, @attachment.nthViewAttachmentButton(i))).to eq(true)
            end
        end

        it "Attached files listed" do
            @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
                expect(screenRow).to eq(@FOUR_ATTACHMENTS_UPLOADED[i])
            end
            expect(@entry_form.getFormContent().split("\n").length).to eq(@FOUR_ATTACHMENTS_UPLOADED.length)
        end

        it "Delete attachment button" do
            deleteImageButtons = getElements(:css, "button[ng-click='deleteAttachment($index)']")
            deleteImageButtons.each_with_index do | deleteButton, i|
                expect(deleteButton.attribute('aria-label')).to eq("Delete "+@IMAGE_LIST[i])
            end
        end

        it "Delete images any order - Focus on last image in list" do
            deleteOrder = [3,1,2,1] #AKA 3,1,4,2
            deleteOrderLength = deleteOrder.length
            for i in 0...deleteOrderLength
                deleteAttachment(deleteOrder[i])
                waitForPageToFinishLoading()
                if i < deleteOrderLength - 1
                    lastAttachmentPosition = getElements(:css, ".attachments > tbody > tr").length - 1
                    expect(getFocusedElementText()).to eq(getElement(:css, @attachment.nthViewAttachmentButton(lastAttachmentPosition)).text)
                else
                    #If all deleted, focus is on Add (attachment) button
                    expect(getFocusedElementText()).to eq("Add")
                end
            end

            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()

            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()

            @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
                expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i])
            end
            expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)
        end

        it "Error adding non-image" do
            addAttachment("addFile", "Attach_File_Unsupported.xlsx")
            waitForPageToFinishLoading()
            expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(0))).to eq(true)

            @entry_form.clickSaveButton()

            expectedValidationSummaryHeader = "The following errors were found:"
            expectedErrorMessage = "The following files could not be added: " +
                "Attach_File_Unsupported.xlsx. " +
                "Attachments must be image files (jpeg, jpg, png) that are no " +
                "bigger than 10 MB. Please check the file(s) and try again."

            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

            expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
            @entry_form.clickCancelButton()
            waitForPageToFinishLoading()
        end

        it "Error adding image greater than 10 MB" do
            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()

            addAttachment("addFile", "bumblebee-poster-11mb.jpg")
            waitForPageToFinishLoading()
            expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(0))).to eq(true)

            @entry_form.clickSaveButton()

            expectedValidationSummaryHeader = "The following errors were found:"
            expectedErrorMessage = "The following files could not be added: " +
                "bumblebee-poster-11mb.jpg. " +
                "Attachments must be image files (jpeg, jpg, png) that are no " +
                "bigger than 10 MB. Please check the file(s) and try again."

            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

            expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
            @entry_form.clickCancelButton()
            waitForPageToFinishLoading()
        end

        it "Error adding mix of good and bad attachments" do
            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()

            imageList = ["Attach_File_Unsupported.xlsx", "pinball9mb.jpg",
                         "Waterfall.jpg", "bumblebee-poster-11mb.jpg"]

            for i in 0...imageList.length
                addAttachment("addFile", imageList[i])
                waitForPageToFinishLoading()
                expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
            end

            @entry_form.clickSaveButton()

            expectedValidationSummaryHeader = "The following errors were found:"
            expectedErrorMessage = "The following files could not be added: " +
                "Attach_File_Unsupported.xlsx, bumblebee-poster-11mb.jpg. " +
                "Attachments must be image files (jpeg, jpg, png) that are no " +
                "bigger than 10 MB. Please check the file(s) and try again."

            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
            expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
        end


        it "Add image files close to 10 MB" do
            deleteOrder = [1,3] #AKA 1,4
            deleteOrderLength = deleteOrder.length
            for i in 0...deleteOrderLength
                deleteAttachment(deleteOrder[i])
                waitForPageToFinishLoading()
            end

            expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()

            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()

            imageList = ["pinball9mb.jpg", "Waterfall.jpg"]

            for i in 0...imageList.length
                expect(isElementVisible(:css, @attachment.nthViewAttachmentButton(i))).to eq(true)
                expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
            end

            @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
                expect(screenRow).to eq(@TWO_ATTACHMENTS_UPLOADED[i])
            end
            expect(@entry_form.getFormContent().split("\n").length).to eq(@TWO_ATTACHMENTS_UPLOADED.length)
        end

        it "Remove all attachments" do
            deleteOrder = [1,1] #AKA 1,2
            deleteOrderLength = deleteOrder.length
            for i in 0...deleteOrderLength
                deleteAttachment(deleteOrder[i])
                waitForPageToFinishLoading()
            end

            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()

            @personal_trackers.clickNthRow(1)
            waitForPageToFinishLoading()

            expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

            @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
                expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i])
            end
            expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)
        end
    end

    describe "Story JRNL-1326|AC JRNL-1253|TC JRNL-1217: View PDF - Daily Events" do
        it ".View PDF - Daily Events" do
            pdfTest()
        end
    end
end











































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1370: Personal Trackers - Daily Events - Transition Front End to Mongo HTS]
          [Story #JRNL-1326: Personal Trackers - Daily Events - Transition PDF to Mongo]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("attachments.chunks", "attachmentsdb")
    removeCollection("attachments.files", "attachmentsdb")
    removeCollection("notes", "medicalhistorydb")

    @baseNav = "DailyEvents"

    @expectedHeaders = {
      "add" => "Add Daily Events Entry",
      "edit" => "Edit Daily Events Entry",
      "summary" => "Daily Events",
      "secondary" => "Personal Trackers",
      "title" => "Personal Trackers"
    }

    @tableHeaders = ["Title", "Date Entered"]

    @addDataSet = [
      {"eventTitle" => "Server Side Development"},
      {"eventTitle" => "Client Side Development"},
      {"eventTitle" => "Automated Testing"}
    ]

    @editDataSet = [
      {"eventTitle" => "Nothing"},
      {"eventTitle" => "Everything"},
      {"eventTitle" => "Something"}
    ]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["eventTitle", "Date Entered"],
      "normalOrderedColumnLabels" => @tableHeaders,
      "phoneOrderedColumnLabels" => @tableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "pdf" => "edit"
    }

    @IMAGE_LIST = ["spidey.jpg", "imgo.jpeg", "testSat.jpg", "johnS.jpg"]

    @NO_ATTACHMENTS_UPLOADED = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Title:",
        "50 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Attachments:",
        "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
        "Add",
        "Notification:",
        "Status: Off",
        "",
        "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
        "Save Delete Cancel"
    ]

    @TWO_ATTACHMENTS_UPLOADED = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Title:",
        "50 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Attachments:",
        "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
        "pinball9mb.jpg Delete",
        "Waterfall.jpg Delete",
        "Add",
        "Notification:",
        "Status: Off",
        "",
        "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
        "Save Delete Cancel"
    ]

    @FOUR_ATTACHMENTS_UPLOADED = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Title:",
        "50 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Attachments:",
        "Add up to four 10 MB image files (png, jpg, jpeg). Images must be uploaded one at a time.",
        "spidey.jpg Delete",
        "imgo.jpeg Delete",
        "testSat.jpg Delete",
        "johnS.jpg Delete",
        "Notification:",
        "Status: Off",
        "",
        "To edit the Daily Events tracker notification, select the Notification button on the previous screen.",
        "Save Delete Cancel"
    ]

    initializeAllObjects

    init(@metaData)
    @common.fastLoginEndsOnLandingPage("zztest.patient01", "zztest", "patient01", "D123401")
  end

  after (:all) do
    quitDriver()
  end

  context "AC #JRNL-1341| TC #JRNL-1221: Mongo HTS: Add/Edit/Delete Event Tracker Entries/Attachments" do

    it "Daily Events Attachment Fields" do
      @nav_menu.navigate(@baseNav)
      @personal_trackers.clickAddEntryButton()
      waitForPageToFinishLoading()

      expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)
      expect(getElement(:css, @attachment.addAttachmentButton).attribute('aria-label')).to eq("Add attachment")

      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i].gsub(/Save Delete Cancel/,'Save Cancel'))
      end
      expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)

      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
    end

    it "Attachment Upload - Focus on added attachment" do
      @personal_trackers.clickAddEntryButton()
      waitForPageToFinishLoading()

      setKeyboardField("eventTitle", "Add Attachmenents Event!")

      expect(getTextForElement(:css, @attachment.attachmentLabel)).to eq("Attachments:")
      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

      for i in 0...@IMAGE_LIST.length
        addAttachment("addFile", @IMAGE_LIST[i])
        waitForPageToFinishLoading()
        expect(getFocusedElementText()).to eq(@IMAGE_LIST[i])
        expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
      end
    end

    it "Add button hidden after four uploads" do
      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(false)
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
    end

    it "View Attachment visible" do
      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()
      for i in 0...@IMAGE_LIST.length
        expect(isElementVisible(:css, @attachment.nthViewAttachmentButton(i))).to eq(true)
      end
    end

    it "Attached files listed" do
      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@FOUR_ATTACHMENTS_UPLOADED[i])
      end
      expect(@entry_form.getFormContent().split("\n").length).to eq(@FOUR_ATTACHMENTS_UPLOADED.length)
    end

    it "Delete attachment button" do
      deleteImageButtons = getElements(:css, "button[ng-click='deleteAttachment($index)']")
      deleteImageButtons.each_with_index do | deleteButton, i|
        expect(deleteButton.attribute('aria-label')).to eq("Delete "+@IMAGE_LIST[i])
      end
    end

    it "Delete images any order - Focus on last image in list" do
      deleteOrder = [3,1,2,1] #AKA 3,1,4,2
      deleteOrderLength = deleteOrder.length
      for i in 0...deleteOrderLength
        deleteAttachment(deleteOrder[i])
        waitForPageToFinishLoading()
        if i < deleteOrderLength - 1
          lastAttachmentPosition = getElements(:css, ".attachments > tbody > tr").length - 1
          expect(getFocusedElementText()).to eq(getElement(:css, @attachment.nthViewAttachmentButton(lastAttachmentPosition)).text)
        else
          #If all deleted, focus is on Add (attachment) button
          expect(getFocusedElementText()).to eq("Add")
        end
      end

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()

      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i])
      end
      expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)
    end

    it "Error adding non-image" do
      addAttachment("addFile", "Attach_File_Unsupported.xlsx")
      waitForPageToFinishLoading()
      expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(0))).to eq(true)

      @entry_form.clickSaveButton()

      expectedValidationSummaryHeader = "The following errors were found:"
      expectedErrorMessage = "The following files could not be added: " +
          "Attach_File_Unsupported.xlsx. " +
          "Attachments must be image files (jpeg, jpg, png) that are no " +
          "bigger than 10 MB. Please check the file(s) and try again."

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

      expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
    end

    it "Error adding image greater than 10 MB" do
      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()

      addAttachment("addFile", "bumblebee-poster-11mb.jpg")
      waitForPageToFinishLoading()
      expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(0))).to eq(true)

      @entry_form.clickSaveButton()

      expectedValidationSummaryHeader = "The following errors were found:"
      expectedErrorMessage = "The following files could not be added: " +
          "bumblebee-poster-11mb.jpg. " +
          "Attachments must be image files (jpeg, jpg, png) that are no " +
          "bigger than 10 MB. Please check the file(s) and try again."

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

      expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
    end

    it "Error adding mix of good and bad attachments" do
      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()

      imageList = ["Attach_File_Unsupported.xlsx", "pinball9mb.jpg",
                   "Waterfall.jpg", "bumblebee-poster-11mb.jpg"]

      for i in 0...imageList.length
        addAttachment("addFile", imageList[i])
        waitForPageToFinishLoading()
        expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
      end

      @entry_form.clickSaveButton()

      expectedValidationSummaryHeader = "The following errors were found:"
      expectedErrorMessage = "The following files could not be added: " +
          "Attach_File_Unsupported.xlsx, bumblebee-poster-11mb.jpg. " +
          "Attachments must be image files (jpeg, jpg, png) that are no " +
          "bigger than 10 MB. Please check the file(s) and try again."

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", expectedErrorMessage)).to eq(true)
    end


    it "Add image files close to 10 MB" do
      deleteOrder = [1,3] #AKA 1,4
      deleteOrderLength = deleteOrder.length
      for i in 0...deleteOrderLength
        deleteAttachment(deleteOrder[i])
        waitForPageToFinishLoading()
      end

      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()

      imageList = ["pinball9mb.jpg", "Waterfall.jpg"]

      for i in 0...imageList.length
        expect(isElementVisible(:css, @attachment.nthViewAttachmentButton(i))).to eq(true)
        expect(isElementVisible(:css, @attachment.nthDeleteAttachmentButton(i))).to eq(true)
      end

      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@TWO_ATTACHMENTS_UPLOADED[i])
      end
      expect(@entry_form.getFormContent().split("\n").length).to eq(@TWO_ATTACHMENTS_UPLOADED.length)
    end

    it "Remove all attachments" do
      deleteOrder = [1,1] #AKA 1,2
      deleteOrderLength = deleteOrder.length
      for i in 0...deleteOrderLength
        deleteAttachment(deleteOrder[i])
        waitForPageToFinishLoading()
      end

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      @personal_trackers.clickNthRow(1)
      waitForPageToFinishLoading()

      expect(isElementVisible(:css, @attachment.addAttachmentButton)).to eq(true)

      @entry_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@NO_ATTACHMENTS_UPLOADED[i])
      end
      expect(@entry_form.getFormContent().split("\n").length).to eq(@NO_ATTACHMENTS_UPLOADED.length)
    end

  end

  describe "Story JRNL-1326|AC JRNL-1253|TC JRNL-1217: View PDF - Daily Events" do

    it ".View PDF - Daily Events" do
      pdfTest()
    end

  end

end
=end