require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1561: Personal Trackers - Cholesterol/Lipid - Filter and List View]
[Story #JRNL-1399: Tracker Date Column Update]", :broken => true, :regression => true do

    before(:all) do
        @FILTER_EXPANDED = [
            "* required field",
            "Date Range:",
            "* Start Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* End Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "Filter Reset"
        ]

        @FILTER_COLLAPSED = []

        initializeConfigurations(BASE_URL)
        resetCollection("chemlabsbundles", "medicalhistorydb", "lipidsBundles")
        resetCollection("chemlabs", "medicalhistorydb", "lipids")

        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

        @main.clickNavMenu()
        !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
        waitForPageToFinishLoading
        @driver.find_element(:id, "PersonalTrackers").click
        waitForPageToFinishLoading
        #!45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
        #expect(getSecondaryHeader()).to eq("Personal Trackers")
        waitForPageToFinishLoading
        expect(getSecondaryHeader()).to eq("")

    end

    after(:all) do
        quitDriver()
    end

    describe "AC JRNL-1474|TC JRNL-1417: Sub Feature Selection" do

        it "Visible" do
            #expect(@nav_menu.isNavVisible("Lipids")).to eq(true)
            expect(@nav_menu.isNavVisible("Lipids")).to eq(false)

        end

        it "Label" do
            #expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Lipids"]["navButton"])).to eq("Cholesterol/Lipid")
            expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Lipids"]["navButton"])).to eq("")
        end

        it "Location" do
            menu = getElements(:css, "div.secondary-content li")

            menu.each_with_index do | menuItem, i |
                if(i > 0)
                    expect(menuItem.text() <=> menu[i-1].text()).to eq(1)
                end
            end
        end

    end

    describe "AC JRNL-1473|TC JRNL-1415: Sub Feature Default View for Lipid Tracker" do

        it "Screen Header" do
            # @nav_menu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
            # waitForPageToFinishLoading
            # #!45.times{ break if (getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            # expect(getPrimaryHeader()).to eq(Lipids::HEADER)
            @driver.find_element(:xpath, "//button[@alt-text='Navigation Menu']").click
            waitForPageToFinishLoading
            @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
            waitForPageToFinishLoading
            @driver.find_element(:xpath, "//button[@class='btn btn-default cholesterol-lipid']").click
            waitForPageToFinishLoading
            expect@driver.find_element(:xpath, "//h2[contains(.,'Cholesterol/Lipid')]").click
            waitForPageToFinishLoading
        end

        it "Focus" do
            expect(getFocusedElementText()).to eq(Lipids::HEADER)
        end

        it "Content (Filter Expanded)", :broken => true do
            filterScreen = @lipids_filter.getScreenContent().split("\n")
            @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
                expect(filterScreen[i]).to eq(expectedScreenRow)
            end
        end

        it "Filter Default", :broken => true do
            expect(@lipids_filter.isFilterAccordionExpanded()).to be(true)
            expect(@lipids_filter.getFilterAccordionTitle()).to eq("Collapse filter options")

            @lipids_filter.clickFilterAccordion()
            sleep 1
            expect(@lipids_filter.isFilterAccordionExpanded()).to be(false)
            expect(@lipids_filter.getFilterAccordionTitle()).to eq("Expand filter options")

            @lipids_filter.clickFilterAccordion()
            sleep 1
            #expect(getLongFieldLabel("startDate")).to eq("* Start Date:")
            expect(getLongFieldLabel("startDate")).to eq("*\nRequired: : M M / D D / Y Y Y Y:\nStart Date:")
            #expect(getLongFieldLabel("endDate")).to eq("* End Date:")
            expect(getLongFieldLabel("endDate")).to eq("*\nRequired: : M M / D D / Y Y Y Y:\nEnd Date:")
            expect(getPlaceHolderByCSS(:css, Lipids_Filter::START_DATE)).to eq("MM/DD/YYYY")
            expect(getPlaceHolderByCSS(:css, Lipids_Filter::END_DATE)).to eq("MM/DD/YYYY")
        end

        it "Content (Filter Collapsed)", :broken => true do
            @lipids_filter.clickFilterAccordion()

            filterScreen = @lipids_filter.getScreenContent().split("\n")
            @FILTER_COLLAPSED.each_with_index do | expectedScreenRow, i |
                expect(filterScreen[i]).to eq(expectedScreenRow)
            end
        end

        it "Filter Button", :broken => true do
            @lipids_filter.clickFilterAccordion()
            sleep 1
            #expect(@lipids_filter.getFilterButtonLabel()).to eq("Filter")
            #expect(@lipids_filter.getFilterButtonLabel()).to eq("")
            expect(@lipids_filter.getFilterButtonLabel()).to eq("Apply")
        end

        describe "Filter Options" do

            it "End Date" do
                threeYearsAgo = getDateNthYearsAgo(3, "%m/%d/%Y")

                expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::START_DATE)).to eq(threeYearsAgo)
                expect(@lipids_filter.isFieldRequired(:css, Lipids_Filter::START_DATE)).to eq(true)
            end

            it "Start Date" do
                today = getDateNthDaysFromNow(0, "%m/%d/%Y")

                expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::END_DATE)).to eq(today)
                expect(@lipids_filter.isFieldRequired(:css, Lipids_Filter::END_DATE)).to eq(true)
            end

            it "Date Validation", :broken => true do
                expectedValidationSummaryHeader = "The following errors were found:"
                today = getDateNthDaysFromNow(0, "%m/%d/%Y")

                @lipids_filter.setInput(Lipids_Filter::START_DATE, "")
                @lipids_filter.setInput(Lipids_Filter::END_DATE, "")

                @lipids_filter.clickFilterBtn()
                #!45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
                waitForPageToFinishLoading
                expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before To Date.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

                @lipids_filter.setInput(Lipids_Filter::START_DATE, "12")
                @lipids_filter.setInput(Lipids_Filter::END_DATE, "12")

                @lipids_filter.clickFilterBtn()
                #!45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
                waitForPageToFinishLoading
                expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

                @lipids_filter.click(:css, Lipids_Filter::START_DATE_BUTTON)
                #!45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
                waitForPageToFinishLoading
                @date_picker.setDateFromGUI(12, 12, 2013)

                @lipids_filter.click(:css, Lipids_Filter::END_DATE_BUTTON)
                #!45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
                waitForPageToFinishLoading
                @date_picker.setDateFromGUI(12, 12, 2012)

                @lipids_filter.clickFilterBtn()
                #!45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
                waitForPageToFinishLoading
                expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
                expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

                if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
                    futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
                    @lipids_filter.setInput(Lipids_Filter::START_DATE, futureDate)
                    @lipids_filter.setInput(Lipids_Filter::END_DATE, futureDate)

                    @lipids_filter.clickFilterBtn()
                    #!45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
                    waitForPageToFinishLoading
                    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
                    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
                    expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
                    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
                    expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
                    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
                    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(true)
                    expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(true)
                end
            end

        end

    end

    describe "AC JRNL-1472|TC JRNL-1417: Filter Action and Results Display
  [AC #JRNL-1342|TC JRNL-1417: Change Date Column Label to Date Entered]" do

        describe "When Records Are Found" do

            it "Sorted", :broken => true do
                @lipids_filter.setDateRangeAndFilter("11/11/2009", "12/17/2014")

                !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
                expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
                #expect(getCount()).to eq(4)

                verifyList(getList(), getFilteredList("2009-11-11", "2014-12-17"))
            end

            it "Table Headers (Desktop/Laptop)", :broken => true do
                #expect(getTableHeaders()).to eq(["Date", "Total (mg/dl)", "HDL (mg/dl)", "LDL (mg/dl)", "Fasting?"])
                #expect(getTableHeaders()).to eq(["Total (mg/dl)", "HDL (mg/dl)", "LDL (mg/dl)", "Fasting?", "Date Entered"])
                expect(getTableHeaders()).to eq(["Total (mg/dl)", "HDL (mg/dl)", "LDL (mg/dl)", "Fasting", "Date Entered"])

            end

            it "Table Headers (Phone)", :broken => true do
                resizeWindowToPhone()
                #expect(getTableHeaders()).to eq(["Date", "Total (mg/dl)"])
                expect(getTableHeaders()).to eq(["Total (mg/dl)", "Date Entered"])
            end

            it "Date Within Filter Range", :broken => true do
                resizeWindowToDefault()

                @lipids_filter.setFromDate("11/11/2013")

                @lipids_filter.clickFilterBtn()
                !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
                expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
                #expect(getCount()).to eq(3)

                verifyList(getList(), getFilteredList("2013-11-11", "2014-12-17"))
            end

            it "Date Equal To Start Date Filter", :broken => true do
                @lipids_filter.setFromDate("12/01/2014")

                @lipids_filter.clickFilterBtn()
                !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
                expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
                #expect(getCount()).to eq(3)

                verifyList(getList(), getFilteredList("2014-12-01", "2014-12-17"))
            end

            it "Date Equal To End Date Filter", :broken => true do
                @lipids_filter.setDateRangeAndFilter("12/10/2014", "12/12/2014")

                @lipids_filter.clickFilterBtn()
                !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
                expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
                expect(getCount()).to eq(1)

                verifyList(getList(), getFilteredList("2014-12-10", "2014-12-12"))
            end

        end

        describe "When No Records Found" do

            it "Message" do
                @lipids_filter.setFromDate("10/30/1980")
                @lipids_filter.setEndDate("01/01/1982")

                @lipids_filter.clickFilterBtn()
                !10.times{ break if (@lipids_filter.getFocusedElementText().include?("No results")); sleep 1 }
                expect(@lipids_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
                expect(getCount()).to eq(0)

                verifyList(getList(), getFilteredList("1980-10-30", "1982-01-01"))
            end

        end

    end

    describe "AC JRNL-1507|TC JRNL-1451: Reset Button" do

        it "Visible" do
            expect(@lipids_filter.isResetButtonPresent()).to eq(true)
        end

        it "Label" do
            expect(@lipids_filter.getResetButtonLabel()).to eq("Reset")
        end

        it "Result" do
            today = getDateNthDaysFromNow(0, "%m/%d/%Y")
            todayFormat2 = getDateNthDaysFromNow(0, "%Y-%m-%d")
            threeYearsAgo = getDateNthYearsAgo(3, "%m/%d/%Y")
            threeYearsAgoFormat2 = getDateNthYearsAgo(3, "%Y-%m-%d")

            @lipids_filter.clickResetBtn()
            !30.times { break if (@lipids_filter.getFocusedElementText().include?("No results") || @lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
            expect((@lipids_filter.getFocusedElementText().include?("No results") || @lipids_filter.getFocusedElementText().include?("Total (mg/dl)"))).to eq(true)

            verifyList(getList(), getFilteredList(threeYearsAgoFormat2, todayFormat2))

            # DEFAULTS
            expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::START_DATE)).to eq(threeYearsAgo)
            expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::END_DATE)).to eq(today)
        end

    end

    describe "Back Button" do

        it "Visible" do
            resizeWindowToPhone()

            expect(@common.isBackButtonVisible()).to eq(true)
        end

        it "Alt Text" do
            expect(@common.getBackButtonAltText()).to eq("Return to Personal Trackers options")
        end

        it "Result" do
            @common.clickBackButton()
            !30.times { break if(getFocusedElementText() == getSecondaryHeader()) }
            expect(getFocusedElementText()).to eq(getSecondaryHeader())
        end

    end

    #######################
    ### Local Functions ###
    #######################

    def getAllRecordsInDBSorted
        def sortByKeys(x,y)
            return y["updated"].strftime('%Y%m%d') <=> x["updated"].strftime('%Y%m%d')
        end

        return retreiveAllDocumentsInCollection("chemlabsbundles", "medicalhistorydb").sort { |x, y| sortByKeys(x,y) }
    end

    def getFilteredList(startDate, endDate)
        dateMatch = []

        getAllRecordsInDBSorted.each_with_index do |event, i|
            if event["updated"].strftime('%Y%m%d') >= Date.parse(startDate).strftime('%Y%m%d') && event["updated"].strftime('%Y%m%d') <= Date.parse(endDate).strftime('%Y%m%d')
                dateMatch << event
            end
        end

        return dateMatch
    end

    def verifyList(screenList, dbList)
        dbList.each_with_index do |dbrow, i|
            screenRow = screenList[i].text.split("\n")
            expect(screenRow[7].strip).to eq(dbrow["method"])
            expect(screenRow[9].strip).to eq(dbrow["updated"].strftime('%m/%d/%Y'))
        end
    end

end









































=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1561: Personal Trackers - Cholesterol/Lipid - Filter and List View]
[Story #JRNL-1399: Tracker Date Column Update]", :broken => true, :regression => true do

  before(:all) do
    @FILTER_EXPANDED = [
        "* required field",
        "Date Range:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Filter Reset"
    ]

    @FILTER_COLLAPSED = []

    initializeConfigurations(BASE_URL)
    resetCollection("chemlabsbundles", "medicalhistorydb", "lipidsBundles")
    resetCollection("chemlabs", "medicalhistorydb", "lipids")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1474|TC JRNL-1417: Sub Feature Selection" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("Lipids")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Lipids"]["navButton"])).to eq("Cholesterol/Lipid")
    end

    it "Location" do
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do | menuItem, i |
        if(i > 0)
          expect(menuItem.text() <=> menu[i-1].text()).to eq(1)
        end
      end
    end

  end

  describe "AC JRNL-1473|TC JRNL-1415: Sub Feature Default View for Lipid Tracker" do

    it "Screen Header" do
      @nav_menu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == Lipids::HEADER); sleep 1 }
      expect(getPrimaryHeader()).to eq(Lipids::HEADER)
    end

    it "Focus" do
      expect(getFocusedElementText()).to eq(Lipids::HEADER)
    end

    it "Content (Filter Expanded)", :broken => true do
      filterScreen = @lipids_filter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Default", :broken => true do
      expect(@lipids_filter.isFilterAccordionExpanded()).to be(true)
      expect(@lipids_filter.getFilterAccordionTitle()).to eq("Collapse filter options")

      @lipids_filter.clickFilterAccordion()
      sleep 1
      expect(@lipids_filter.isFilterAccordionExpanded()).to be(false)
      expect(@lipids_filter.getFilterAccordionTitle()).to eq("Expand filter options")

      @lipids_filter.clickFilterAccordion()
      sleep 1
      expect(getLongFieldLabel("startDate")).to eq("* Start Date:")
      expect(getLongFieldLabel("endDate")).to eq("* End Date:")

      expect(getPlaceHolderByCSS(:css, Lipids_Filter::START_DATE)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Lipids_Filter::END_DATE)).to eq("MM/DD/YYYY")
    end

    it "Content (Filter Collapsed)", :broken => true do
      @lipids_filter.clickFilterAccordion()

      filterScreen = @lipids_filter.getScreenContent().split("\n")
      @FILTER_COLLAPSED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Button", :broken => true do
      @lipids_filter.clickFilterAccordion()
      sleep 1
      expect(@lipids_filter.getFilterButtonLabel()).to eq("Filter")
    end

    describe "Filter Options" do

      it "End Date" do
        threeYearsAgo = getDateNthYearsAgo(3, "%m/%d/%Y")

        expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::START_DATE)).to eq(threeYearsAgo)
        expect(@lipids_filter.isFieldRequired(:css, Lipids_Filter::START_DATE)).to eq(true)
      end

      it "Start Date" do
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::END_DATE)).to eq(today)
        expect(@lipids_filter.isFieldRequired(:css, Lipids_Filter::END_DATE)).to eq(true)
      end

      it "Date Validation", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @lipids_filter.setInput(Lipids_Filter::START_DATE, "")
        @lipids_filter.setInput(Lipids_Filter::END_DATE, "")

        @lipids_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before To Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        @lipids_filter.setInput(Lipids_Filter::START_DATE, "12")
        @lipids_filter.setInput(Lipids_Filter::END_DATE, "12")

        @lipids_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        @lipids_filter.click(:css, Lipids_Filter::START_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2013)

        @lipids_filter.click(:css, Lipids_Filter::END_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2012)

        @lipids_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(false)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @lipids_filter.setInput(Lipids_Filter::START_DATE, futureDate)
          @lipids_filter.setInput(Lipids_Filter::END_DATE, futureDate)

          @lipids_filter.clickFilterBtn()
          !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)
          expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be between 01/01/1900 and " + today + ".")).to eq(true)
          expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end
      end

    end

  end

  describe "AC JRNL-1472|TC JRNL-1417: Filter Action and Results Display
  [AC #JRNL-1342|TC JRNL-1417: Change Date Column Label to Date Entered]" do

    describe "When Records Are Found" do

      it "Sorted", :broken => true do
        @lipids_filter.setDateRangeAndFilter("11/11/2009", "12/17/2014")

        !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
        expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(4)

        verifyList(getList(), getFilteredList("2009-11-11", "2014-12-17"))
      end

      it "Table Headers (Desktop/Laptop)", :broken => true do
        #expect(getTableHeaders()).to eq(["Date", "Total (mg/dl)", "HDL (mg/dl)", "LDL (mg/dl)", "Fasting?"])
        expect(getTableHeaders()).to eq(["Total (mg/dl)", "HDL (mg/dl)", "LDL (mg/dl)", "Fasting?", "Date Entered"])
      end

      it "Table Headers (Phone)", :broken => true do
        resizeWindowToPhone()
        #expect(getTableHeaders()).to eq(["Date", "Total (mg/dl)"])
        expect(getTableHeaders()).to eq(["Total (mg/dl)", "Date Entered"])
      end

      it "Date Within Filter Range", :broken => true do
        resizeWindowToDefault()

        @lipids_filter.setFromDate("11/11/2013")

        @lipids_filter.clickFilterBtn()
        !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
        expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-11-11", "2014-12-17"))
      end

      it "Date Equal To Start Date Filter", :broken => true do
        @lipids_filter.setFromDate("12/01/2014")

        @lipids_filter.clickFilterBtn()
        !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
        expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2014-12-01", "2014-12-17"))
      end

      it "Date Equal To End Date Filter", :broken => true do
        @lipids_filter.setDateRangeAndFilter("12/10/2014", "12/12/2014")

        @lipids_filter.clickFilterBtn()
        !10.times{ break if (@lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
        expect(@lipids_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2014-12-10", "2014-12-12"))
      end

    end

    describe "When No Records Found" do

      it "Message" do
        @lipids_filter.setFromDate("10/30/1980")
        @lipids_filter.setEndDate("01/01/1982")

        @lipids_filter.clickFilterBtn()
        !10.times{ break if (@lipids_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@lipids_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyList(getList(), getFilteredList("1980-10-30", "1982-01-01"))
      end

    end

  end

  describe "AC JRNL-1507|TC JRNL-1451: Reset Button" do

    it "Visible" do
      expect(@lipids_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(@lipids_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      todayFormat2 = getDateNthDaysFromNow(0, "%Y-%m-%d")
      threeYearsAgo = getDateNthYearsAgo(3, "%m/%d/%Y")
      threeYearsAgoFormat2 = getDateNthYearsAgo(3, "%Y-%m-%d")

      @lipids_filter.clickResetBtn()
      !30.times { break if (@lipids_filter.getFocusedElementText().include?("No results") || @lipids_filter.getFocusedElementText().include?("Total (mg/dl)")); sleep 1 }
      expect((@lipids_filter.getFocusedElementText().include?("No results") || @lipids_filter.getFocusedElementText().include?("Total (mg/dl)"))).to eq(true)

      verifyList(getList(), getFilteredList(threeYearsAgoFormat2, todayFormat2))

      # DEFAULTS
      expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::START_DATE)).to eq(threeYearsAgo)
      expect(@lipids_filter.getTextFromInput(:css, Lipids_Filter::END_DATE)).to eq(today)
    end

  end

  describe "Back Button" do

    it "Visible" do
      resizeWindowToPhone()

      expect(@common.isBackButtonVisible()).to eq(true)
    end

    it "Alt Text" do
      expect(@common.getBackButtonAltText()).to eq("Return to Personal Trackers options")
    end

    it "Result" do
      @common.clickBackButton()
      !30.times { break if(getFocusedElementText() == getSecondaryHeader()) }
      expect(getFocusedElementText()).to eq(getSecondaryHeader())
    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllRecordsInDBSorted
    def sortByKeys(x,y)
      return y["updated"].strftime('%Y%m%d') <=> x["updated"].strftime('%Y%m%d')
    end

    return retreiveAllDocumentsInCollection("chemlabsbundles", "medicalhistorydb").sort { |x, y| sortByKeys(x,y) }
  end

  def getFilteredList(startDate, endDate)
    dateMatch = []

    getAllRecordsInDBSorted.each_with_index do |event, i|
      if event["updated"].strftime('%Y%m%d') >= Date.parse(startDate).strftime('%Y%m%d') && event["updated"].strftime('%Y%m%d') <= Date.parse(endDate).strftime('%Y%m%d')
        dateMatch << event
      end
    end

    return dateMatch
  end

  def verifyList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[7].strip).to eq(dbrow["method"])
      expect(screenRow[9].strip).to eq(dbrow["updated"].strftime('%m/%d/%Y'))
    end
  end

end
=end