require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1550: Personal Trackers - Cholesterol/Lipid - Graph]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("chemlabsbundles", "medicalhistorydb", "lipidsBundles")
    resetCollection("chemlabs", "medicalhistorydb", "lipids")

    initializeAllObjects

    @graphInfo = {
        "xAxisLabels" => ["Date"],
        "yAxisLabels" => ["Lipid Level (mg/dl)"]
    }

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    #expect(getSecondaryHeader()).to eq("Personal Trackers")
    expect(getSecondaryHeader()).to eq("")

  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1460|TC JRNL-1404: Graph button for lipid tracker" do

    it "Screen Header", :broken => true do
      # @nav_menu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
      # !45.times{ break if (getPrimaryHeader() == Lipids::HEADER); sleep 1 }
      # expect(getPrimaryHeader()).to eq(Lipids::HEADER)
        @driver.find_element(:xpath, "//button[@alt-text='Navigation Menu']").click
        waitForPageToFinishLoading
        @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
        waitForPageToFinishLoading
        @driver.find_element(:xpath, "//button[@class='btn btn-default cholesterol-lipid']").click
        waitForPageToFinishLoading
        expect@driver.find_element(:xpath, "//h2[contains(.,'Cholesterol/Lipid')]").click
        waitForPageToFinishLoading
    end

    it "Is graph button visible", :broken => true do
      #expect(@lipids_filter.isGraphButtonPresent()).to eq(true)
        @driver.find_element(:xpath, "//button[@id='PersonalTrackers']").click
        waitForPageToFinishLoading
        @driver.find_element(:xpath, "//button[@class='btn btn-default cholesterol-lipid']").click
        waitForPageToFinishLoading
        expect@driver.find_element(:xpath, "//h2[contains(.,'Cholesterol/Lipid')]").click
        waitForPageToFinishLoading
        @driver.find_element(:xpath, "//button[contains(.,'

                Graph
            ')]").click
        waitForPageToFinishLoading
    end

    it "Verify Button Text", :broken => true do
      expect(getTextForElement(:css, @lipids_filter.graphButton())).to eq("Graph")
    end

    it "Verify button alt text", :broken => true do
      expect(@lipids_filter.getGraphButtonTitle()).to eq("Graph")
    end

    it "Verify if clicked, toggles to Table button", :broken => true do
      click(:css, @lipids_filter.graphButton)
      #Graph and Table buttons are same so use calls to graph button to get
      #table button info
      expect(@lipids_filter.isGraphButtonPresent()).to eq(true)
      expect(getTextForElement(:css, @lipids_filter.tableButton())).to eq("Table")
      expect(@lipids_filter.getGraphButtonTitle()).to eq("Table")
    end

    it "Verify Graph Title", :broken => true do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      threeYearsAgo = getDateNthYearsAgo(3, "%m/%d/%Y")
      expect(@lipids_filter.getGraphTitle()).to eq("Lipid Values from #{threeYearsAgo} to #{today}")
    end

    it "Verify text below filter", :broken => true do
      @lipids_filter.setDateRangeAndFilter("11/11/2009", "12/15/2014")
      !10.times{ break if (@lipids_filter.getFocusedElementText().include?("A text description of the information on this page is available in the table view.")); sleep 1 }
      expect(@lipids_filter.getFocusedElementText()).to eq("A text description of the information on this page is available in the table view.")
    end

    it "Verify Graph title", :broken => true do
      expect(@lipids_filter.getGraphTitle()).to eq("Lipid Values from 11/11/2009 to 12/15/2014")
    end

    it "Verify x-axis label", :broken => true do
      xAxisLabels = @lipids_filter.getXAxisLabels()

      numXAxisLabels = @graphInfo["xAxisLabels"].length

      for i in 0...numXAxisLabels
        expect(xAxisLabels[i]).to eq(@graphInfo["xAxisLabels"][i])
      end

    end

    it "Verify y-axis label", :broken => true do
      yAxisLabels = @lipids_filter.getYAxisLabels()

      numYAxisLabels = @graphInfo["yAxisLabels"].length

      for i in 0...numYAxisLabels
        expect(yAxisLabels[i]).to eq(@graphInfo["yAxisLabels"][i])
      end
    end

    it "Verify legend", :broken => true do
      expect(@lipids_filter.isLegendDisplayed?()).to eq(true)
      legendContent = @lipids_filter.getLegendContent()
      expect(legendContent.include? "Total").to eq(true)
      expect(legendContent.include? "LDL").to eq(true)
      expect(legendContent.include? "HDL").to eq(true)
      expect(legendContent.include? "Triglycerides").to eq(true)
      expect(legendContent).to eq("TotalLDLHDLTriglycerides")
    end

  end

  describe "AC JRNL-1459|TC JRNL-1404: Graph data display for Lipid Tracker" do

    it "change date filers and verify x/y axis", :broken => true do
      xAxisValues = @lipids_filter.getXAxisValues()
      yAxisValues = @lipids_filter.getYAxisValues()

      @lipids_filter.setDateRangeAndFilter("11/11/1900", "12/15/2014")

      expect(@lipids_filter.getGraphTitle()).to eq("Lipid Values from 11/11/1900 to 12/15/2014")

      xAxisValuesNew = @lipids_filter.getXAxisValues()
      yAxisValuesNew = @lipids_filter.getYAxisValues()

      for i in 0...xAxisValuesNew.length
        expect(xAxisValuesNew[i]).to_not eq(xAxisValues[i])
      end

      for i in 0...yAxisValuesNew.length
        expect(yAxisValuesNew[i]).to eq(yAxisValues[i])
      end
    end

    it "Verify row count", :broken => true do
      click(:css, @lipids_filter.tableButton)

      expect(getCount()).to eq(4)
    end

    it "Verify filter is the same", :broken => true do
      expect(@lipids_filter.getStartDate()).to eq("11/11/1900")
      expect(@lipids_filter.getEndDate()).to eq("12/15/2014")
    end

  end

end