################# Please Run "PersonalTrackers_Lipids_Add_JRNL_1560_spec." prior to running this script.

require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1060: Personal Trackers - Cholesterol/Lipid - Edit/Delete/Nav]", :broken => true, :regression => true do

    before(:all) do

        @ENTRY_FORM = [
            "* required field",
            "* Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* Lab Results: (provide at least one result to save)",
            "Total Serum Cholesterol (mg/dl):",
            "Between 0 and 600",
            "Low-Density Lipoprotein (LDL) (mg/dl):",
            "Between 0 and 300",
            "High-Density Lipoprotein (HDL) (mg/dl):",
            "Between 0 and 300",
            "Triglycerides (mg/dl):",
            "Between 0 and 600",
            "Test done while fasting?:",
            "Select",
            "Yes",
            "No",
            "Unknown",
            "Note:",
            "250 character maximum",
            "250 characters left",
            "Save Cancel"
        ]

        initializeConfigurations(BASE_URL)
        resetCollection("chemlabsbundles", "medicalhistorydb", "lipidsBundles")
        resetCollection("chemlabs", "medicalhistorydb", "lipids")

        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest");

        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest");

        @main.clickNavMenu()
        !5.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@navMenu.getNavMenuHeading()).to eq("App Options")
        waitForPageToFinishLoading
        @driver.find_element(:id, "PersonalTrackers").click
        waitForPageToFinishLoading
        expect(getSecondaryHeader()).to eq("Personal Trackers")

        @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
        !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
        expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

        @numberOfRecords = 3

        @lipidsFilter.setInput(Lipids_Filter::START_DATE, "01/01/1900")
        @lipidsFilter.clickFilterBtn()
        !5.times{ break if (@lipidsFilter.getFocusedElementText().include?(%(Date))); sleep 1 }

#        @countBeforeDelete = retreiveAllDocumentsInCollection("chemlabsbundles", "medicalhistorydb").length()
    end

    # after(:all) do
    #     quitDriver()
    # end

    describe "AC JRNL-1468|TC JRNL-1411: When Selecting An Entry" do

        it "Header" do
            waitForPageToFinishLoading
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[2]/span[6]").click
            waitForPageToFinishLoading

            !5.times{ break if( @lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1}
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
        end

        it "Previously-Saved Values" do
            expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")
            expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("250")
            expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("100")
            expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("200")
            expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("100")
            @driver.find_element(:css, "select[name='Fasting']").send_keys 'Select'
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
        end

    describe "Entry Page" do

        it "Content" do
            @lipids.getScreenContent().split("\n").each_with_index do | screenRow, i |
                break if (screenRow == "240 characters left" )
            end
            expect(getTextForElement(:xpath, "//span[@class='ng-binding bold-text']")).to eq("Date:")
            waitForPageToFinishLoading
        end

        it "Required" do
            expect(@lipids.isFieldRequired(:css, Lipids::DATE)).to eq(true)
            expect(@lipids.isFieldRequired(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::LDL_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::HDL_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::TRIGLYCERIDES)).to eq(false)
            expect(getTextForElement(:xpath, "//select[@name='Fasting']")).to eq("Select\nYes\nNo\nUnknown")
            expect(@lipids.isFieldRequired(:css, Lipids::NOTE)).to eq(false)
        end

        it "Error Messages" do
            expectedValidationSummaryHeader = "The following errors were found:"
            today = getDateNthDaysFromNow(0, "%m/%d/%Y")

            @lipids.setInput(Lipids::DATE, "")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "Select"
            waitForPageToFinishLoading
            @lipids.clickSaveButton()
            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
            expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)

            @lipids.setInput(Lipids::DATE, "11/01")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "700")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "400")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "400")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "700")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "Yes"
            waitForPageToFinishLoading
            @lipids.clickSaveButton()
            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
            expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)

            if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
                futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
                @lipids.setInput(Lipids::DATE, futureDate)

                @lipids.clickSaveButton()
                !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
            end
        end

        it "Verify error message for duplicate records" do
            expectedValidationSummaryHeader = "The following errors were found:"
            @lipids.setInput(Lipids::DATE, "12/12/2014")
            expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/12/2014")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "10")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "20")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "30")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "40")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "Yes"
            waitForPageToFinishLoading
            @lipids.clickSaveButton()
        end
    end

    describe "AC JRNL-1467|TC JRNL-1411: Standard Functions Available" do

        it "Cancel" do
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

            expect(getCount()).to eq(2)

            #clickNthRow(1)
            waitForPageToFinishLoading
            @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
            waitForPageToFinishLoading

            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

            expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/12/2014")
            expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("10")
            expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("20")
            expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("30")
            expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("40")
            expect(getTextForElement(:xpath, "//select[@name='Fasting']")).to eq("Select\nYes\nNo\nUnknown")
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")

            @lipids.clickCancelButton()
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

            expect(getCount()).to eq(2)
        end

        it "Delete" do
            #clickNthRow(1)
            waitForPageToFinishLoading
            @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
            waitForPageToFinishLoading
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

            expect(@lipids.isDeleteButtonVisible()).to eq(true)

            @lipids.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickNoButton()
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
            !5.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
            expect(@lipids.getFocusedElementText()).to eq("Delete")

            @lipids.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickYesButton()
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
        end
    end

    describe "Save" do

        it "Min" do
            waitForPageToFinishLoading
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[1]/span[6]").click
            waitForPageToFinishLoading
            !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

            @lipids.setInput(Lipids::DATE, "12/03/2014")
            !10.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "0")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "Select"
            waitForPageToFinishLoading
            @lipids.setInput(Lipids::NOTE, "")

            @lipids.clickSaveButton()
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
        end

        it "Verify Saved Data" do
            waitForPageToFinishLoading
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li/span[5]").click
            waitForPageToFinishLoading
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
            expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("")
            expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("0")
            expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("")
            expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "Select"
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
        end

        it "Max" do
            @lipids.setInput(Lipids::DATE, "12/02/2014")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "600")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "300")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "300")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "600")
            @driver.find_element(:xpath, "//select[@name='Fasting']").send_keys "No"
            @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

            @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

            @lipids.clickSaveButton()
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
        end

        it "Verify Saved Data" do
            waitForPageToFinishLoading
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li/span[5]").click
            waitForPageToFinishLoading
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

            expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/02/2014")
            expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("600")
            expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("300")
            expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("300")
            expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("600")
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
        end

    end

    describe "AC JRNL-1465|TC JRNL-1411: Navigation" do

        describe "Clicking Menu" do

            it "No Changes" do
                @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
            end

            it "Changes" do
                waitForPageToFinishLoading
                @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                @lipids.setInput(Lipids::NOTE, "XYZ")

                @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Continue")
                expect(@modal.getCancelButtonText()).to eq("Return")

                @modal.clickReturnButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Continue")
                expect(@modal.getCancelButtonText()).to eq("Return")

                @modal.clickContinueButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                expect(getCount()).to eq(@numberOfRecords - 1)

                waitForPageToFinishLoading
                @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
            end
        end
    end

        describe "Back Button" do

            it "Alt Text" do
                expect(@lipids.getBackButtonAltText()).to eq("Return to Previous Screen")
            end

            it "No Changes" do
                @common.clickBackButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
            end

            it "Changes" do
                waitForPageToFinishLoading
                @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                @lipids.setInput(Lipids::NOTE, "XYZ")

                @lipids.clickBackButton()
                !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Continue")
                expect(@modal.getCancelButtonText()).to eq("Return")

                @modal.clickReturnButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                @lipids.clickBackButton()
                !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Continue")
                expect(@modal.getCancelButtonText()).to eq("Return")

                @modal.clickContinueButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                expect(getCount()).to eq(@numberOfRecords - 1)

                waitForPageToFinishLoading
                @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")

                @lipids.clickCancelButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
            end

        end

     end

end





















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1060: Personal Trackers - Cholesterol/Lipid - Edit/Delete/Nav]", :broken => true, :regression => true do

    before(:all) do

        @ENTRY_FORM = [
            "* required field",
            "* Date:",
            "MM/DD/YYYY",
            "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
            "* Lab Results: (provide at least one result to save)",
            "Total Serum Cholesterol (mg/dl):",
            "Between 0 and 600",
            "Low-Density Lipoprotein (LDL) (mg/dl):",
            "Between 0 and 300",
            "High-Density Lipoprotein (HDL) (mg/dl):",
            "Between 0 and 300",
            "Triglycerides (mg/dl):",
            "Between 0 and 600",
            "Test done while fasting?:",
            "Select",
            "Yes",
            "No",
            "Unknown",
            "Note:",
            "250 character maximum",
            "250 characters left",
            "Save Cancel"
        ]

        initializeConfigurations(BASE_URL)
        resetCollection("chemlabsbundles", "medicalhistorydb", "lipidsBundles")
        resetCollection("chemlabs", "medicalhistorydb", "lipids")

        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

        expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

        @main.clickNavMenu()
        !10.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@navMenu.getNavMenuHeading()).to eq("App Options")

        @navMenu.clickPersonalTrackers()
        !10.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
        expect(getSecondaryHeader()).to eq("Personal Trackers")

        @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
        !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
        expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

        @numberOfRecords = 4

        @lipidsFilter.setInput(Lipids_Filter::START_DATE, "01/01/1900")
        @lipidsFilter.clickFilterBtn()
        !10.times{ break if (@lipidsFilter.getFocusedElementText().include?(%(Date))); sleep 1 }
        expect(@lipidsFilter.getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))

        expect(getCount()).to eq(@numberOfRecords)

        @countBeforeDelete = retreiveAllDocumentsInCollection("chemlabsbundles", "medicalhistorydb").length()
    end

    after(:all) do
        quitDriver()
    end

    describe "AC JRNL-1468|TC JRNL-1411: When Selecting An Entry" do

        it "Header" do
            clickNthRow(1)
            !10.times{ break if( @lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1}
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
        end

        it "Previously-Saved Values" do
            expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/10/2014")
            expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("10")
            expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("20")
            expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("30")
            expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("40")
            expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("Yes")
            expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("Lipid note")
            expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("240 characters left")
        end

        describe "Entry Page" do

            it "Content" do
                @lipids.getScreenContent().split("\n").each_with_index do | screenRow, i |
                    break if (screenRow == "240 characters left" )
                    expect(screenRow).to eq(@ENTRY_FORM[i])
                end
            end

            it "Required" do
                expect(@lipids.isFieldRequired(:css, Lipids::DATE)).to eq(true)
                expect(@lipids.isFieldRequired(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq(false)
                expect(@lipids.isFieldRequired(:css, Lipids::LDL_CHOLESTEROL)).to eq(false)
                expect(@lipids.isFieldRequired(:css, Lipids::HDL_CHOLESTEROL)).to eq(false)
                expect(@lipids.isFieldRequired(:css, Lipids::TRIGLYCERIDES)).to eq(false)
                expect(@lipids.isFieldRequired(:css, Lipids::FASTING)).to eq(false)
                expect(@lipids.isFieldRequired(:css, Lipids::NOTE)).to eq(false)
            end




            it "Error Messages" do
                expectedValidationSummaryHeader = "The following errors were found:"
                today = getDateNthDaysFromNow(0, "%m/%d/%Y")

                @lipids.setInput(Lipids::DATE, "")
                @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
                @lipids.setInput(Lipids::LDL_CHOLESTEROL, "")
                @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
                @lipids.setInput(Lipids::TRIGLYCERIDES, "")
                @lipids.setSelectBoxValue(Lipids::FASTING, "Select")

                @lipids.clickSaveButton()
                !10.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)

                @lipids.setInput(Lipids::DATE, "11/01")
                @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "700")
                @lipids.setInput(Lipids::LDL_CHOLESTEROL, "400")
                @lipids.setInput(Lipids::HDL_CHOLESTEROL, "400")
                @lipids.setInput(Lipids::TRIGLYCERIDES, "700")
                @lipids.setSelectBoxValue(Lipids::FASTING, "Yes")

                @lipids.clickSaveButton()
                !10.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(false)
                expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
                expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)

                if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
                    futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
                    @lipids.setInput(Lipids::DATE, futureDate)

                    @lipids.clickSaveButton()
                    !10.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                    expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                    expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
                end
            end

            it "Verify error message for duplicate records" do
                expectedValidationSummaryHeader = "The following errors were found:"
                @date_picker.click(:css, Lipids::DATE_BUTTON)
                !10.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
                @date_picker.setDateFromGUI(12, 12, 2014)
                sleep 1
                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/12/2014")

                @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "10")
                @lipids.setInput(Lipids::LDL_CHOLESTEROL, "20")
                @lipids.setInput(Lipids::HDL_CHOLESTEROL, "30")
                @lipids.setInput(Lipids::TRIGLYCERIDES, "40")
                @lipids.setSelectBoxValue(Lipids::FASTING, "Yes")

                @lipids.clickSaveButton()
                !10.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("form", "You have already saved Cholesterol/Lipid values for this date. Please change the date or cancel this entry.")).to eq(true)
            end

        end

        describe "AC JRNL-1467|TC JRNL-1411: Standard Functions Available" do

            it "Cancel" do
                expect(@lipids.isCancelButtonVisible()).to eq(true)

                @lipids.clickCancelButton()
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                expect(getCount()).to eq(@numberOfRecords)

                clickNthRow(1)
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/10/2014")
                expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("10")
                expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("20")
                expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("30")
                expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("40")
                expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("Yes")
                expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("Lipid note")
                expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("240 characters left")

                @lipids.clickCancelButton()
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                expect(getCount()).to eq(@numberOfRecords)
            end

            it "Delete" do
                clickNthRow(1)
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                expect(@lipids.isDeleteButtonVisible()).to eq(true)

                @lipids.clickDeleteButton()
                !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Yes")
                expect(@modal.getCancelButtonText()).to eq("No")

                @modal.clickNoButton()
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
                !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
                expect(@lipids.getFocusedElementText()).to eq("Delete")

                @lipids.clickDeleteButton()
                !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
                expect(@modal.getConfirmButtonText()).to eq("Yes")
                expect(@modal.getCancelButtonText()).to eq("No")

                @modal.clickYesButton()
                !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                expect(getCount()).to eq(@numberOfRecords - 1)

                expect(retreiveAllDocumentsInCollection("chemlabsbundles", "medicalhistorydb").length()).to eq(@countBeforeDelete)
            end

            describe "Save" do

                it "Min" do
                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    @lipids.click(:css, Lipids::DATE_BUTTON)
                    !10.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
                    @date_picker.setDateFromGUI(12, 3, 2014)
                    !10.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

                    @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
                    @lipids.setInput(Lipids::LDL_CHOLESTEROL, "0")
                    @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
                    @lipids.setInput(Lipids::TRIGLYCERIDES, "")
                    @lipids.setSelectBoxValue(Lipids::FASTING, "Select")
                    @lipids.setInput(Lipids::NOTE, "")

                    @lipids.clickSaveButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                    expect(getCount()).to eq(@numberOfRecords - 1)
                end

                it "Verify Saved Data" do
                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("")
                    expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("0")
                    expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("")
                    expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("")
                    expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("Select")
                    expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("")
                    expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")

                end

                it "Max" do
                    @lipids.setInput(Lipids::DATE, "12/02/2014")
                    @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "600")
                    @lipids.setInput(Lipids::LDL_CHOLESTEROL, "300")
                    @lipids.setInput(Lipids::HDL_CHOLESTEROL, "300")
                    @lipids.setInput(Lipids::TRIGLYCERIDES, "600")
                    @lipids.setSelectBoxValue(Lipids::FASTING, "No")
                    @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
                    expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

                    @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
                    expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
                    expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

                    @lipids.clickSaveButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                    expect(getCount()).to eq(@numberOfRecords - 1)
                end

                it "Verify Saved Data" do
                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("12/02/2014")
                    expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("600")
                    expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("300")
                    expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("300")
                    expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("600")
                    expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("No")
                    expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
                    expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
                end

            end

        end

        describe "AC JRNL-1465|TC JRNL-1411: Navigation" do

            describe "Clicking Menu" do

                it "No Changes" do
                    @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
                end

                it "Changes" do
                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    @lipids.setInput(Lipids::NOTE, "XYZ")

                    @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                    expect(@modal.getConfirmButtonText()).to eq("Continue")
                    expect(@modal.getCancelButtonText()).to eq("Return")

                    @modal.clickReturnButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
                    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                    expect(@modal.getConfirmButtonText()).to eq("Continue")
                    expect(@modal.getCancelButtonText()).to eq("Return")

                    @modal.clickContinueButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                    expect(getCount()).to eq(@numberOfRecords - 1)

                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
                end

            end

            describe "Back Button" do

                it "Alt Text" do
                    expect(@lipids.getBackButtonAltText()).to eq("Return to Previous Screen")
                end

                it "No Changes" do
                    @common.clickBackButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
                end

                it "Changes" do
                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    @lipids.setInput(Lipids::NOTE, "XYZ")

                    @lipids.clickBackButton()
                    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                    expect(@modal.getConfirmButtonText()).to eq("Continue")
                    expect(@modal.getCancelButtonText()).to eq("Return")

                    @modal.clickReturnButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    @lipids.clickBackButton()
                    !10.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
                    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
                    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
                    expect(@modal.getConfirmButtonText()).to eq("Continue")
                    expect(@modal.getCancelButtonText()).to eq("Return")

                    @modal.clickContinueButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

                    expect(getCount()).to eq(@numberOfRecords - 1)

                    clickNthRow(1)
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

                    expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")

                    @lipids.clickCancelButton()
                    !10.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
                end

            end

        end

    end

end
=end