require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1560: Personal Trackers - Cholesterol/Lipid - Add]", :broken => true, :regression => true do

    before(:all) do
        @ENTRY_FORM = [
         "* required field",
         "*",
         "Required: Date: M M / D D / Y Y Y Y:",
         "Date:",
         "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
         "Day selected is Monday",
         "Monday",
         "* Lab Results: (provide at least one result to save)",
         "Total Serum Cholesterol (mg/dl):",
         "Between 0 and 600",
         "Low-Density Lipoprotein (LDL) (mg/dl):",
         "Between 0 and 300",
         "High-Density Lipoprotein (HDL) (mg/dl):",
         "Between 0 and 300",
         "Triglycerides (mg/dl):",
         "Between 0 and 600",
         "Test done while fasting:",
         "Select",
         "Yes",
         "No",
         "Unknown",
         "Note:",
         "250 character maximum",
         "250 characters left",
         "Save Cancel"
        ]

        initializeConfigurations(BASE_URL)
        removeCollection("chemlabs", "medicalhistorydb")
        removeCollection("chemlabsbundles", "medicalhistorydb")
        initializeAllObjects
        @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest");
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest");

        @main.clickNavMenu()
        !5.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@navMenu.getNavMenuHeading()).to eq("App Options")
        waitForPageToFinishLoading
        @driver.find_element(:id, "PersonalTrackers").click
        waitForPageToFinishLoading
        !5.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
        expect(getSecondaryHeader()).to eq("Personal Trackers")

        @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
        !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
        expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
        @lipidsFilter.setDateRangeAndFilter("01/01/2012", "11/17/2014")
    end

    # after(:all) do
    #     quitDriver()
    # end

    describe "AC JRNL-1469|TC-3819: Add Button" do
        it "Visible" do
            expect(@common.isAddButtonVisible()).to eq(true)
        end

        it "Alt Text" do
            expect(@common.getAddButtonAltText()).to eq("Add")
        end
    end

    describe "AC JRNL-1469|TC-3819: When Selecting Add" do
        it "Header" do
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[ng-click='getDetails()']").click
            waitForPageToFinishLoading
            !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
            expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
        end

    describe "Detailed Fields" do
        it "Content" do
            @lipids.getScreenContent().split("\n").each_with_index do | screenRow, i |
                break if (screenRow == "250 characters left" )
            end
        end

        it "Required" do
            expect(@lipids.isFieldRequired(:css, Lipids::DATE)).to eq(true)
            expect(@lipids.isFieldRequired(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::LDL_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::HDL_CHOLESTEROL)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::TRIGLYCERIDES)).to eq(false)
            #expect(@lipids.isFieldRequired(:css, Lipids::FASTING)).to eq(false)
            expect(@lipids.isFieldRequired(:css, Lipids::NOTE)).to eq(false)
        end

        it "Error Messages" do
            expectedValidationSummaryHeader = "The following errors were found:"
            today = getDateNthDaysFromNow(0, "%m/%d/%Y")

            @lipids.setInput(Lipids::DATE, "")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "")
            @driver.find_element(:css, "select[name='Fasting']").click
            waitForPageToFinishLoading

            @lipids.clickSaveButton()
            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
            expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)

            @lipids.setInput(Lipids::DATE, "11/01")
            @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "700")
            @lipids.setInput(Lipids::LDL_CHOLESTEROL, "400")
            @lipids.setInput(Lipids::HDL_CHOLESTEROL, "400")
            @lipids.setInput(Lipids::TRIGLYCERIDES, "700")
            @driver.find_element(:css, "select[name='Fasting']").send_keys 'Yes'
            waitForPageToFinishLoading
            @lipids.clickSaveButton()

            !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
            expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(false)
            expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)

            if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
                futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
                @lipids.setInput(Lipids::DATE, futureDate)
                @lipids.clickSaveButton()

                !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
                expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
                expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
            end
        end
    end

        describe "AC JRNL-1469|TC-3819: Standard Save and Cancel Options" do
            it "Cancel" do
                expect(@lipids.isCancelButtonVisible()).to eq(true)
                @lipids.clickCancelButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
            end
        end

        describe "Save" do
            it "Min" do
                @common.clickAddButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
                @driver.find_element(:xpath, "//input[@id='date']").clear
                @driver.find_element(:xpath, "//input[@id='date']").send_keys "11/11/2014"
                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")

                @lipids.setInput(Lipids::TRIGLYCERIDES, "0")
                waitForPageToFinishLoading
                @lipids.clickSaveButton()
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getFocusedElementText()).to eq(Lipids::HEADER)
                @driver.find_element(:css, "button[title='Apply Filter']").click
                waitForPageToFinishLoading
            end

            it "Verify Saved Data" do
                waitForPageToFinishLoading
                #click 1st Row
                @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

            end

            it "Max" do
                @lipids.clickCancelButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
                @common.clickAddButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
                @driver.find_element(:css, "input[id='date']").clear
                waitForPageToFinishLoading
                @driver.find_element(:css, "input[id='date']").send_keys "11/13/2014"
                waitForPageToFinishLoading
                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/13/2014")
                @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "600")
                @lipids.setInput(Lipids::LDL_CHOLESTEROL, "300")
                @lipids.setInput(Lipids::HDL_CHOLESTEROL, "300")
                @lipids.setInput(Lipids::TRIGLYCERIDES, "600")
                @driver.find_element(:css, "select[name='Fasting']").send_keys 'No'
                @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
                expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")
                @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
                expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
                expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
                @lipids.clickSaveButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getFocusedElementText()).to eq(Lipids::HEADER)
                waitForPageToFinishLoading
                @lipids.clickApplyButton()
                waitForPageToFinishLoading
            end

            it "Verify Saved Data" do
                waitForPageToFinishLoading
                @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[1]/span[1]").click
                waitForPageToFinishLoading
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)
                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/13/2014")
                expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("600")
                expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("300")
                expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("300")
                expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("600")
                expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
                expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
                expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
                @lipids.clickCancelButton()
            end

            it "Verify error message for duplicate records" do
                expectedValidationSummaryHeader = "The following errors were found:"
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)
                @common.clickAddButton()
                !5.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
                expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
                @driver.find_element(:css, "input[id='date']").clear
                waitForPageToFinishLoading
                @driver.find_element(:css, "input[id='date']").send_keys "11/11/2014"
                waitForPageToFinishLoading
                expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")
                @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "250")
                @lipids.setInput(Lipids::LDL_CHOLESTEROL, "100")
                @lipids.setInput(Lipids::HDL_CHOLESTEROL, "200")
                @lipids.setInput(Lipids::TRIGLYCERIDES, "100")
                @driver.find_element(:css, "select[name='Fasting']").send_keys 'Yes'
                @lipids.clickSaveButton()
                waitForPageToFinishLoading
                @lipids.clickApplyButton()
                waitForPageToFinishLoading

                ##Delete 3rd Entry##
                @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/list-table/div/div/ul/li[3]/span[6]").click
                waitForPageToFinishLoading
                @driver.find_element(:css, "button[ng-click='delete()']").click
                waitForPageToFinishLoading
                @driver.find_element(:css, "button[data-ng-click='modalContent.ok();']").click
                waitForPageToFinishLoading

            end
        end
     end
end






































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin

require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1560: Personal Trackers - Cholesterol/Lipid - Add]", :broken => true, :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Lab Results: (provide at least one result to save)",
        "Total Serum Cholesterol (mg/dl):",
        "Between 0 and 600",
        "Low-Density Lipoprotein (LDL) (mg/dl):",
        "Between 0 and 300",
        "High-Density Lipoprotein (HDL) (mg/dl):",
        "Between 0 and 300",
        "Triglycerides (mg/dl):",
        "Between 0 and 600",
        "Test done while fasting?:",
        "Select",
        "Yes",
        "No",
        "Unknown",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("chemlabs", "medicalhistorydb")
    removeCollection("chemlabsbundles", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !15.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !15.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
    !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
    expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

    expect(getCount()).to eq(0)

    @lipidsFilter.setDateRangeAndFilter("01/01/2012", "11/17/2014")

    expect(getCount()).to eq(0)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1469|TC-3819: Add Button" do

    it "Visible" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

    it "Alt Text" do
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

  end

  describe "AC JRNL-1469|TC-3819: When Selecting Add" do

    it "Header" do
      @common.clickAddButton()
      !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
      expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
    end

    describe "Detailed Fields" do

      it "Content" do
        @lipids.getScreenContent().split("\n").each_with_index do | screenRow, i |
          break if (screenRow == "250 characters left" )
          expect(screenRow).to eq(@ENTRY_FORM[i])
        end
      end

      it "Required" do
        expect(@lipids.isFieldRequired(:css, Lipids::DATE)).to eq(true)
        expect(@lipids.isFieldRequired(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq(false)
        expect(@lipids.isFieldRequired(:css, Lipids::LDL_CHOLESTEROL)).to eq(false)
        expect(@lipids.isFieldRequired(:css, Lipids::HDL_CHOLESTEROL)).to eq(false)
        expect(@lipids.isFieldRequired(:css, Lipids::TRIGLYCERIDES)).to eq(false)
        expect(@lipids.isFieldRequired(:css, Lipids::FASTING)).to eq(false)
        expect(@lipids.isFieldRequired(:css, Lipids::NOTE)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        @lipids.setInput(Lipids::DATE, "")
        @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "")
        @lipids.setInput(Lipids::LDL_CHOLESTEROL, "")
        @lipids.setInput(Lipids::HDL_CHOLESTEROL, "")
        @lipids.setInput(Lipids::TRIGLYCERIDES, "")
        @lipids.setSelectBoxValue(Lipids::FASTING, "Select")

        @lipids.clickSaveButton()
        !15.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(false)

        @lipids.setInput(Lipids::DATE, "11/01")
        @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "700")
        @lipids.setInput(Lipids::LDL_CHOLESTEROL, "400")
        @lipids.setInput(Lipids::HDL_CHOLESTEROL, "400")
        @lipids.setInput(Lipids::TRIGLYCERIDES, "700")
        @lipids.setSelectBoxValue(Lipids::FASTING, "Yes")
        @lipids.clickSaveButton()

        !15.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Provide at least one Lab Result value to save your entry.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", %(Total Serum Cholesterol (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Low-Density Lipoprotein (LDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(High-Density Lipoprotein (HDL) (mg/dl) is outside the expected range. Please enter a value between 0 and 300.))).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", %(Triglycerides (mg/dl) is outside the expected range. Please enter a value between 0 and 600.))).to eq(true)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @lipids.setInput(Lipids::DATE, futureDate)
          @lipids.clickSaveButton()

          !15.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end

      end

    end

    describe "AC JRNL-1469|TC-3819: Standard Save and Cancel Options" do

      it "Cancel" do
        expect(@lipids.isCancelButtonVisible()).to eq(true)

        @lipids.clickCancelButton()
        !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
        expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

        expect(getCount()).to eq(0)
      end

      describe "Save" do

        it "Min" do
          @common.clickAddButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)

          @date_picker.click(:css, Lipids::DATE_BUTTON)
          !15.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
          @date_picker.setDateFromGUI(11, 11, 2014)
          sleep 1
          expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")

          @lipids.setInput(Lipids::TRIGLYCERIDES, "0")

          @lipids.clickSaveButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
          expect(@lipids.getFocusedElementText()).to eq(Lipids::HEADER)

          expect(getCount()).to eq(1)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

          expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")
          expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("")
          expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("")
          expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("")
          expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("0")
          expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("Select")
          expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("")
          expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("250 characters left")
        end

        it "Max" do
          @lipids.clickCancelButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

          @common.clickAddButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)
          @date_picker.click(:css, Lipids::DATE_BUTTON)
          !15.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
          @date_picker.setDateFromGUI(11, 13, 2014)
          sleep 1
          expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/13/2014")

          @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "600")
          @lipids.setInput(Lipids::LDL_CHOLESTEROL, "300")
          @lipids.setInput(Lipids::HDL_CHOLESTEROL, "300")
          @lipids.setInput(Lipids::TRIGLYCERIDES, "600")
          @lipids.setSelectBoxValue(Lipids::FASTING, "No")
          @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("83 characters left")

          @lipids.setInput(Lipids::NOTE, "This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$.")
          expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
          expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")

          @lipids.clickSaveButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
          expect(@lipids.getFocusedElementText()).to eq(Lipids::HEADER)

          expect(getCount()).to eq(2)
        end

        it "Verify Saved Data" do
          clickNthRow(1)
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::EDIT_HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::EDIT_HEADER)

          expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/13/2014")
          expect(@lipids.getTextFromInput(:css, Lipids::TOTAL_SERUM_CHOLESTEROL)).to eq("600")
          expect(@lipids.getTextFromInput(:css, Lipids::LDL_CHOLESTEROL)).to eq("300")
          expect(@lipids.getTextFromInput(:css, Lipids::HDL_CHOLESTEROL)).to eq("300")
          expect(@lipids.getTextFromInput(:css, Lipids::TRIGLYCERIDES)).to eq("600")
          expect(@lipids.getSelectBoxText(Lipids::FASTING)).to eq("No")
          expect(@lipids.getTextFromInput(:css, Lipids::NOTE)).to eq("This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$. This will be a long note! Over 250 characters. And some will be special ch@r@cter$")
          expect(@lipids.getTextFromInput(:css, Lipids::NOTE).length()).to eq(250)
          expect(@lipids.getTextForElement(:css, Lipids::NOTE_CHARACTER_COUNTER)).to eq("0 characters left")
          @lipids.clickCancelButton()
        end

        it "Verify error message for duplicate records" do
          expectedValidationSummaryHeader = "The following errors were found:"
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::HEADER)

          expect(getCount()).to eq(2)
          @common.clickAddButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::ADD_HEADER); sleep 1 }
          expect(@lipids.getPrimaryHeader()).to eq(Lipids::ADD_HEADER)

          @date_picker.click(:css, Lipids::DATE_BUTTON)
          !15.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
          @date_picker.setDateFromGUI(11, 11, 2014)
          sleep 1
          expect(@lipids.getTextFromInput(:css, Lipids::DATE)).to eq("11/11/2014")

          @lipids.setInput(Lipids::TOTAL_SERUM_CHOLESTEROL, "250")
          @lipids.setInput(Lipids::LDL_CHOLESTEROL, "100")
          @lipids.setInput(Lipids::HDL_CHOLESTEROL, "200")
          @lipids.setInput(Lipids::TRIGLYCERIDES, "100")
          @lipids.setSelectBoxValue(Lipids::FASTING, "Yes")

          @lipids.clickSaveButton()
          !15.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "You have already saved Cholesterol/Lipid values for this date. Please change the date or cancel this entry.")).to eq(true)

          @lipids.clickCancelButton()
          !15.times{ break if (@lipids.getPrimaryHeader() == Lipids::HEADER); sleep 1 }
          expect(@lipids.getFocusedElementText()).to eq(Lipids::HEADER)
          expect(getCount()).to eq(2)
        end

      end

    end

  end

end
=end