require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2478: Update Blood Pressure entry constraints and guidance text (Vitals)]
          [Story #JRNL-15: BP and Pulse: Enter Delete Edit]
          [Story #JRNL-34: BP Data Entry Validation]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

    before(:all) do
        initializeConfigurations(BASE_URL)
        removeCollection("vitalsigns", "medicalhistorydb")
        removeCollection("vitalsignsbundles", "medicalhistorydb")
        initializeAllObjects

        @baseNav = "BloodPressureandPulse"
        @expectedHeaders = {"add" => "Add Blood Pressure and Pulse Entry", "edit" => "Edit Blood Pressure and Pulse Entry", "summary" => "Blood Pressure and Pulse", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
        @normalTableHeaders = ["Systolic (mmHg)", "Diastolic (mmHg)", "Pulse (bpm)", "Position", "Date Entered"]
        @phoneTableHeaders = ["Systolic (mmHg)", "Diastolic (mmHg)", "Pulse (bpm)", "Date Entered"]

        @addDataSet = [{"Position" => "Standing", "Systolic" => "101", "Diastolic" => "100", "Pulse" => "100"},
                       {"Position" => "Lying", "Systolic" => "200", "Diastolic" => "150", "Pulse" => "250"},
                       {"Position" => "Sitting", "Systolic" => "80", "Diastolic" => "50", "Pulse" => "40"}]

        @editDataSet = [{"Position" => "Sitting", "Systolic" => "121", "Diastolic" => "84", "Pulse" => "95"},
                        {"Position" => "Lying", "Systolic" => "187", "Diastolic" => "129", "Pulse" => "47"},
                        {"Position" => "Standing", "Systolic" => "111", "Diastolic" => "77", "Pulse" => "205"}]

        @metaData = {
            "baseNav" => @baseNav,
            "orderedColumnsList" => ["Systolic", "Diastolic", "Pulse", "Position", "Date Entered"],
            "normalOrderedColumnLabels" => @normalTableHeaders,
            "phoneOrderedColumnLabels" => @phoneTableHeaders,
            "expectedHeaders" => @expectedHeaders,
            "formName" => "form",
            "pdf" => "summary",
            "graph" => {
                "xAxisLabels" => nil,
                "yAxisLabels" => ["Systolic/Diastolic (mmHg)", "Pulse (bpm)"]
            }
        }

        @fields = {
            "Position" => {
                "label" => "Position:",
                "type" => "select",
                "options" => ["", "Standing", "Sitting", "Lying"]
            },
            "Systolic" => {
                "label" => "Systolic (mmHg):",
                "type" => "keyboard",
                "min" => "80",
                "max" => "200",
                "minDelta" => 1,
                "required" => true
            },
            "Diastolic" => {
                "label" => "Diastolic (mmHg):",
                "type" => "keyboard",
                "min" => "50",
                "max" => "150",
                "minDelta" => 1,
                "required" => true
            },
            "Pulse" => {
                "label" => "Pulse (bpm):",
                "type" => "keyboard",
                "min" => "40",
                "max" => "250",
                "minDelta" => 1,
                "required" => true
            },
            "date" => {
                "label" => "Date:",
                "type" => "date",
                "required" => true
            },
            "time" => {
                "label" => "Time:",
                "type" => "time",
                "required" => true
            },
            "Note" => {
                "label" => "Note:",
                "type" => "keyboard",
                "maxLength" => 250,
                "hasCounter" => true
            }
        }

        @crossBlockSharing = {
            "expectedRowStrings" => nil
        }

        init(@metaData)
        @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    end

    after (:all) do
        quitDriver()
    end

    # Obsolete
    # it "AC #NAVYM-2397|TC #JRNL-490: Blood Pressure will be a topic under Vitals from the left Navigation Menu" do
    # end

    context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC #JRNL-828:  Blood pressure error prevention
           AC#NAVYM-2398|AC#JRNL-384|TC#JRNL-490|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries; Display 'Systolic' and 'Diastolic' with '(mmHg)' and 'Pulse' with (bpm); Boundary Test for Systolic/Diastolic/Pulse; Verify the max allowed characters for Note" do

        it "JRNL-950 .Display 'Systolic' and 'Diastolic' with '(mmHg)' and 'Pulse' with (bpm)" do
            waitForPageToFinishLoading
            @main.clickNavMenu()
            fieldLabelTests(@fields)
            waitForPageToFinishLoading
            @driver.find_element(:id, "PersonalTrackers").click
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[class='btn btn-default blood-pressure-and-pulse']").click
            waitForPageToFinishLoading
            @entry_form.clickAddEntryButton()
            waitForPageToFinishLoading
            @modalpop.clickBPPInfoIconSystolic
            expect(@modalpop.getInfoIconDiastolicHeader()).to eq("About Systolic Blood Pressure\nClose")
            expect(@modalpop.getInfoIconDiastolicParagraph()).to eq("Systolic Pressure is the top number. It is the force that blood exerts on the artery walls during a heart beat.")
            @modalpop.clickInfoIconOKButton
            @modalpop.clickBPPInfoIconDiastolic
            expect(@modalpop.getInfoIconSystolicHeader()).to eq("About Diastolic Blood Pressure\nClose")
            expect(@modalpop.getInfoIconSystolicParagraph()).to eq("Diastolic Pressure is the lower number. It is the force that blood exerts on the arteries between heart beats.")
            @modalpop.clickInfoIconOKButton
          end

        it ".Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries
             .Boundary Test for Systolic/Diastolic/Pulse
             .Verify the max allowed characters for Note
             .Blood pressure error prevention" do
           fieldRestrictionTests(@fields)
        end

        it ".header 'Add <personal tracker name> Entry'" do
           addTest(@fields, @addDataSet)
           #unsavedWarningModalTests()
        end

        it ".header 'Edit <personal tracker name> Entry'" do
           @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
        end
        end

    ### OBSOLETE - PDF has been moved to Health Messages ###
    # context "AC #JRNL-866|TC #JRNL-947: View PDF - BP" do
    #     it ".View PDF - BP" do
    #        pdfTest()
    #     end
    # end

    context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do
        it ".header '<personal tracker name>'" do
           navigationTests()
        end

        it ".test default filter data" do
           refreshBrowser()

           !5.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }

           expect(@date_filter.isDefaultDateRange()).to be true
           waitForPageToFinishLoading
           filterLabelsAndPlaceholdersTest()
           waitForPageToFinishLoading
        end

        it ".test filtering data" do
           filterTest(@crossBlockSharing["expectedRowStrings"])
        end
    end

    context "Story JRNL-1696|AC JRNL-1583: Reset Button" do
        it "Visible" do
           expect(@date_filter.isResetButtonPresent()).to eq(true)
        end

        it "Label" do
           expect(@date_filter.getResetButtonLabel()).to eq("Reset")
        end

        it "Result" do
           @date_filter.clickResetBtn()
           !5.times { break if (getFocusedElementText().include?("Systolic")); sleep 1 }
           expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
           #expect(getCount()).to eq(3)

           # DEFAULT
           expect(@date_filter.isDefaultDateRange()).to eq(true)
        end
    end

    context "AC #NAVYM-2399|TC #JRNL-490 Entries will be sorted in reverse chronological order
            AC #NAVY-2399|TC #JRNL-490: Display User Entered Data" do

        it ".table headers" do
           tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
        end

        it ".Entries will be sorted in reverse chronological order
           .Display User Entered Data"  do
           sortTest(@crossBlockSharing["expectedRowStrings"])
        end
    end

    context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
             AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
             AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830: Text description guidance text update" do
      it ".The graph will display the date range that is currently being displayed
          .Display Graph in detail pane
          .Table View can be selected
          .Text description guidance text update" do
          graphTest()
      end
    end

    context "AC #NAVY-2398|TC #JRNL-490: User should be able to DELETE entries" do
      it ".User should be able to DELETE entries" do
        deleteTest()
        end
      end
end










































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin

require_relative '../../../globalized'
include Globalized


describe "[Story #JRNL-2478: Update Blood Pressure entry constraints and guidance text (Vitals)]
          [Story #JRNL-15: BP and Pulse: Enter Delete Edit]
          [Story #JRNL-34: BP Data Entry Validation]
          [Story #JRNL-497: Convert pop-up error messages to on page]
          [Story #JRNL-61: Graph My Vital Signs: View Tracked Items Over Time]
          [Story #JRNL-805: Detail Page table view guidance - update vital]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")
    initializeAllObjects

    @baseNav = "BloodPressureandPulse"
    @expectedHeaders = {"add" => "Add Blood Pressure and Pulse Entry", "edit" => "Edit Blood Pressure and Pulse Entry", "summary" => "Blood Pressure and Pulse", "secondary" => "Personal Trackers", "title" => "Personal Trackers"}
    @normalTableHeaders = ["Systolic (mmHg)", "Diastolic (mmHg)", "Pulse (bpm)", "Position", "Date Entered"]
    @phoneTableHeaders = ["Systolic (mmHg)", "Diastolic (mmHg)", "Pulse (bpm)", "Date Entered"]

    @addDataSet = [{"Position" => "Standing", "Systolic" => "101", "Diastolic" => "100", "Pulse" => "100"},
      {"Position" => "Lying", "Systolic" => "200", "Diastolic" => "150", "Pulse" => "250"},
      {"Position" => "Sitting", "Systolic" => "80", "Diastolic" => "50", "Pulse" => "40"}]

    @editDataSet = [{"Position" => "Sitting", "Systolic" => "121", "Diastolic" => "84", "Pulse" => "95"},
      {"Position" => "Lying", "Systolic" => "187", "Diastolic" => "129", "Pulse" => "47"},
      {"Position" => "Standing", "Systolic" => "111", "Diastolic" => "77", "Pulse" => "205"}]

    @metaData = {
      "baseNav" => @baseNav,
      "orderedColumnsList" => ["Systolic", "Diastolic", "Pulse", "Position", "Date Entered"],
      "normalOrderedColumnLabels" => @normalTableHeaders,
      "phoneOrderedColumnLabels" => @phoneTableHeaders,
      "expectedHeaders" => @expectedHeaders,
      "formName" => "form",
      "pdf" => "summary",
      "graph" => {
        "xAxisLabels" => nil,
        "yAxisLabels" => ["Systolic/Diastolic (mmHg)", "Pulse (bpm)"]
      }
    }

    @fields = {
      "Position" => {
        "label" => "Position:",
        "type" => "select",
        "options" => ["", "Standing", "Sitting", "Lying"]
      },
      "Systolic" => {
        "label" => "Systolic (mmHg):",
        "type" => "keyboard",
        "min" => "80",
        "max" => "200",
        "minDelta" => 1,
        "required" => true
      },
      "Diastolic" => {
        "label" => "Diastolic (mmHg):",
        "type" => "keyboard",
        "min" => "50",
        "max" => "150",
        "minDelta" => 1,
        "required" => true
      },
      "Pulse" => {
        "label" => "Pulse (bpm):",
        "type" => "keyboard",
        "min" => "40",
        "max" => "250",
        "minDelta" => 1,
        "required" => true
      },
      "date" => {
        "label" => "Date:",
        "type" => "date",
        "required" => true
      },
      "time" => {
        "label" => "Time:",
        "type" => "time",
        "required" => true
      },
      "Note" => {
        "label" => "Note:",
        "type" => "keyboard",
        "maxLength" => 250,
        "hasCounter" => true
      }
    }

    @crossBlockSharing = {
      "expectedRowStrings" => nil
    }


    init(@metaData)

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

  end

  after (:all) do
    quitDriver()
  end

  # Obsolete
  # it "AC #NAVYM-2397|TC #JRNL-490: Blood Pressure will be a topic under Vitals from the left Navigation Menu" do
  # end

  context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens
           AC #JRNL-828:  Blood pressure error prevention
           AC#NAVYM-2398|AC#JRNL-384|TC#JRNL-490|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries; Display 'Systolic' and 'Diastolic' with '(mmHg)' and 'Pulse' with (bpm); Boundary Test for Systolic/Diastolic/Pulse; Verify the max allowed characters for Note" do


    it "JRNL-950 .Display 'Systolic' and 'Diastolic' with '(mmHg)' and 'Pulse' with (bpm)" do
      waitForPageToFinishLoading
      @main.clickNavMenu()
      fieldLabelTests(@fields)
      @modalpop.clickBPPInfoIconSystolic
  #     expect(@modalpop.getInfoIconDiastolicHeader()).to eq("About Systolic Blood Pressure\nClose")
  #     expect(@modalpop.getInfoIconDiastolicParagraph()).to eq("Systolic Pressure is the top number. It is the force that blood exerts on the artery walls during a heart beat.")
  #     @modalpop.clickInfoIconOKButton
  #     @modalpop.clickBPPInfoIconDiastolic
  #     expect(@modalpop.getInfoIconSystolicHeader()).to eq("About Diastolic Blood Pressure\nClose")
  #     expect(@modalpop.getInfoIconSystolicParagraph()).to eq("Diastolic Pressure is the lower number. It is the force that blood exerts on the arteries between heart beats.")
  #     @modalpop.clickInfoIconOKButton
  #   end
  #
  #   it ".Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries
  #       .Boundary Test for Systolic/Diastolic/Pulse
  #       .Verify the max allowed characters for Note
  #       .Blood pressure error prevention" do
  #     fieldRestrictionTests(@fields)
  #   end
  #
  #   it ".header 'Add <personal tracker name> Entry'" do
  #     addTest(@fields, @addDataSet)
  #
  #     unsavedWarningModalTests()
  #
  #   end
  #
  #   it ".header 'Edit <personal tracker name> Entry'" do
  #     @crossBlockSharing["expectedRowStrings"] = editTest(@fields, @addDataSet, @editDataSet)
  #   end
  #
  # end
  #
  # context "AC #JRNL-866|TC #JRNL-947: View PDF - BP" do
  #   it ".View PDF - BP" do
  #     pdfTest()
  #   end
  # end
  #
  # context "#AC #JRNL-1901|TC #JRNL-1840: Verify Standardize Header Labels for Table, Add and Edit detail screens" do
  #
  #   it ".header '<personal tracker name>'" do
  #     navigationTests()
  #   end
  #
  #   it ".test default filter data" do
  #     refreshBrowser()
  #
  #     !45.times{ break if (getMainHeader() == @expectedHeaders["summary"]); sleep 0.5 }
  #
  #     expect(@date_filter.isDefaultDateRange()).to be true
  #
  #     filterLabelsAndPlaceholdersTest()
  #   end
  #
  #   it ".test filtering data" do
  #     filterTest(@crossBlockSharing["expectedRowStrings"])
  #   end
  #
  # end
  #
  # context "Story JRNL-1696|AC JRNL-1583: Reset Button" do
  #
  #   it "Visible" do
  #     expect(@date_filter.isResetButtonPresent()).to eq(true)
  #   end
  #
  #   it "Label" do
  #     expect(@date_filter.getResetButtonLabel()).to eq("Reset")
  #   end
  #
  #   it "Result" do
  #     @date_filter.clickResetBtn()
  #     !10.times { break if (getFocusedElementText().include?("Systolic")); sleep 1 }
  #     expect(getFocusedElementText()).to eq(getTextForRow(1) + %(\n ))
  #     expect(getCount()).to eq(3)
  #
  #     # DEFAULT
  #     expect(@date_filter.isDefaultDateRange()).to eq(true)
  #   end
  #
  # end
  #
  # context "AC #NAVYM-2399|TC #JRNL-490 Entries will be sorted in reverse chronological order
  #         AC #NAVY-2399|TC #JRNL-490: Display User Entered Data" do
  #
  #   it ".table headers" do
  #     tableHeaderTest(@normalTableHeaders, @phoneTableHeaders)
  #   end
  #
  #   it ".Entries will be sorted in reverse chronological order
  #       .Display User Entered Data"  do
  #     sortTest(@crossBlockSharing["expectedRowStrings"])
  #   end
  #
  # end
  #
  # context "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed
  #          AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane
  #          AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830: Text description guidance text update" do
  #   it ".The graph will display the date range that is currently being displayed
  #       .Display Graph in detail pane
  #       .Table View can be selected
  #       .Text description guidance text update" do
  #     graphTest()
  #   end
  # end
  #
  # context "AC #NAVY-2398|TC #JRNL-490: User should be able to DELETE entries" do
  #   it ".User should be able to DELETE entries" do
  #     deleteTest()
    end
    end

end
=end






