require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1336: Phone User:  List View and Filter: Options Control]
         [Story #JRNL-1289: Update Options control used by phone users]", :broken => true, :regression => true do

  include DriverUtility
  include MongoUtility
  include Table

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    resizeWindowToPhone()
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");
  end

  after(:all) do
    quitDriver()
  end

  describe "[AC #JRNL-1310| TC #JRNL-1305: Personal Tracker Display]
            [AC #JRNL-1257| TC #JRNL-1209: Options control features]" do

    context "click through each submenu on Personal Tracker Menu" do

      Nav_menu::NAV.each_with_index do | item, i|

        if item[1]["dependsOn"] == "PersonalTrackers"
          screenName = item[0]
          it "should bring up #{screenName}" do

            # Go to Personal Trackers menu list and select next menu item
            @main.clickNavMenu()
            !45.times { break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
            expect(@navMenu.getNavMenuHeading()).to eq("App Options")

            @navMenu.clickPersonalTrackers()
            !45.times { break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
            expect(getSecondaryHeader()).to eq("Personal Trackers")

            screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
            @navMenu.click(:css, item[1]["navButton"])
            sleep 2.0

            !45.times { break if (@personaltracker_list_screen.getPrimaryHeader() == screenTitle); sleep 1 }
            expect(@personaltracker_list_screen.getPrimaryHeader()).to eq(screenTitle)

            # Wait for some time to allow option menu to display before proceeding
            !10.times{ break if (@options_dropdown.isOptionMenuExists); sleep 1 }

            # If there is a Option dropdown, verify Graph button exists and is clickable,
            # Otherwise verify this tracker does not have a Graph button
            if @options_dropdown.isOptionMenuExists == true

              @options_dropdown.clickBtn
              !45.times { break if (@options_dropdown.isOptionMenuExpanded == true); sleep 1 };
              expect(@options_dropdown.isOptionMenuExpanded).to eq(true)
              if screenName != "DailyEvents"
                expect(@options_dropdown.graph_button_exists?).to eq(true)
                @options_dropdown.clickGraphBtn
                @options_dropdown.clickBtn
                expect(@options_dropdown.table_button_exists?).to eq(true)
              end

              #Verify Notification button exists
              expect(@options_dropdown.notification_button_exists?).to eq(true)

              #Verify if click anywhere on screen, options list closes
              expect(@options_dropdown.isOptionMenuExpanded).to eq(true)
              click(:css, "nav-bar")
              !45.times { break if (@options_dropdown.isOptionMenuExpanded == false); sleep 1 };
              expect(@options_dropdown.isOptionMenuExpanded).to eq(false)

              #Click on Back button
              @common.clickBackButton()
              !45.times { break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
              expect(getSecondaryHeader()).to eq("Personal Trackers")

              #Reselect the tracker
              @navMenu.click(:css, item[1]["navButton"])
              sleep 2.0
              !45.times { break if (@personaltracker_list_screen.getPrimaryHeader() == screenTitle); sleep 1 }
              expect(@personaltracker_list_screen.getPrimaryHeader()).to eq(screenTitle)

              #Verify Option Menu button exists
              !10.times{ break if (@options_dropdown.isOptionMenuExists); sleep 1 }
              expect(@options_dropdown.isOptionMenuExists).to eq(true)

              !10.times { break if (@options_dropdown.isOptionMenuExpanded == false); sleep 1 };
              expect(@options_dropdown.isOptionMenuExpanded).to eq(false)

            else
              expect(@options_dropdown.graph_button_exists?).to eq(false)
              expect(@options_dropdown.isOptionMenuExists).to eq(false)
            end

          end

          it "should Open and close the dropdown menu by clicking on the options dropdown button for #{screenName}" do
            if @options_dropdown.isOptionMenuExists == true
              #Open the dropdown list
              @options_dropdown.clickBtn
              !10.times { break if (@options_dropdown.isOptionMenuExpanded == true); sleep 1 };
              expect(@options_dropdown.isOptionMenuExpanded).to eq(true)

              #Close the dropdown list to make sure it can close by clicking on the dropdown.
              @options_dropdown.clickBtn
              !10.times { break if (@options_dropdown.isOptionMenuExpanded == false); sleep 1 };
              expect(@options_dropdown.isOptionMenuExpanded).to eq(false)
            end
          end

          it "should expect screen reader content for #{screenName} " do
            if @options_dropdown.isOptionMenuExists == true
              #Open the dropdown list
              @options_dropdown.clickBtn
              !10.times { break if (@options_dropdown.isOptionMenuExpanded == true); sleep 1 };
              expect(@options_dropdown.getButtonScreenReaderText()).to eq("Collapse Options list button")

              #Close the dropdown list to make sure it can close by clicking on the dropdown.
              @options_dropdown.clickBtn
              !10.times { break if (@options_dropdown.isOptionMenuExpanded == false); sleep 1 };
              expect(@options_dropdown.getButtonScreenReaderText()).to eq("Expand Options list button")
            end
          end

        end
      end
    end
  end

end