require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1383: Ensure Tracker entry date/time values are unique]", :regression => true do

  before(:all) do

    #-- Generic add procedure code
    @addProcedureCode = Proc.new do | screenName, screenTitle, requiredFields, entryEventDate, entryEventTime|
      puts "  Adding personal tracker in (#{screenTitle})"

      @common.clickAddButton()

      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Add #{screenTitle} Entry"); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq("Add #{screenTitle} Entry")

      setKeyboardField("date", entryEventDate)
      setKeyboardField("time", entryEventTime)

      requiredFields.each_with_index do | codeblock, i |
        codeblock.call()
      end

      @personaltracker_form.clickSaveButton()
    end

    #-- Array that holds the add routine for each of the personal trackers
    @addArray = {
      "BloodPressureandPulse" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Systolic","120")} ,
          Proc.new {setKeyboardField("Diastolic","100")} ,
          Proc.new {setKeyboardField("Pulse","150")}
        ]
      },
      "Diet"    => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("mealType", "Snack")},
          Proc.new {setKeyboardField("caloriesInput","100")}
        ]
      },
      "Exercise" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("activityInput", "Walking")},
          Proc.new {setKeyboardField("distanceInput","5")}
        ]
      },
      "Glucose" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setInput(Glucose::GLUCOSE_LEVEL, "200")} ,
          Proc.new {setSelectBoxValue(Glucose::TESTED, "After Meal")}
        ]
      },
      "Height" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Height", "75")}
        ]
      },
      "Mood"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Pain"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Respiration" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Respiration", "40")}
        ]
      },
      "Stress"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Temperature" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Temperature", "98")}
        ]
      },
      "Weight" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Weight", "98")}
        ]
      },
    }

    # Array that holds a array of input data for the Sleep Tracker routine
    # Format of the internal array is: [[start_date, start_time, end_date, end_time], expected_result]
    #
    # Scenarios tested are:
    #
    #                6:00AM                           6:00PM                #0
    #                  |                                |
    #  O--O            |                                |                   #1
    #                  |                                |           O---O   #2
    #                  |                                |
    #        O----------------O                         |                   #3
    #                  |                                O--------O          #4
    #                  |                                |
    #                  |    O--------------------O      |                   #5
    #                  |                                |
    #             O-------------------------------------------O             #6
    #                  |                                |
    #     O------------O                                |                   #7
    #                  |                                O--------O          #8
    #                  |                                |
    #                  O-------O                        |                   #9
    #                  |                        O-------O                  #10
    #                  |                                |
    #                  O--------------------------------O                  #11
    #                  |                                |
    #     O---------------------------------------------O                  #12
    #                  |                                |
    #                  O---------------------------------------------O     #13
    #                  |                                |
    #                  O                                |                  #14
    #                  |                                O                  #15

    @addSleepArray = [
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM"], "success"  ],   # 0
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "02:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "03:00 AM"], "success"  ],   # 1
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "10:00 PM", getDateNthDaysAgo(1, "%m/%d/%Y"), "11:00 PM"], "success"  ],   # 2
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "04:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 AM"], "duperror" ],   # 3
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 PM"], "duperror" ],   # 4
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "09:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "04:00 PM"], "duperror" ],   # 5
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "04:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 PM"], "duperror" ],   # 6
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "04:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM"], "duperror" ],   # 7
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 PM"], "duperror" ],   # 8
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 AM"], "duperror" ],   # 9
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "04:00 PM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM"], "duperror" ],   # 10
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM"], "duperror" ],   # 11
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "05:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM"], "duperror" ],   # 12
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "07:00 PM"], "duperror" ],   # 13
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 AM"], "duperror" ],   # 14
         [ [getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM", getDateNthDaysAgo(1, "%m/%d/%Y"), "06:00 PM"], "duperror" ],   # 15
    ]

    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    ########################
    ### CLEAR MONGO DATA ###
    ########################
    # Glucose
    removeCollection("chemlabs", "medicalhistorydb")
    # Cholesterol/Lipid
    removeCollection("chemlabsbundles", "medicalhistorydb")
    # Stress
    removeCollection("stress", "medicalhistorydb")
    # Sleep
    removeCollection("sleep", "medicalhistorydb")
    # Mood
    removeCollection("mood", "medicalhistorydb")
    # Height, Weight, Pain, Respiration, Temperature
    removeCollection("vitalsigns", "medicalhistorydb")
    # Blood Pressure and Pulse
    removeCollection("vitalsignsbundles", "medicalhistorydb")
    # Diet
    removeCollection("diet", "healthfactordb")
    # Exercise
    removeCollection("fitness", "healthfactordb")
  end

  after(:all) do
    quitDriver()
  end

  describe "Story #JRNL-1383: Ensure Tracker entry date/time values are unique" do

    it "AC #JRNL-1361|TC #JRNL-1335 Prevent duplicate data/time entry", :broken => true do
      #-- Go through all menus and submenus
      Nav_menu::NAV.each_with_index do | item, i|
        #-- Process only Personal Trackers submenus that match the applicable trackers (in @addArray)
        if (item[1]["dependsOn"] == "PersonalTrackers") and @addArray.include?(item[0])
          screenName = item[0]

          #--Navigate to the personal tracker screen (list/filter view)
          @navMenu.click(:css, item[1]["navButton"])
          sleep 2.0

          screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #--Add a personal tracker record
          entryEventDate = getDateNthDaysAgo(1, "%m/%d/%Y")
          entryEventTime = "11:14 PM"
          @addArray[screenName]["proc"].call(screenName, screenTitle, @addArray[screenName]["requiredFields"], entryEventDate, entryEventTime)
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #--Add another duplicate tracker record (same date)
          @addArray[screenName]["proc"].call(screenName, screenTitle, @addArray[screenName]["requiredFields"], entryEventDate, entryEventTime)
          verifyDuplicateErrorMessage(screenTitle)

          @personaltracker_form.clickCancelButton()
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #-- Add a second tracker that is of different time so should be successful
          entryEventTime2 = "11:14 AM"
          @addArray[screenName]["proc"].call(screenName, screenTitle, @addArray[screenName]["requiredFields"], entryEventDate, entryEventTime2)
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #--Select the second record just added
          clickNthRow(2)
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Edit #{screenTitle} Entry"); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq("Edit #{screenTitle} Entry")

          #--Change the time to that of the first one to try to create a duplicate date/time
          setKeyboardField("time", entryEventTime)

          @personaltracker_form.clickSaveButton()
          verifyDuplicateErrorMessage(screenTitle)

          @personaltracker_form.clickCancelButton()
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)
        end
      end
    end

    it "AC #JRNL-1337|TC #JRNL-1335 Sleep Tracker - Prevent duplicate data/time entry", :broken => true do
      #--Navigate to the Sleep personal tracker screen (list/filter view)
      @navMenu.click(:css, Nav_menu::NAV["Sleep"]["navButton"])
      sleep 2.0

      screenTitle = getTextForElement(:css, Nav_menu::NAV["Sleep"]["navButton"]).sub("\nselected","")
      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

      #-- Add a sleep tracker (the first one in the array), and then try adding subsequent overlapping sleep trackers
      @addSleepArray.each_with_index do | sleep_entry, i|
        sleep_data = sleep_entry[0]
        sleep_result = sleep_entry[1]

        addSleepTracker(sleep_data[0], sleep_data[1], sleep_data[2], sleep_data[3])

        #-- If expected result is a dup error, verify message
        if sleep_result == "duperror"
          verifyDuplicateErrorMessage(screenTitle)
          @personaltracker_form.clickCancelButton()
        end
        #-- Verify header after cancel button click or successful save
        !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
        expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)
      end

      #-- Try changing last successfully added sleep tracker added to be like first sleep date/times
      clickNthRow(3)
      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Edit Sleep Entry"); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq("Edit Sleep Entry")

      #-- Get first sleep tracker's data
      first_sleep_entry_data = @addSleepArray[0][0]

      setInput(Sleep::STARTDATE, first_sleep_entry_data[0])
      setInput(Sleep::STARTTIME, first_sleep_entry_data[1])
      setInput(Sleep::ENDDATE,   first_sleep_entry_data[2])
      setInput(Sleep::ENDTIME,   first_sleep_entry_data[3])

      @personaltracker_form.clickSaveButton()
      verifyDuplicateErrorMessage(screenTitle)

      @personaltracker_form.clickCancelButton()
      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)
    end

  end

  #######################
  ### LOCAL FUNCTIONS ###
  #######################
  def addSleepTracker(start_date, start_time, end_date, end_time)
      @common.clickAddButton()
      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Add Sleep Entry"); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq("Add Sleep Entry")

      setInput(Sleep::STARTDATE, start_date)
      setInput(Sleep::STARTTIME, start_time)
      setInput(Sleep::ENDDATE,  end_date)
      setInput(Sleep::ENDTIME, end_time)

      @personaltracker_form.clickSaveButton()
  end

  def verifyDuplicateErrorMessage(screen_title)
    #--Verify get duplicate date/time entry message

    expectedValidationSummaryHeader = "The following errors were found:"
    !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
    if(screen_title == "Sleep")
      expect(@error.isErrorMessageDisplayed("form", "A previous sleep entry overlaps with this entry. Sleep entries cannot overlap. Please update your start and/or end dates and times and save again.")).to eq(true)
    else
      tracker_clause = (screen_title == "Exercise") ?  "An Exercise" : "A #{screen_title}"
      expect(@error.isErrorMessageDisplayed("form", "#{tracker_clause} entry was already saved with the same date and time. Please update the date and/or time and save again.")).to eq(true)
    end
  end

end
