require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1780: Personal Trackers Settings]", :broken => true, :regression => true do

  before(:all) do

    @SETTINGS_SCREEN = [
      "Personal Trackers - Display Options",
      "Select trackers to include in your Personal Tracker list.",
      "Removing a tracker from your list will not remove your tracker data," +
      " however all notifications tied to that tracker will be turned off.",
      "You may add a tracker back to your list at any time.",
      "Blood Pressure and Pulse",
      "Cholesterol/Lipid",
      "Daily Events",
      "Diet",
      "Exercise",
      "Glucose (Self Tested)",
      "Height",
      "Mood",
      "Pain",
      "Respiration",
      "Sleep",
      "Stress",
      "Temperature",
      "Weight",
      "Save Cancel",
    ]

    @trackers = [
      'bp',
      'lipid',
      'events',
      'diet',
      'exercise',
      'glucose',
      'height',
      'mood',
      'pain',
      'respiration',
      'sleep',
      'stress',
      'temperature',
      'weight'
    ]

    #-- Generic add procedure code
    @addProcedureCode = Proc.new do | screenName, screenTitle, requiredFields|
      puts "  Adding personal tracker in (#{screenTitle})"

      @common.clickAddButton()
      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Add #{screenTitle} Entry"); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq("Add #{screenTitle} Entry")

      requiredFields.each_with_index do | codeblock, i |
          codeblock.call()
      end

      @personaltracker_form.clickSaveButton()
      !45.times{ break if (@personaltracker_list_screen.getPrimaryHeader() == "#{screenTitle}"); sleep 1 }
      expect(@personaltracker_list_screen.getPrimaryHeader()).to eq("#{screenTitle}")
    end

    #-- Array that holds the add routine for each of the personal trackers
    @addArray = {
      "BloodPressureandPulse" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Systolic","120")} ,
          Proc.new {setKeyboardField("Diastolic","100")} ,
          Proc.new {setKeyboardField("Pulse","150")}
        ]
      },
      "Lipids" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Total Serum Cholesterol","400")} ,
          Proc.new {setKeyboardField("Low-Density Lipoprotein (LDL)","100")} ,
          Proc.new {setKeyboardField("High-Density Lipoprotein (HDL)","150")} ,
          Proc.new {setKeyboardField("Triglycerides","300")},
          Proc.new {setSelectBoxValue("select[name='fasting']", "Yes")}
        ]
      },
      "DailyEvents" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("eventTitle", "A spectacular event")}
        ]
      },
      "Diet"    => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("mealType", "Snack")},
          Proc.new {setKeyboardField("caloriesInput","100")},
          Proc.new {setKeyboardField("fatInput","200")},
          Proc.new {setKeyboardField("carbInput","300")},
          Proc.new {setKeyboardField("proteinInput","400")}
        ]
      },
      "Exercise" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("activityInput", "Walking")},
          Proc.new {setKeyboardField("durationInput", "30")}
        ]
      },
      "Glucose" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setInput(Glucose::GLUCOSE_LEVEL, "200")} ,
          Proc.new {setSelectBoxValue(Glucose::TESTED, "After Meal")}
        ]
      },
      "Height" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Height", "75")}
        ]
      },
      "Mood"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Pain"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Respiration" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Respiration", "40")}
        ]
      },
      "Sleep"    => {
        "proc"  => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setInput(Sleep::STARTDATE, getDateNthDaysAgo(1, "%m/%d/%Y"))} ,
          Proc.new {setInput(Sleep::STARTTIME, "06:00 AM")} ,
          Proc.new {setInput(Sleep::ENDDATE, getDateNthDaysAgo(1, "%m/%d/%Y"))} ,
          Proc.new {setInput(Sleep::ENDTIME, "06:00 PM")}
        ]
      },
      "Stress"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Temperature" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Temperature", "98")}
        ]
      },
      "Weight" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Weight", "98")}
        ]
      },
    }

    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    ########################
    ### CLEAR MONGO DATA ###
    ########################
    # Glucose
    removeCollection("chemlabs", "medicalhistorydb")
    # Cholesterol/Lipid
    removeCollection("chemlabsbundles", "medicalhistorydb")
    # Stress
    removeCollection("stress", "medicalhistorydb")
    # Sleep
    removeCollection("sleep", "medicalhistorydb")
    # Mood
    removeCollection("mood", "medicalhistorydb")
    # Height, Weight, Pain, Respiration, Temperature
    removeCollection("vitalsigns", "medicalhistorydb")
    # Blood Pressure and Pulse
    removeCollection("vitalsignsbundles", "medicalhistorydb")
    # Diet
    removeCollection("diet", "healthfactordb")
    # Exercise
    removeCollection("fitness", "healthfactordb")
    # Notification
    removeCollection("reminders", "remindersdb")
    # Preferences
    removeCollection("preferences", "healthtrackerdb")
    # Daily Events
    removeCollection("notes", "medicalhistorydb")
  end

  after(:all) do
    removeCollection("preferences", "healthtrackerdb")
    quitDriver()
  end

  describe "AC #JRNL-1338| TC #JRNL-1325: Personal Tracker Display" do

    it ".verify all trackers are initally listed" do
      @navMenu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")
      expect(@navMenu.getSubFeatureCount()).to eq(@trackers.length)
    end

    it ".select gear to open settings modal", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")
    end

    it ".verify instructional text, and list of trackers", :broken => true do
      @personaltracker_settings.getScreenContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@SETTINGS_SCREEN[i])
      end

      expect(@personaltracker_settings.getScreenContent().split("\n").length).to eq(@SETTINGS_SCREEN.length)
    end

    it ".verify default is that all tracker settings are checked", :broken => true do
      @trackers.each_with_index do |tracker, i|
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
      end

      @personaltracker_settings.clickCancelButton()
    end

    it ".enter tracker data and enable notification", :broken => true do
      #-- Go through all menus and submenus
      Nav_menu::NAV.each_with_index do | item, i|
        #-- Process only Personal Trackers submenus
        if item[1]["dependsOn"] == "PersonalTrackers"
          screenName = item[0]

          #--Navigate to the personal tracker screen (list/filter view)
          @navMenu.click(:css, item[1]["navButton"])
          sleep 2.0

          screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #--Add a personal tracker record
          @addArray[screenName]["proc"].call(screenName, screenTitle, @addArray[screenName]["requiredFields"])

          screenNotificationTitle = determineScreenNotificationTitle(screenName, screenTitle)
          setInAppEmailNotifications(screenName, screenTitle, screenNotificationTitle)
        end
      end
    end

    it ".remove all and save", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(false)
      end

      @personaltracker_settings.clickSaveButton()
      !30.times{ break if(@navMenu.getSubFeatureCount() == 0); sleep 1 }
      expect(@navMenu.getSubFeatureCount()).to eq(0)

      expect(@navMenu.getNoMenuItemsMessage()).to eq("All Personal Trackers are currently hidden. Use the gear icon above to add trackers.")
    end

    it ".reselect all", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
      end

      @personaltracker_settings.clickSaveButton()
      sleep 2

      !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")

      expect(@navMenu.getSubFeatureCount()).to eq(@trackers.length)
    end

    it ".verify trackers still have data and the notification got disabled", :broken => true do
      #-- Go through all menus and submenus
      Nav_menu::NAV.each_with_index do | item, i|
        #-- Process only Personal Trackers submenus
        if item[1]["dependsOn"] == "PersonalTrackers"
          screenName = item[0]

          #--Navigate to the personal tracker screen (list/filter view)
          @navMenu.click(:css, item[1]["navButton"])
          sleep 2.0

          screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          #--Verify count on list is 1
          expect(getCount()).to eq(1)

          expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
          !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (Off)"); sleep 1 }
          expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (Off)")
          expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (Off)")
        end
      end
    end

    it ".remove some but then cancel", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(false)
      end

      @personaltracker_settings.clickCancelButton()

      expect(@navMenu.getSubFeatureCount()).to eq(@trackers.length)
    end

    it ".remove all", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(false)
      end

      @personaltracker_settings.clickSaveButton()
      waitForPageToFinishLoading()

      expect(@navMenu.getSubFeatureCount()).to eq(0)

      expect(@navMenu.getNoMenuItemsMessage()).to eq("All Personal Trackers are currently hidden. Use the gear icon above to add trackers.")
    end

    it ".reselect all but then cancel", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(false)
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
      end

      @personaltracker_settings.clickCancelButton()

      expect(@navMenu.getSubFeatureCount()).to eq(0)

      expect(@navMenu.getNoMenuItemsMessage()).to eq("All Personal Trackers are currently hidden. Use the gear icon above to add trackers.")
    end

    it ".reselect all", :broken => true do
      @personaltracker_settings.clickTheGearIcon()
      !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
      expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

      @trackers.each_with_index do |tracker, i|
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(false)
        @personaltracker_settings.clickTracker(tracker)
        expect(@personaltracker_settings.isTrackerSelected(tracker)).to eq(true)
      end

      @personaltracker_settings.clickSaveButton()
      sleep 2
      !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")

      expect(@navMenu.getSubFeatureCount()).to eq(@trackers.length)
    end

    describe "AC #JRNL-1318 | TC #JRNL-1325: Navigation" do

      it ".unselect the current tracker - list/filter page", :broken => true do
        @navMenu.click(:css, Nav_menu::NAV["BloodPressureandPulse"]["navButton"])
        !45.times{ break if(getPrimaryHeader() == "Blood Pressure and Pulse"); sleep 1}
        expect(getPrimaryHeader()).to eq("Blood Pressure and Pulse")

        @personaltracker_settings.clickTheGearIcon()
        !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
        expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

        @personaltracker_settings.clickTracker('bp')
        expect(@personaltracker_settings.isTrackerSelected('bp')).to eq(false)

        @personaltracker_settings.clickSaveButton()
        !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
        expect(getSecondaryHeader()).to eq("Personal Trackers")
        !30.times{ break if(getPrimaryHeader() == "Personal Trackers"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Personal Trackers")
      end

      context "Click settings from entry page" do

        it ".clean", :broken => true do
          @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
          !45.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1}
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")

          @personaltracker_list_screen.clickAddEntryButton()
          !45.times{ break if(getPrimaryHeader() == "Add Cholesterol/Lipid Entry"); sleep 1}
          expect(getPrimaryHeader()).to eq("Add Cholesterol/Lipid Entry")

          @personaltracker_settings.clickTheGearIcon()
          !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
          expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

          #Check the screen underneath the modal
          sleep 2
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")

          @personaltracker_settings.clickCancelButton()
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")
          !30.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1 }
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")
        end

        it ".dirty", :broken => true do
          @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
          !45.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1}
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")

          @personaltracker_list_screen.clickAddEntryButton()
          !45.times{ break if(getPrimaryHeader() == "Add Cholesterol/Lipid Entry"); sleep 1}
          expect(getPrimaryHeader()).to eq("Add Cholesterol/Lipid Entry")

          setInput('textarea[name="Note"]', "ABC")

          @personaltracker_settings.clickTheGearIcon()
          !30.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

          @modal.clickReturnButton()
          !15.times{ break if(getPrimaryHeader() == "Add Cholesterol/Lipid Entry"); sleep 1}
          expect(getPrimaryHeader()).to eq("Add Cholesterol/Lipid Entry")

          @personaltracker_settings.clickTheGearIcon()
          !30.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

          @modal.clickContinueButton()
          !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
          expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

          #Check the screen underneath the modal
          sleep 2
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")

          @personaltracker_settings.clickCancelButton()
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")
          !30.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1 }
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")
        end

      end

      context "Click settings from notification settings page" do

        it ".clean", :broken => true do
          @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
          !45.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1}
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")

          @personaltracker_list_screen.clickNotificationButton()
          !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "Lipids Notification"); sleep 1 }
          expect(@personaltracker_notification.getPrimaryHeader()).to eq("Lipids Notification")

          @personaltracker_settings.clickTheGearIcon()
          !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
          expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

          #Check the screen underneath the modal
          sleep 2
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")

          @personaltracker_settings.clickCancelButton()
          sleep 2
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")
          !30.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1 }
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")
        end

        it ".dirty", :broken => true do
          @navMenu.click(:css, Nav_menu::NAV["Lipids"]["navButton"])
          !45.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1}
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")

          @personaltracker_list_screen.clickNotificationButton()
          !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "Lipids Notification"); sleep 1 }
          expect(@personaltracker_notification.getPrimaryHeader()).to eq("Lipids Notification")

          @personaltracker_notification.clickOnRadioButton()

          @personaltracker_settings.clickTheGearIcon()
          sleep 2

          !30.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

          @modal.clickReturnButton()
          !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "Lipids Notification"); sleep 1 }
          expect(@personaltracker_notification.getPrimaryHeader()).to eq("Lipids Notification")

          @personaltracker_settings.clickTheGearIcon()
          sleep 2
          !30.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

          @modal.clickContinueButton()
          sleep 2
          !30.times{ break if (@personaltracker_settings.getHeading() == "Personal Trackers - Display Options"); sleep 1 }
          expect(@personaltracker_settings.getHeading()).to eq("Personal Trackers - Display Options")

          #Check the screen underneath the modal
          sleep 2
          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")
          @personaltracker_settings.clickCancelButton()
          sleep 2

          !30.times{ break if(getSecondaryHeader() == "Personal Trackers"); sleep 1 }
          expect(getSecondaryHeader()).to eq("Personal Trackers")
          !30.times{ break if(getPrimaryHeader() == "Cholesterol/Lipid"); sleep 1 }
          expect(getPrimaryHeader()).to eq("Cholesterol/Lipid")
        end

      end

    end

  end

  def setInAppEmailNotifications(screenName, screenTitle, screenNotificationTitle)
      expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
      !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (Off)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (Off)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (Off)")

      @personaltracker_list_screen.clickNotificationButton()
      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
      !30.times{ break if(isElementPresentAndVisible(:css, 'form[name="form"]')); sleep 1 }
      expect(isElementPresentAndVisible(:css, 'form[name="form"]')).to eq(true)

      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @personaltracker_notification.clickOnRadioButton()

      !10.times{ break if(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE) == false); sleep 1 }
      expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(false)

      @personaltracker_notification.setInput(PersonalTracker_Notification::START_DATE, tomorrow)
      @personaltracker_notification.setSelectBoxValue(PersonalTracker_Notification::FREQUENCY, "Weekly")
      @personaltracker_notification.setInput(PersonalTracker_Notification::TIME0, "01:00 PM")

      #--By default, In-app box is checked.
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      @personaltracker_notification.clickSaveButton()
      !45.times{ break if (@personaltracker_list_screen.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_list_screen.getFocusedElementText()).to eq(screenTitle)

      expect(getCount()).to eq(1)

      !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (On)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (On)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (On)")
  end

  def determineScreenNotificationTitle(screenName, screenTitle)
    # For the most part, notification screen title is same as the personal
    # tracker title.  Exception is Glucose and Lipids
    if screenName == "Glucose" or screenName == "Lipids"
      return screenName
    else
      return screenTitle
    end
  end

end
