require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1524: Personal Trackers Notifications]", :broken => true, :acceptance => true do

  before(:all) do

    #-- The notification screen for each personal tracker
    @NOTIFICATION_SCREEN = [
      "Notification:",
      "Status:",
      "On",
      "Off",
      "Start Date:",
      "MM/DD/YYYY",
      "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
      "Notify Me:",
      "Select",
      "Daily",
      "Weekly",
      "Monthly",
      "Notification Time:",
      "hh:mm AM/PM",
      "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
      "Notification Delivery:",
      "In-App",
      "Email",
      "email910@gmail.com",
      "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
      "You may update your Preferred Email address in the Notification feature by selecting the icon.",
      "Save Cancel",
    ]

    #-- The notification section at the bottom of each personal tracker add/edit screen
    @NOTIFICATION_SECTION = [
        "Notification:",
        "Status: $NOTIFICATION_STATUS$",
        "",
        "To edit the $SCREEN_NAME$ tracker notification, select the Notification button on the previous screen.",
        "Save Delete Cancel"
    ]

    #-- Generic add procedure code
    @addProcedureCode = Proc.new do | screenName, screenTitle, requiredFields|
      puts "  Adding personal tracker in (#{screenTitle})"

      @common.clickAddButton()

      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Add #{screenTitle} Entry"); sleep 1 }
      expect(@personaltracker_form.getPrimaryHeader()).to eq("Add #{screenTitle} Entry")

      requiredFields.each_with_index do | codeblock, i |
          codeblock.call()
      end

      verifyNotificationSection(screenName, "Off")

      @personaltracker_form.clickSaveButton()
    end

    #-- Array that holds the add routine for each of the personal trackers
    @addArray = {
      "BloodPressureandPulse" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Systolic","120")} ,
          Proc.new {setKeyboardField("Diastolic","100")} ,
          Proc.new {setKeyboardField("Pulse","150")}
        ]
      },
      "Lipids" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Total Serum Cholesterol","400")} ,
          Proc.new {setKeyboardField("Low-Density Lipoprotein (LDL)","100")} ,
          Proc.new {setKeyboardField("High-Density Lipoprotein (HDL)","150")} ,
          Proc.new {setKeyboardField("Triglycerides","300")},
          Proc.new {setSelectBoxValue("select[name='fasting']", "Yes")}
        ]
      },
      "DailyEvents" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("eventTitle", "A spectacular event")}
        ]
      },
      "Diet"    => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("mealType", "Snack")},
          Proc.new {setKeyboardField("caloriesInput","100")},
          Proc.new {setKeyboardField("fatInput","200")},
          Proc.new {setKeyboardField("carbInput","300")},
          Proc.new {setKeyboardField("proteinInput","400")}
        ]
      },
      "Exercise" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setSelectField("activityInput", "Walking")},
          Proc.new {setKeyboardField("durationInput", "60")}
        ]
      },
      "Glucose" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setInput(Glucose::GLUCOSE_LEVEL, "200")} ,
          Proc.new {setSelectBoxValue(Glucose::TESTED, "After Meal")}
        ]
      },
      "Height" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Height", "75")}
        ]
      },
      "Mood"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Pain"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Respiration" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Respiration", "40")}
        ]
      },
      "Sleep"    => {
        "proc"  => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setInput(Sleep::STARTDATE, getDateNthDaysAgo(1, "%m/%d/%Y"))} ,
          Proc.new {setInput(Sleep::STARTTIME, "06:00 AM")} ,
          Proc.new {setInput(Sleep::ENDDATE, getDateNthDaysAgo(1, "%m/%d/%Y"))} ,
          Proc.new {setInput(Sleep::ENDTIME, "06:00 PM")}
        ]
      },
      "Stress"    => {
        "proc"  => @addProcedureCode,
          "requiredFields" => []
      },
      "Temperature" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Temperature", "98")}
        ]
      },
      "Weight" => {
        "proc" => @addProcedureCode,
        "requiredFields" => [
          Proc.new {setKeyboardField("Weight", "98")}
        ]
      },
    }

    initializeConfigurations(BASE_URL)
    removeCollection("notifications", "notificationsdb")
    removeCollection("notificationPreferences", "notificationsdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickNotifications()
    sleep 1

    @notification.clickTheGearIcon()
    #time zone
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    selectTimeZone("(+01:00) CET (Central European Time)")

    #email address verification
    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("email910@gmail.com")
    expect(@landing.preferredEmailInstructionalText()).to eq("Your Preferred email for notifications applies to all VA Health apps.")
    expect(@notification.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    @modal.clickSaveButton()
    sleep 1

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    #Clear all data
    removeCollection("chemlabs", "medicalhistorydb")
    removeCollection("chemlabsbundles", "medicalhistorydb")
    removeCollection("stress", "medicalhistorydb")
    removeCollection("sleep", "medicalhistorydb")
    removeCollection("reminders", "remindersdb")
    removeCollection("notes", "medicalhistorydb")
    removeCollection("diet", "healthfactordb")
    removeCollection("fitness", "healthfactordb")
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")
    removeCollection("mood", "medicalhistorydb")
  end

  after(:all) do
    quitDriver()
  end

  describe "Story #JRNL-1524: Personal Trackers Notifications" do

    it "" do

      #-- Go through all menus and submenus
      Nav_menu::NAV.each_with_index do | item, i|

        #-- Process only Personal Trackers submenus
        if item[1]["dependsOn"] == "PersonalTrackers"
          screenName = item[0]

            #--Navigate to the personal tracker screen (list/filter view)
            @navMenu.click(:css, item[1]["navButton"])
            sleep 2.0

            screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
            !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
            expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

            #--Add a personal tracker record
            @addArray[screenName]["proc"].call(screenName, screenTitle, @addArray[screenName]["requiredFields"])

            #--Select record just added
            sleep 3
            clickNthRow(1)
            !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Edit #{screenTitle} Entry"); sleep 1 }
            expect(@personaltracker_form.getPrimaryHeader()).to eq("Edit #{screenTitle} Entry")

            #--Verify Notification Status on the edit screen
            verifyNotificationSection(screenName,"Off")

            #--Cancel to return to list/filter view
            @personaltracker_form.clickCancelButton()

            screenNotificationTitle = determineScreenNotificationTitle(screenName, screenTitle)

            verifyNotificationsFields(screenName, screenTitle, screenNotificationTitle)
            verifyInAppNotification(screenName, screenTitle, screenNotificationTitle)
            verifyEmailNotification(screenName, screenTitle, screenNotificationTitle)

            #--Verify Notification Section in tracker is On
            clickNthRow(1)
            !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Edit #{screenTitle} Entry"); sleep 1 }
            expect(@personaltracker_form.getPrimaryHeader()).to eq("Edit #{screenTitle} Entry")

            verifyNotificationSection(screenName,"On")
            @personaltracker_form.clickCancelButton()

            #--Disable Notification in Notification record for the tracker
            disableNotification(screenName, screenTitle, screenNotificationTitle)

            #--Verify Notification Section in tracker is Off
            clickNthRow(1)
            !45.times{ break if (@personaltracker_form.getPrimaryHeader() == "Edit #{screenTitle} Entry"); sleep 1 }
            expect(@personaltracker_form.getPrimaryHeader()).to eq("Edit #{screenTitle} Entry")

            verifyNotificationSection(screenName,"Off")
            @personaltracker_form.clickCancelButton()
        end

      end

      #-- Verify that if email address is not provided in Notifications Settings
      #-- screen, Email checkbox in tracker notifications screen is disabled
      clearNotificationSettingEmail()
      verifyEmailCheckboxIsDisabled()

    end

  end

  def verifyNotificationSection(screenName, notification_status)

    puts "  AC JRNL-1432| TC:JRNL-1414: Detail Screen (Add or Edit)"
    puts "    verify Notification Section screen (#{screenName}) is #{notification_status}"
      startCompare = false
      j = 0
      @personaltracker_form.getFormContent().split("\n").each_with_index do | screenRow, i |
        if (screenRow == "Notifications:" )
          startCompare = true
        end

        if startCompare
          expectedLine = @NOTIFICATION_SECTION[j].sub("$SCREEN_NAME$", screenName).sub("$NOTIFICATION_STATUS$", notification_status)
          expect(screenRow).to eq(expectedLine)
          j = j + 1
        end

      end

  end

  def verifyNotificationsFields(screenName, screenTitle, screenNotificationTitle)

    puts "  AC JRNL-1433| TC:JRNL-1414: Notification Button"
    puts "      Content"
      expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
    !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (Off)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (Off)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (Off)")

      @personaltracker_list_screen.clickNotificationButton()

    puts "  AC JRNL-1431| TC:JRNL-1414: Display of Notification Page"
      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
      sleep 2.0

      @personaltracker_notification.getScreenContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@NOTIFICATION_SCREEN[i])
      end

    puts "      Required"
      expect(@personaltracker_notification.isFieldRequired(:css, PersonalTracker_Notification::START_DATE)).to eq(false)
      expect(@personaltracker_notification.isFieldRequired(:css, PersonalTracker_Notification::FREQUENCY)).to eq(false)
      expect(@personaltracker_notification.isFieldRequired(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY)).to eq(false)

      @personaltracker_notification.clickOnRadioButton()
      expect(@personaltracker_notification.isFieldRequired(:css, PersonalTracker_Notification::START_DATE)).to eq(true)
      expect(@personaltracker_notification.isFieldRequired(:css, PersonalTracker_Notification::FREQUENCY)).to eq(true)

      #--By default, In-app box is checked, toggle it.
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)
      click(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

    puts "      Error Messages"
      expectedValidationSummaryHeader = "The following errors were found:"

      @personaltracker_notification.clickSaveButton()
      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Notify Me field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Notification Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Duplicate notification times are not permitted.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)

      @personaltracker_notification.setInput(PersonalTracker_Notification::START_DATE, "11/01")
      @personaltracker_notification.setSelectBoxValue(PersonalTracker_Notification::FREQUENCY, "Daily")
      @personaltracker_notification.setInput(PersonalTracker_Notification::TIME0, "10:00 AM")
      @personaltracker_notification.click(:css, PersonalTracker_Notification::ADD_TIME_BUTTON)
      @personaltracker_notification.setInput(PersonalTracker_Notification::TIME1, "10:00 AM")
      @personaltracker_notification.click(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)

      @personaltracker_notification.clickSaveButton()
      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Notify Me field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Notification Time field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Duplicate notification times are not permitted.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(false)

      @personaltracker_notification.clickCancelButton()
  end

  def verifyInAppNotification(screenName, screenTitle, screenNotificationTitle)

    puts "    AC JRNL-1430 Receive In-App Notification for Personal Trackers Notfication for screen (#{screenTitle})"
    puts "      Save"
      expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
    !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (Off)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (Off)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (Off)")

      @personaltracker_list_screen.clickNotificationButton()

      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
      sleep 2.0
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @personaltracker_notification.clickOnRadioButton()

      expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(false)
      @personaltracker_notification.setInput(PersonalTracker_Notification::START_DATE, tomorrow)
      @personaltracker_notification.setSelectBoxValue(PersonalTracker_Notification::FREQUENCY, "Weekly")
      @personaltracker_notification.setInput(PersonalTracker_Notification::TIME0, "01:00 PM")

      #--By default, In-app box is checked
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      @personaltracker_notification.clickSaveButton()

      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)

      expect(getCount()).to eq(1)

    !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (On)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (On)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (On)")

    puts "      Verify Saved Data"
      @personaltracker_list_screen.clickNotificationButton()
      sleep 2.0
      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")

      expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(true)
      expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq(tomorrow)
      expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Weekly")
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      @personaltracker_notification.clickSaveButton()

  end

  def verifyEmailNotification(screenName, screenTitle, screenNotificationTitle)

    puts "    AC JRNL-1429 Receive Email Notification for Personal Trackers Notfication for screen (#{screenTitle})"
    puts "      Update Notification Delivery To Email"
      expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
    !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (On)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (On)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (On)")

      @personaltracker_list_screen.clickNotificationButton()
      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
      sleep 1
      click(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)
      sleep 1
      !45.times{ break if (getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected? == true); sleep 1 }
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)

      @personaltracker_notification.clickSaveButton()

      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)

      expect(getCount()).to eq(1)

    puts "      Verify Saved Data"
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
    !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (On)"); sleep 1 }
      expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (On)")
      expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (On)")

      @personaltracker_list_screen.clickNotificationButton()

      !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
      expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
      sleep 2.0
      expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq(tomorrow)
      expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Weekly")
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      puts "  AC JRNL-1428| TC:JRNL-1414: Navigation for Personal Trackers"
      expect(@personaltracker_notification.getBackButtonAltText()).to eq( "Return to Previous Screen")
      @personaltracker_notification.clickBackButton()

      !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
      expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)

  end

  def disableNotification(screenName, screenTitle, screenNotificationTitle)

      puts "    disableNotification for (#{screenTitle})"
        @personaltracker_list_screen.clickNotificationButton()

        !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
        expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")

        #-- Disable tracker status
        sleep 2.0
        @personaltracker_notification.clickOffRadioButton()
        sleep 2.0

        #-- Verify all the fields are nullified and disabled
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::FREQUENCY)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)

        expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq("")
        expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Select")
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

        #-- Enable tracker status
        @personaltracker_notification.clickOnRadioButton()
        sleep 2.0

        #-- Verify all the fields are enabled but blank, except In-App which defaults to checked
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(false)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::FREQUENCY)).to eq(false)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(false)

        expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq("")
        expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Select")
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

        #-- Try entering invalid data
        today = getDateNthDaysAgo(1, "%m/%d/%Y")
        @personaltracker_notification.setInput(PersonalTracker_Notification::START_DATE, today)
        @personaltracker_notification.setSelectBoxValue(PersonalTracker_Notification::FREQUENCY, "Monthly")
        click(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)
        click(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)
        sleep 1

        !45.times{ break if (getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected? == true); sleep 1 }
        @personaltracker_notification.clickSaveButton()

        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        expectedValidationSummaryHeader = "The following errors were found:"
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Start Date must be between #{today} and 12/31/2099.")).to eq(true)

        #-- Enter valid data
        today = getDateNthDaysFromNow(0, "%m/%d/%Y")
        @personaltracker_notification.setInput(PersonalTracker_Notification::START_DATE, today)
        sleep 1
        !45.times{ break if (getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected? == true); sleep 1 }

        #-- Verify fields are populated with new data
        expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq(today)
        expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Monthly")
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

        #-- Disable tracker status
        @personaltracker_notification.clickOffRadioButton()
        sleep 2.0

        #-- Verify all the fields are nullified and disabled
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::FREQUENCY)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)

        expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq("")
        expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Select")
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

        #-- Save blank (disabled) notification
        @personaltracker_notification.clickSaveButton()

        !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
        expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)

        expect(@personaltracker_list_screen.isElementVisible(:css, PersonalTrackers::NOTIFICATION_ICON)).to eq(true)
      !45.times{ break if (@personaltracker_list_screen.getNotificationButtonLabel() == "Notification (Off)"); sleep 1 }
        expect(@personaltracker_list_screen.getNotificationButtonLabel()).to eq("Notification (Off)")
        expect(@personaltracker_list_screen.getNotificationButtonAltText()).to eq("Notification (Off)")

        #-- Reopen it and verify all the fields are still nullified and disabled
        @personaltracker_list_screen.clickNotificationButton()

        !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
        expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")

        !30.times{ break if(isElementVisible(:css, "div.page.row entry-form")); sleep 1 }
        expect(isElementVisible(:css, "div.page.row entry-form")).to eq(true)

        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::FREQUENCY)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
        expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)

        expect(@personaltracker_notification.getTextFromInput(:css, PersonalTracker_Notification::START_DATE)).to eq("")
        expect(@personaltracker_notification.getSelectBoxText(PersonalTracker_Notification::FREQUENCY)).to eq("Select")
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
        expect(getElement(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

        @personaltracker_notification.clickSaveButton()
        !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
        expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)

  end

  def clearNotificationSettingEmail()

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickNotifications()
    sleep 1

    @notification.clickTheGearIcon()

    #email address verification
    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("")

    #-- Click save and then click Yes to second warning prompt about empty email address
    @modal.clickSaveButton()
    sleep 2.0
    @modal.clickSaveButton()
    sleep 1

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

  end


  def verifyEmailCheckboxIsDisabled()

    Nav_menu::NAV.each_with_index do | item, i|

      if item[1]["dependsOn"] == "PersonalTrackers"
        screenName = item[0]

        #-- Only check one tracker
        if screenName == "Stress"
          #--Navigate to the personal tracker screen (list/filter view)
          @navMenu.click(:css, item[1]["navButton"])
          sleep 2.0

          screenTitle = getTextForElement(:css, item[1]["navButton"]).sub("\nselected","")
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getPrimaryHeader()).to eq(screenTitle)

          screenNotificationTitle = determineScreenNotificationTitle(screenName, screenTitle)

          #-- Go to Notification Screen for that Tracker
          @personaltracker_list_screen.clickNotificationButton()
          !45.times{ break if (@personaltracker_notification.getPrimaryHeader() == "#{screenNotificationTitle} Notification"); sleep 1 }
          expect(@personaltracker_notification.getPrimaryHeader()).to eq("#{screenNotificationTitle} Notification")
          sleep 2.0

          #-- Turn on Notification
          @personaltracker_notification.clickOnRadioButton()
          sleep 2.0

          #-- Verify all fields are enabled except for email checkbox which is disabled because email address field is blank
          expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::START_DATE)).to eq(false)
          expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::FREQUENCY)).to eq(false)
          expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
          expect(@personaltracker_notification.isFieldDisabled(PersonalTracker_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)

          @personaltracker_notification.clickCancelButton()
          !45.times{ break if (@personaltracker_form.getPrimaryHeader() == screenTitle); sleep 1 }
          expect(@personaltracker_form.getFocusedElementText()).to eq(screenTitle)
        end

      end

    end

  end

  def determineScreenNotificationTitle(screenName, screenTitle)
    # For the most part, notification screen title is same as the personal
    # tracker title.  Exception is Glucose and Lipids
    if screenName == "Glucose" or screenName == "Lipids"
      return screenName
    else
      return screenTitle
    end
  end

end
