require_relative '../../globalized'
include Globalized

########################################################################################################################
########################################################################################################################
############ When running this script make sure to not do anything else on your machine or this script will fail. ######
########################################################################################################################

describe "[ Story#  JRNL-962; PersonalTrackers_JRNL_962_JRNL_3481_spec.rb" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects


    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

  end

  after (:all) do
    quitDriver()
  end

  context "JRNL-962 undefined and NaN should not show in textfields tested below " do

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Blood Pressure" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickBloodPressureAndPulse
      @personal_trackers.clickAddEntryButton()
      waitForPageToFinishLoading

      @bloodPressureAndPulse.setNote("Test")
      @bloodPressureAndPulse.setSystolic("")
      @bloodPressureAndPulse.setDiastolic("")
      @bloodPressureAndPulse.setPulse("")
      @bloodPressureAndPulse.setNote("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::SYSTOLIC_TEXTFIELD)).to_not eq("undefined")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DIASTOLIC_TEXTFIELD)).to_not eq("undefined")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::PULSE_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @bloodPressureAndPulse.setSystolic("a")
      @bloodPressureAndPulse.setDiastolic("a")
      @bloodPressureAndPulse.setPulse("a")
      @bloodPressureAndPulse.setNote("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::SYSTOLIC_TEXTFIELD)).to_not eq("NaN")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DIASTOLIC_TEXTFIELD)).to_not eq("NaN")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::PULSE_TEXTFIELD)).to_not eq("NaN")

      @bloodPressureAndPulse.setSystolic("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @bloodPressureAndPulse.setDiastolic("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @bloodPressureAndPulse.setPulse("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @bloodPressureAndPulse.setNote("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::SYSTOLIC_TEXTFIELD)).to eq("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DIASTOLIC_TEXTFIELD)).to eq("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::PULSE_TEXTFIELD)).to eq("")

      @bloodPressureAndPulse.setSystolic("1234567890.")
      @bloodPressureAndPulse.setDiastolic("1234567890.")
      @bloodPressureAndPulse.setPulse("1234567890.")
      @bloodPressureAndPulse.setNote("")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::SYSTOLIC_TEXTFIELD)).to eq("1234567890.0")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DIASTOLIC_TEXTFIELD)).to eq("1234567890.0")
      expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::PULSE_TEXTFIELD)).to eq("1234567890.0")

      @bloodPressureAndPulse.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Cholesterol" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickCholesterolLipid
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @cholesterolLipid.setNote("Test")
      @cholesterolLipid.setTotalSerumCholesterol("")
      @cholesterolLipid.setLowDensityLipoprotein("")
      @cholesterolLipid.setHighDensityLipoprotein("")
      @cholesterolLipid.setTotalTriglycerides("")
      @cholesterolLipid.setNote("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_SERUM_CHOLESTEROL_TEXTFIELD)).to_not eq("undefined")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::LOW_DENSITY_LIPOPROTEIN_TEXTFIELD)).to_not eq("undefined")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD)).to_not eq("undefined")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_TRIGLYCERIDES_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @cholesterolLipid.setTotalSerumCholesterol("a")
      @cholesterolLipid.setLowDensityLipoprotein("a")
      @cholesterolLipid.setHighDensityLipoprotein("a")
      @cholesterolLipid.setTotalTriglycerides("a")
      @cholesterolLipid.setNote("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_SERUM_CHOLESTEROL_TEXTFIELD)).to_not eq("NaN")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::LOW_DENSITY_LIPOPROTEIN_TEXTFIELD)).to_not eq("NaN")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD)).to_not eq("NaN")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_TRIGLYCERIDES_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @cholesterolLipid.setTotalSerumCholesterol("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @cholesterolLipid.setLowDensityLipoprotein("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @cholesterolLipid.setHighDensityLipoprotein("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @cholesterolLipid.setTotalTriglycerides("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @cholesterolLipid.setNote("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_SERUM_CHOLESTEROL_TEXTFIELD)).to eq("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::LOW_DENSITY_LIPOPROTEIN_TEXTFIELD)).to eq("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD)).to eq("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_TRIGLYCERIDES_TEXTFIELD)).to eq("")

      waitForPageToFinishLoading
      @cholesterolLipid.setTotalSerumCholesterol("1234567890.")
      @cholesterolLipid.setLowDensityLipoprotein("1234567890.")
      @cholesterolLipid.setHighDensityLipoprotein("1234567890.")
      @cholesterolLipid.setTotalTriglycerides("1234567890.")
      @cholesterolLipid.setNote("")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_SERUM_CHOLESTEROL_TEXTFIELD)).to eq("1234567890.0")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::LOW_DENSITY_LIPOPROTEIN_TEXTFIELD)).to eq("1234567890.0")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD)).to eq("1234567890.0")
      expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::TOTAL_TRIGLYCERIDES_TEXTFIELD)).to eq("1234567890.0")

      @cholesterolLipid.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Diet" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickDiet
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @diet.setNote("Test")
      @diet.selectBoxMeallType("Breakfast")
      @diet.setCalories("")
      @diet.setFat("")
      @diet.setCarb("")
      @diet.setProtein("")
      @diet.setNote("")
      expect(@diet.getTextFromInput(:css, Diet::CALORIES)).to_not eq("undefined")
      expect(@diet.getTextFromInput(:css, Diet::FAT)).to_not eq("undefined")
      expect(@diet.getTextFromInput(:css, Diet::CARBS_TEXTFIELD)).to_not eq("undefined")
      expect(@diet.getTextFromInput(:css, Diet::PROTEIN_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @diet.setCalories("a")
      @diet.setFat("a")
      @diet.setCarb("a")
      @diet.setProtein("a")
      @diet.setNote("")
      expect(@diet.getTextFromInput(:css, Diet::CALORIES)).to_not eq("NaN")
      expect(@diet.getTextFromInput(:css, Diet::FAT)).to_not eq("NaN")
      expect(@diet.getTextFromInput(:css, Diet::CARBS_TEXTFIELD)).to_not eq("NaN")
      expect(@diet.getTextFromInput(:css, Diet::PROTEIN_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @diet.setCalories("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @diet.setFat("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @diet.setCarb("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @diet.setProtein("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @diet.setNote("")
      expect(@diet.getTextFromInput(:css, Diet::CALORIES)).to eq("")
      expect(@diet.getTextFromInput(:css, Diet::FAT)).to eq("")
      expect(@diet.getTextFromInput(:css, Diet::CARBS_TEXTFIELD)).to eq("")
      expect(@diet.getTextFromInput(:css, Diet::PROTEIN_TEXTFIELD)).to eq("")

      waitForPageToFinishLoading
      @diet.setCalories("1234567890.")
      @diet.setFat("1234567890.")
      @diet.setCarb("1234567890.")
      @diet.setProtein("1234567890.")
      @diet.setNote("")
      expect(@diet.getTextFromInput(:css, Diet::CALORIES)).to eq("1234567890.0")
      expect(@diet.getTextFromInput(:css, Diet::FAT)).to eq("1234567890.0")
      expect(@diet.getTextFromInput(:css, Diet::CARBS_TEXTFIELD)).to eq("1234567890.0")
      expect(@diet.getTextFromInput(:css, Diet::PROTEIN_TEXTFIELD)).to eq("1234567890.0")

      @diet.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Execise" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickExercise
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @exercise.setNote("Test")
      @exercise.selectActivity("Walking")
      @exercise.setDuration("")
      @exercise.setDistance("")
      @exercise.setNote("")
      expect(@exercise.getTextFromInput(:css, Exercise::DURATION_TEXTFIELD)).to_not eq("undefined")
      expect(@exercise.getTextFromInput(:css, Exercise::DISTANCE_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @exercise.setDuration("a")
      @exercise.setDistance("a")
      @exercise.setNote("")
      expect(@exercise.getTextFromInput(:css, Exercise::DURATION_TEXTFIELD)).to_not eq("NaN")
      expect(@exercise.getTextFromInput(:css, Exercise::DISTANCE_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @exercise.setDuration("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @exercise.setDistance("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @exercise.setNote("")
      expect(@exercise.getTextFromInput(:css, Exercise::DURATION_TEXTFIELD)).to eq("")
      expect(@exercise.getTextFromInput(:css, Exercise::DISTANCE_TEXTFIELD)).to eq("")

      waitForPageToFinishLoading
      @exercise.setDuration("1234567890.")
      @exercise.setDistance("1234567890.")
      @exercise.setNote("")
      expect(@exercise.getTextFromInput(:css, Exercise::DURATION_TEXTFIELD)).to eq("1234567890.0")
      expect(@exercise.getTextFromInput(:css, Exercise::DISTANCE_TEXTFIELD)).to eq("1234567890.0")

      @exercise.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Glucose" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickGlucose
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @glucose.setNote("Test")
      @glucose.setGlucoseLevel("")
      @glucose.setNote("")
      expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to_not eq("undefined")

      waitForPageToFinishLoading
      @glucose.setGlucoseLevel("a")
      @glucose.setNote("")
      expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to_not eq("NaN")

      waitForPageToFinishLoading
      @glucose.setGlucoseLevel("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @glucose.setNote("")
      expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("")

      waitForPageToFinishLoading
      @glucose.setGlucoseLevel("1234567890.")
      @glucose.setNote("")
      expect(@glucose.getTextFromInput(:css, Glucose::GLUCOSE_LEVEL)).to eq("1234567890.0")

      @glucose.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Respiration" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickRespiration
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @respiration.setNote("Test")
      @respiration.setRespiration("")
      @respiration.setNote("")
      expect(@respiration.getTextFromInput(:css, Respiration::RESPIRATION_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @respiration.setRespiration("a")
      @respiration.setNote("")
      expect(@respiration.getTextFromInput(:css, Respiration::RESPIRATION_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @respiration.setRespiration("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @respiration.setNote("")
      expect(@respiration.getTextFromInput(:css, Respiration::RESPIRATION_TEXTFIELD)).to eq("")


      waitForPageToFinishLoading
      @respiration.setRespiration("1234567890.")
      @respiration.setNote("")
      expect(@respiration.getTextFromInput(:css, Respiration::RESPIRATION_TEXTFIELD)).to eq("1234567890.0")


      @respiration.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Temperature" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickTemperature
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @temperature.setNote("Test")
      @temperature.setTemperature("")
      @temperature.setNote("")
      expect(@temperature.getTextFromInput(:css, Temperature::TEMPERATURE_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @temperature.setTemperature("a")
      @temperature.setNote("")
      expect(@temperature.getTextFromInput(:css, Temperature::TEMPERATURE_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @temperature.setTemperature("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @temperature.setNote("")
      expect(@temperature.getTextFromInput(:css, Temperature::TEMPERATURE_TEXTFIELD)).to eq("")

      waitForPageToFinishLoading
      @temperature.setTemperature("1234567890.")
      @temperature.setNote("")
      expect(@temperature.getTextFromInput(:css, Temperature::TEMPERATURE_TEXTFIELD)).to eq("1234567890.0")

      @temperature.clickCancelButtonJump
    end

    it "JRNL-962 The undefined and NaN errors that show up in the free-text entry screens under Personal Trackers-Weight" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickWeight
      @personal_trackers.clickAddEntryButton()

      waitForPageToFinishLoading
      @weight.setNote("Test")
      @weight.setWeight("")
      @weight.setNote("")
      expect(@weight.getTextFromInput(:css, Weight::WEIGHT_TEXTFIELD)).to_not eq("undefined")

      waitForPageToFinishLoading
      @weight.setWeight("a")
      @weight.setNote("")
      expect(@weight.getTextFromInput(:css, Weight::WEIGHT_TEXTFIELD)).to_not eq("NaN")

      waitForPageToFinishLoading
      @weight.setWeight("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz!@#$%^&*()")
      @weight.setNote("")
      expect(@weight.getTextFromInput(:css, Weight::WEIGHT_TEXTFIELD)).to eq("")

      waitForPageToFinishLoading
      @weight.setWeight("1234567890.")
      @weight.setNote("")
      expect(@weight.getTextFromInput(:css, Weight::WEIGHT_TEXTFIELD)).to eq("1234567890.0")

      @weight.clickCancelButtonJump
    end

    it "JRNL-3481 Angular Upgrade Regression Errors" do
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers
      @personaltracker.clickBloodPressureAndPulse
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump


      @personal_trackers.clickCholesterolLipid
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickDailyEvents
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickDiet
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickExercise
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickGlucose
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickHeight
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickMood
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickPain
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickRespiration
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickSleep
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickTemperature
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump

      @personaltracker.clickWeight
      waitForPageToFinishLoading
      @personaltracker.clickNotificationButton
      expect(@screening.getNotificationStatus).to eq("Off")
      @personaltracker_notification.clickOnRadioButton
      expect(@screening.getNotificationStatus).to eq("On")
      waitForPageToFinishLoading
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)
      @personaltracker_notification.clickOffRadioButton
      expect(@personaltracker_notification.isThisElementDisabled(:css, PersonalTracker_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)
      @personaltracker_notification.clickCancelButtonJump
    end
  end
end
