require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2510: Group Personal Trackers]", :regression =>true do

  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @feature = "Personal Trackers"
    @sections = ["Blood Pressure and Pulse", "Cholesterol/Lipid", "Daily Events", "Diet", "Exercise", "Glucose (Self Tested)", "Height", "Mood", "Pain", "Respiration", "Sleep", "Stress", "Temperature", "Weight"]

  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-2801|TC #JRNL-1868: Category Personal Trackers" do
    
    it ".navigation list has category" do
      @nav_menu.navigate("NavMenu")
      @nav_menu.isNavVisible(@feature)
    end

    it ".should have correct headers and and placeholder message", :broken => true do
      @nav_menu.navigate("PersonalTrackers")
      !45.times{ break if (getMainHeader() == @feature); sleep 1 }

      expect(getMainHeader()).to eq(@feature)

      #Verify the group navigation header
      expect(getSecondaryHeader()).to eq(@feature)
      #Verify the Table View header
      expect(getPrimaryHeader()).to eq(@feature)

      #Verify that when there are records in the list, the default message displayed as follow

      !45.times{ break if (getTextForElement(:css, @misc.defaultPlaceholderMessage) == "Select an item from the Personal Trackers list to view details or add a new Personal Tracker entry."); sleep 1 }
      expect(getTextForElement(:css, @misc.defaultPlaceholderMessage)).to eq("Select an item from the Personal Trackers list to view details or add a new Personal Tracker entry.")
    end

    it ".feature has list of tracker types and types have correct headers", :broken => true do
      #Verify Reminder group navigation options are available

      @sections.each_index { |i|
          sectionSelector = @misc.nthSectionButtonText(i + 1)
          expect(getTextForElement(:css, sectionSelector)).to eq(@sections[i])

          click(:css, sectionSelector)
          waitForPageToFinishLoading()

          expect(getPrimaryHeader()).to eq(@sections[i])
      }

    end

  end

end