require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1512: Personal Tracker Graph Titles]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)

    # Reset data for: "Glucose (Self Tested)"
    resetCollection("chemlabs", "medicalhistorydb", "glucose")
    # Delete data for: "Blood Pressure and Pulse", "Weight", "Temperature", "Respiration", "Height", and "Pain"
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")

    @SECTIONS = ["Blood Pressure and Pulse", "Weight", "Temperature", "Respiration", "Height", "Pain", "Glucose"]

    GRAPH_BTN = "button[title='Graph']"

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1406|TC JRNL-1401:" do

    it "Enter Data", :broken => true do
      enterData()
    end

    it "Verify Graph Titles", :broken => true do
      today = getDateNthDaysAgo(0, "%m/%d/%Y")
      twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
      fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
      thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

      for i in 0..(@SECTIONS.length - 1) do
        click(:css, Nav_menu::NAV[@SECTIONS[i].gsub(/\s+/, "")]["navButton"])
        !30.times{ break if(getPrimaryHeader().include?(@SECTIONS[i])); sleep 1 }
        if @SECTIONS[i] == "Glucose"
          expect(getPrimaryHeader()).to eq(@SECTIONS[i] + " (Self Tested)")
        else
          expect(getPrimaryHeader()).to eq(@SECTIONS[i])
        end

        @date_filter.setDateRangeAndFilter(thirtyDaysAgo, today)
        !10.times{ break if(getCount() > 0); sleep 1}
        expect(getCount()).to eq(1)

        clickGraphButton()
        !10.times{ break if(isElementVisible(:css, "div.reference-table-message"); sleep 1) }
        expect(getTextForElement(:css, "div.reference-table-message")).to eq("A text description of the information on this page is available in the table view.")

        puts @SECTIONS[i]

        expect(isGraphTitleDisplayed?()).to eq(true)
        if(@SECTIONS[i] == "Glucose")
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " (Self Tested) Values from " + thirtyDaysAgo + " to " + today)
        elsif(@SECTIONS[i] == "Pain")
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " Ratings from " + thirtyDaysAgo + " to " + today)
        else
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " Values from " + thirtyDaysAgo + " to " + today)
        end

        @date_filter.setDateRangeAndFilter(fifteenDaysAgo, twoDaysAgo)
        !10.times{ break if (getFocusedElementText().include?("A text description")); sleep 1 }
        expect(getFocusedElementText()).to eq("A text description of the information on this page is available in the table view.")

        expect(isGraphTitleDisplayed?()).to eq(true)
        if(@SECTIONS[i] == "Glucose")
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " (Self Tested) Values from " + fifteenDaysAgo + " to " + twoDaysAgo)
        elsif(@SECTIONS[i] == "Pain")
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " Ratings from " + fifteenDaysAgo + " to " + twoDaysAgo)
        else
          expect(getGraphTitle()).to eq(@SECTIONS[i] + " Values from " + fifteenDaysAgo + " to " + twoDaysAgo)
        end
      end
    end

  end

  ######################
  ### LOCAL FUNCTION ###
  ######################
  def enterData()
    fiveDaysAgo = getDateNthDaysAgo(5, "%m/%d/%Y")

    @BPP_DATA = [{"Systolic" => "200", "Diastolic" => "150", "Pulse" => "250", "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @WEIGHT_DATA = [{"Weight" => "190", "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @TEMPERATURE_DATE = [{"Temperature" => "99.9", "Type" => "Rectal",   "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @RESPIRATION_DATA = [{"Respiration" => "32", "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @HEIGHT_DATA = [{"Height" => "71", "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @PAIN_DATA = [{"pain" => 3, "date" => fiveDaysAgo, "time" => "10:00 AM"}]
    @DATA_ARRAY = [@BPP_DATA, @WEIGHT_DATA, @TEMPERATURE_DATE, @RESPIRATION_DATA, @HEIGHT_DATA, @PAIN_DATA]

    for i in 0..(@SECTIONS.length - 2) do
      click(:css, Nav_menu::NAV[@SECTIONS[i].gsub(/\s+/, "")]["navButton"])
      !30.times{ break if(getPrimaryHeader() == @SECTIONS[i]); sleep 1 }
      expect(getPrimaryHeader()).to eq(@SECTIONS[i])

      for j in 0..(@DATA_ARRAY[i].length - 1) do
        @entry_form.clickAddEntryButton()
        !30.times{ break if(getPrimaryHeader() == "Add " + @SECTIONS[i] + " Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add " + @SECTIONS[i] + " Entry")

        setEntryValues(@DATA_ARRAY[i][j])

        @entry_form.clickSaveButton()
        !30.times{ break if(getPrimaryHeader() == @SECTIONS[i]); sleep 1 }
        expect(getPrimaryHeader()).to eq(@SECTIONS[i])
      end
    end

    # The Glucose data is stored in mongo and thus must be updated separately
    updateDocument("chemlabs", "medicalhistorydb", "547ddd5d0364fb47fa752869", "recorded", (Time.now - 5.days))
  end

end
