require_relative '../../globalized'
include Globalized

describe "Story #JRNL-1436: Personal Trackers - Permit Graphing of Multiple Entries Per Day", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("vitalsigns", "medicalhistorydb")
    removeCollection("vitalsignsbundles", "medicalhistorydb")

    @yesterday = getDateNthDaysAgo(1, '%m/%d/%Y')
    @time1 = "10:00 AM"
    @time2 = "01:30 PM"

    @sectionHeaders = {
        "Blood Pressure and Pulse" => {"add" => "Add Blood Pressure and Pulse Entry", "summary" => "Blood Pressure and Pulse"},
        "Weight" => {"add" => "Add Weight Entry", "summary" => "Weight"},
        "Temperature" => {"add" => "Add Temperature Entry", "summary" => "Temperature"},
        "Pain" => {"add" => "Add Pain Entry", "summary" => "Pain"},
        "Respiration" => {"add" => "Add Respiration Entry", "summary" => "Respiration"},
        "Height" => {"add" => "Add Height Entry", "summary" => "Height"}
    }

    @addDataSet = {
        "Blood Pressure and Pulse" => [
            { "Systolic" => "200", "Diastolic" => "150", "Pulse" => "250", "date" => @yesterday, "time" => @time1 },
            { "Systolic" => "80", "Diastolic" => "50", "Pulse" => "40", "date" => @yesterday, "time" => @time2 }
        ],
        "Weight" => [
            { "Weight" => "999.9", "date" => @yesterday, "time" => @time1 },
            { "Weight" => "0", "date" => @yesterday, "time" => @time2 }
        ],
        "Temperature" => [
            { "Temperature" => "106", "date" => @yesterday, "time" => @time1 },
            { "Temperature" => "95", "date" => @yesterday, "time" => @time2 }
        ],
        "Pain" => [
            { "pain" => 10, "date" => @yesterday, "time" => @time1 },
            { "pain" => 0, "date" => @yesterday, "time" => @time2 }
        ],
        "Respiration" => [
            { "Respiration" => "60", "date" => @yesterday, "time" => @time1 },
            { "Respiration" => "4", "date" => @yesterday, "time" => @time2 }
        ],
        "Height" => [
            { "Height" => "96", "date" => @yesterday, "time" => @time1 },
            { "Height" => "0", "date" => @yesterday, "time" => @time2 }
        ]
    }

    @sections = ["Blood Pressure and Pulse", "Weight", "Temperature", "Pain", "Respiration", "Height"]

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after (:all) do
    quitDriver()
  end

  it "AC JRNL-1390|TC JRNL-1387: Plot Point Visibility", :broken => true do
    for i in 0..(@sections.length - 1)
      @metaData = {
          "baseNav" => @sections[i].gsub(/\s+/, ""),
          "orderedColumnsList" => [],
          "expectedHeaders" => @sectionHeaders[@sections[i]]
      }

      init(@metaData)

      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

      @nav_menu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")

      @nav_menu.click(:css, Nav_menu::NAV[@sections[i].gsub(/\s+/, "")]["navButton"])
      !45.times{ break if (getPrimaryHeader() == @sectionHeaders[@sections[i]]["summary"]); sleep 1 }
      expect(getPrimaryHeader()).to eq(@sectionHeaders[@sections[i]]["summary"])

      expect(getCount()).to eq(0)

      for j in 0..(@addDataSet[@sections[i]].length - 1)
        addEntry(@addDataSet[@sections[i]][j])
      end

      expect(getCount()).to eq(2)

      click(:css, graphButton())
      !30.times{ break if(isElementPresentAndVisible(:css, graphContainer())); sleep 1 }
      expect(isElementPresentAndVisible(:css, graphContainer())).to eq(true)

      # Blood Pressure and Pulse has 3 value fields (3 fields * 2 records = 6 points)
      if(@sections[i] == "Blood Pressure and Pulse")
        expect(getElements(:css, "g.highcharts-markers > path").length()).to eq(6)
      else
        expect(getElements(:css, "g.highcharts-markers > path").length()).to eq(2)
      end
    end
  end

end