require_relative '../../globalized'
include Globalized


describe "[ Story# NR-50, NR-98, Story JRNL-1334: Notifications_NR_50_98_spec]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    removeCollection("notificationPreferences", "notificationsdb")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-3053|JRNL-3069), TC(NR-429): Landing page notification count text' do
    it "Landing page notification count text" do
      @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

      expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")


      !5.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient05"); sleep 1}
      expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient05")
      !5.times{ break if(@landing.getNotificationButtonName() == "Notifications"); sleep 1 }
      expect(@landing.getNotificationButtonName()).to eq("Notifications")
      expect(@landing.notificationType()).to eq("Unread in last 30 days")
      expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
    end
  end

  context 'AC #JRNL-3070 | TC #NR-428: Learn more user guide link ' do
    it "Learn more user guide link ", :broken => true do
      @main.clickNavMenu
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='Notifications']").click
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default my-va-health-app-notices']").click
      waitForPageToFinishLoading
      @notifications_reminders.clickTheGearIcon()

      #NR-50: user guide link test
      waitForPageToFinishLoading
      @driver.find_element(:css, "a[ng-click='showUserGuide()']").click
      waitForPageToFinishLoading
      switchWindowToWindowHandleLast()
      !5.times{ break if (@userGuide.getUserGuideScreenHeader() == "My VA Health User Guide"); sleep 1 }
      expect(@userGuide.getUserGuideScreenHeader()).to eq("My VA Health User Guide")
      @userGuide.clickNotificationsLinkFromTableContents()
    end

    it "Story JRNL-1334 | AC JRNL-1161 | TC JRNL-1146: Update User Guide for 2.1", :broken => true do
      #Verify Notifications section title is displayed
      expect(@userGuide.getNotificationsContentTitle()).to eq("2.7 Notifications")

      expectedFirstParagraph = "Notifications include messages from two primary sources: the Veteran's Administration and My VA Health app."
      expectedListElements = "Veteran's Administration notifications include short messages, instructions, encouragements, and educational items on topics such as appointments, health and wellness tips, and suggestions to use other apps. Receipt of these notices is optional, and you may turn them off or on at any time." + "My VA Health notices include reminder messages that are generated by features of the app including the My Reminders feature, Assessments, and the Goals component of the My Story feature."
      expectedSecondParagraph = "You may update your Notifications preferences by selecting the Settings button (gear icon) inside the Notification feature. Setting options include your time zone preference, notification email address, and the ability to opt-in to health messages provided by the VA."
      expectedThirdParagraph = "When you log into the app, you will see a count of your unread notifications by clicking the Notification button on the landing page, or you may navigate to the Notification feature using the left navigation panel menu. To refine the view, you may filter the notification list by date range and read or unread status. All notifications are retained in the Notification feature list until you elect to remove them from the list using the Delete feature, which is accessed within the detailed view of the Notification itself."

      #Verify the Notifications content
      waitForPageToFinishLoading
      expect(@userGuide.getNotificationsFirstParaText()).to eq(expectedFirstParagraph)
      expect(@userGuide.getNotificationsListElements()).to eq(expectedListElements)
      expect(@userGuide.getNotificationsSecondParaText()).to eq(expectedSecondParagraph)
      expect(@userGuide.getNotificationsThirdParaText()).to eq(expectedThirdParagraph)
    end
  end
end










































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized


describe "[ Story# NR-50, NR-98, Story JRNL-1334: Notifications_NR_50_98_spec]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    removeCollection("notificationPreferences", "notificationsdb")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-3053|JRNL-3069), TC(NR-429): Landing page notification count text' do

    it "Landing page notification count text" do
      @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

      expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")


      !45.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient01"); sleep 1}
      expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
      !30.times{ break if(@landing.getNotificationButtonName() == "Notifications"); sleep 1 }
      expect(@landing.getNotificationButtonName()).to eq("Notifications")
      expect(@landing.notificationType()).to eq("Unread in last 30 days")
      expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
    end

  end

  context 'AC #JRNL-3070 | TC #NR-428: Learn more user guide link ' do

    it "Learn more user guide link ", :broken => true do
      @main.clickNavMenu
      @nav_menu.clickNotifications
      @notifications_reminders.clickTheGearIcon()

      #NR-50: user guide link test
      @modal.clickUserGuideLink()
      switchWindowToWindowHandleLast()
      !45.times{ break if (@userGuide.getUserGuideScreenHeader() == "My VA Health User Guide"); sleep 1 }
      expect(@userGuide.getUserGuideScreenHeader()).to eq("My VA Health User Guide")
      @userGuide.clickNotificationsLinkFromTableContents()
    end

    it "Story JRNL-1334 | AC JRNL-1161 | TC JRNL-1146: Update User Guide for 2.1", :broken => true do
      #Verify Notifications section title is displayed
      expect(@userGuide.getNotificationsContentTitle()).to eq("2.7 Notifications")

      expectedFirstParagraph = "Notifications include messages from two primary sources: the Veteran's Administration and My VA Health app."
      expectedListElements = "Veteran's Administration notifications include short messages, instructions, encouragements, and educational items on topics such as appointments, health and wellness tips, and suggestions to use other apps. Receipt of these notices is optional, and you may turn them off or on at any time." + "My VA Health notices include reminder messages that are generated by features of the app including the My Reminders feature, Assessments, and the Goals component of the My Story feature."
      expectedSecondParagraph = "You may update your Notifications preferences by selecting the Settings button (gear icon) inside the Notification feature. Setting options include your time zone preference, notification email address, and the ability to opt-in to health messages provided by the VA."
      expectedThirdParagraph = "When you log into the app, you will see a count of your unread notifications by clicking the Notification button on the landing page, or you may navigate to the Notification feature using the left navigation panel menu. To refine the view, you may filter the notification list by date range and read or unread status. All notifications are retained in the Notification feature list until you elect to remove them from the list using the Delete feature, which is accessed within the detailed view of the Notification itself."

      #Verify the Notifications content

      waitForPageToFinishLoading
      expect(@userGuide.getNotificationsFirstParaText()).to eq(expectedFirstParagraph)
      expect(@userGuide.getNotificationsListElements()).to eq(expectedListElements)
      expect(@userGuide.getNotificationsSecondParaText()).to eq(expectedSecondParagraph)
      expect(@userGuide.getNotificationsThirdParaText()).to eq(expectedThirdParagraph)
    end

  end

end
=end