require_relative '../../globalized'
include Globalized

describe "[ Story# NR-331, NR-332, #MVAH-1727: Notifications_NR_331_332_spec ] ", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    #deleteROAFromTable("D123401")
    removeCollection("notificationPreferences", "notificationsdb")
    initializeAllObjects
  end

  # after(:all) do
  #   # resetCollection("notifications", "notificationsdb", "notifications")
  #   quitDriver()
  # end

  #User story NR-331
  it "AC(NR-358|NR-359|NR-369), TC(NR-414|):Update opt in/out landing page feature to target External notifications ;", :broken => true  do
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
    waitForPageToFinishLoading
    !5.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
    waitForPageToFinishLoading
    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='Notifications']").click
    waitForPageToFinishLoading
    !5.times{ break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")

    @notifications.clickTheGearIcon()
    expect(@notifications.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    #verify that notification settings displays previously stored time zone
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("Yes")
    sleep 3
    expect(@notifications.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    selectTimeZone("(-05:00) America/New_York (Eastern)")
    sleep 1
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
    getDocumentByObjId("notificationPreferences", "notificationsdb", "53fb5fcf3004ceb84c943a6a", "Value")

    #@main.clickNavMenu
    @main.clickUserMenu
    !5.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    @menu.clickLogoutBtn()
    !5.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    gotoHome(BASE_URL)
  end

  #User story NR-332
  it "AC(NR-360|NR-361|NR-362|), TC(NR-414|):  Update Notification Settings feature ", :broken => true do
    !5.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")
    @loginpage.passingByTheLandingPage()
    !5.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !5.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
    !5.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient01"); sleep 1}
    expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
    expect(@landing.getNotificationButtonName()).to eq("Notifications")
    expect(@landing.notificationType()).to eq("Unread in last 30 days")
    expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")

    notificationType = @landing.notificationType()
    numberOfNotification = @landing.notificationCount()
    puts "Notifications " + notificationType + ": " + numberOfNotification
    expect(@landing.notificationInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
    @main.clickNavMenu()
    expect(@nav_menu.isNotificationsButtonVisible()).to eq(true)
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='Notifications']").click
    waitForPageToFinishLoading
    !5.times{ break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")
    @notifications.clickTheGearIcon()

    !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    expect(@modal.getInstructionalText()).to eq("Manage your Notification preferences by adjusting the settings options below. Note that notification settings apply to all VA health applications.")
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    expect(@modal.getAllTimeZone()).to eq("Select\n(+00:00) WET (Western European Time)\n(+01:00) CET (Central European Time)\n(+02:00) EET (Eastern European Time)\n(+04:00) Europe/Moscow\n(+04:00) Asia/Dubai\n(+04:30) Asia/Kabul\n(+05:00) Asia/Aqtau\n(+05:00) Asia/Aqtobe\n(+05:45) Asia/Kathmandu\n(+06:00) Asia/Almaty\n(+06:30) Asia/Rangoon\n(+07:00) Asia/Bangkok\n(+07:00) Asia/Jakarta\n(+08:00) Asia/Singapore\n(+09:00) Asia/Jayapura\n(+09:00) Asia/Tokyo\n(+11:00) Asia/Sakhalin\n(+10:00) Australia/Sydney\n(+12:00) Asia/Anadyr\n(+12:00) Antarctica/McMurdo\n(+12:00) Pacific/Fiji\n(+13:00) Pacific/Enderbury\n(+14:00) Pacific/Kiritimati\n(-01:00) Atlantic/Cape_Verde\n(-01:00) America/Scoresbysund\n(-03:00) America/Argentina/San_Juan\n(-04:00) America/Argentina/San_Luis\n(-05:00) America/New_York (Eastern)\n(-06:00) America/Chicago (Central)\n(-07:00) America/Denver (Mountain)\n(-08:00) America/Los_Angeles (Pacific)\n(-09:00) America/Juneau\n(-10:00) Pacific/Honolulu\n(-11:00) Pacific/Midway\n(+00:00) Etc/GMT+12")
    expect(@modal.receiveVAHealthMessages()) == "Receive VA Health Messages"

    @modal.clickCancelButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    @notifications.clickTheGearIcon()
    !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    selectTimeZone("(+02:00) EET (Eastern European Time)")
    sleep 1
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    @notifications.clickTheGearIcon()
    expect(@notifications.timeZoneOption(4)).to eq("(+02:00) EET (Eastern European Time)")
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    #verify that, notification settings displays previously stored time zone
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("Yes")
    !5.times{ break if (@notifications.timeZoneOption(4) == "(+02:00) EET (Eastern European Time)"); sleep 1 }

    expect(@notifications.timeZoneOption(4)).to  eq("(+02:00) EET (Eastern European Time)")
    #Saving time zone as default for next time testing
    selectTimeZone("(-05:00) America/New_York (Eastern)")
    sleep 1
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
    #opting out of notifications
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !5.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
  end
end











































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[ Story# NR-331, NR-332, #MVAH-1727: Notifications_NR_331_332_spec ] ", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    deleteROAFromTable("D123401")
    removeCollection("notificationPreferences", "notificationsdb")

    initializeAllObjects
  end

  after(:all) do
    # resetCollection("notifications", "notificationsdb", "notifications")
    quitDriver()
  end

  #User story NR-331
  it "AC(NR-358|NR-359|NR-369), TC(NR-414|):Update opt in/out landing page feature to target External notifications ;", :broken => true  do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    @loginpage.passingByTheLandingPage()
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteranAsFirstTimeUser("zztest.patient01")
    clickBackButtonOnBrowser
    waitForPageToFinishLoading
    @roa.clickNext()
    !45.times{ break if (getPageTitle() == "Review"); sleep 1 }
    @roa.clickVerify()

    waitForPageToFinishLoading
    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept

    waitForPageToFinishLoading
    !45.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
    expect(@landing.notificationWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
    expect(@landing.notificationInstructionText1stParagraphAfterLogin()).to eq("Notifications include Reminder notices you create in this app, as well as Health Messages that may be sent to you by the Veteran's Administration. While you may adjust your notification delivery preferences for individual reminders, you must elect to receive Health Messages from the Veteran's Administration.")
    expect(@landing.notificationInstructionText2ndParagraphAfterLogin()).to eq("As a first time user, please save your Notification Settings before using other app features. Note that notification settings apply to all VA health applications.")
    expect(@landing.notificationsAfterLogin()).to eq("Notification Settings")
    expect(@modal.getAllTimeZone()).to eq("Select\n(+00:00) WET (Western European Time)\n(+01:00) CET (Central European Time)\n(+02:00) EET (Eastern European Time)\n(+04:00) Europe/Moscow\n(+04:00) Asia/Dubai\n(+04:30) Asia/Kabul\n(+05:00) Asia/Aqtau\n(+05:00) Asia/Aqtobe\n(+05:45) Asia/Kathmandu\n(+06:00) Asia/Almaty\n(+06:30) Asia/Rangoon\n(+07:00) Asia/Bangkok\n(+07:00) Asia/Jakarta\n(+08:00) Asia/Singapore\n(+09:00) Asia/Jayapura\n(+09:00) Asia/Tokyo\n(+11:00) Asia/Sakhalin\n(+10:00) Australia/Sydney\n(+12:00) Asia/Anadyr\n(+12:00) Antarctica/McMurdo\n(+12:00) Pacific/Fiji\n(+13:00) Pacific/Enderbury\n(+14:00) Pacific/Kiritimati\n(-01:00) Atlantic/Cape_Verde\n(-01:00) America/Scoresbysund\n(-03:00) America/Argentina/San_Juan\n(-04:00) America/Argentina/San_Luis\n(-05:00) America/New_York (Eastern)\n(-06:00) America/Chicago (Central)\n(-07:00) America/Denver (Mountain)\n(-08:00) America/Los_Angeles (Pacific)\n(-09:00) America/Juneau\n(-10:00) Pacific/Honolulu\n(-11:00) Pacific/Midway\n(+00:00) Etc/GMT+12")
    expect(@landing.receiveNotificationsAfterLogin()).to eq("Receive messages to help improve your health:")
    expect(@modal.requiredFieldText()).to eq("* required field")
    #verify that, Receive notifications radio button is selected to "Yes"
    expect(@modal.isReceiveNotificationsSelected("Yes")).to eq(true)
    expect(@modal.isReceiveNotificationsSelected("No")).to eq(false)
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    selectTimeZone("(+01:00) CET (Central European Time)")
    sleep 3
    #Click the Save button
    click(:css, 'button[ng-click="save()"]')
    sleep 3
    #verify that notification settings displays the previously selected time zone
    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickNotifications()
    !45.times{ break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")

    @notifications.clickTheGearIcon()
    expect(@notifications.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    #verify that notification settings displays previously stored time zone
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("Yes")
    sleep 3
    expect(@notifications.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    selectTimeZone("(-05:00) America/New_York (Eastern)")
    sleep 1
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
    getDocumentByObjId("notificationPreferences", "notificationsdb", "53fb5fcf3004ceb84c943a6a", "Value")

    #@main.clickNavMenu
    @main.clickUserMenu
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    @menu.clickLogoutBtn()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    gotoHome(BASE_URL)
  end

  #User story NR-332
  it "AC(NR-360|NR-361|NR-362|), TC(NR-414|):  Update Notification Settings feature ", :broken => true do
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")
    @loginpage.passingByTheLandingPage()
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
    !45.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient01"); sleep 1}
    expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
    expect(@landing.getNotificationButtonName()).to eq("Notifications")
    expect(@landing.notificationType()).to eq("Unread in last 30 days")
    expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")

    notificationType = @landing.notificationType()
    numberOfNotification = @landing.notificationCount()
    puts "Notifications " + notificationType + ": " + numberOfNotification
    expect(@landing.notificationInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
    @main.clickNavMenu()
    expect(@nav_menu.isNotificationsButtonVisible()).to eq(true)
    @nav_menu.clickNotifications()
    !45.times{ break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")
    @notifications.clickTheGearIcon()

    !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    expect(@modal.getInstructionalText()).to eq("Manage your Notification preferences by adjusting the settings options below. Note that notification settings apply to all VA health applications.")
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    expect(@modal.getAllTimeZone()).to eq("Select\n(+00:00) WET (Western European Time)\n(+01:00) CET (Central European Time)\n(+02:00) EET (Eastern European Time)\n(+04:00) Europe/Moscow\n(+04:00) Asia/Dubai\n(+04:30) Asia/Kabul\n(+05:00) Asia/Aqtau\n(+05:00) Asia/Aqtobe\n(+05:45) Asia/Kathmandu\n(+06:00) Asia/Almaty\n(+06:30) Asia/Rangoon\n(+07:00) Asia/Bangkok\n(+07:00) Asia/Jakarta\n(+08:00) Asia/Singapore\n(+09:00) Asia/Jayapura\n(+09:00) Asia/Tokyo\n(+11:00) Asia/Sakhalin\n(+10:00) Australia/Sydney\n(+12:00) Asia/Anadyr\n(+12:00) Antarctica/McMurdo\n(+12:00) Pacific/Fiji\n(+13:00) Pacific/Enderbury\n(+14:00) Pacific/Kiritimati\n(-01:00) Atlantic/Cape_Verde\n(-01:00) America/Scoresbysund\n(-03:00) America/Argentina/San_Juan\n(-04:00) America/Argentina/San_Luis\n(-05:00) America/New_York (Eastern)\n(-06:00) America/Chicago (Central)\n(-07:00) America/Denver (Mountain)\n(-08:00) America/Los_Angeles (Pacific)\n(-09:00) America/Juneau\n(-10:00) Pacific/Honolulu\n(-11:00) Pacific/Midway\n(+00:00) Etc/GMT+12")
    expect(@modal.receiveVAHealthMessages()) == "Receive VA Health Messages"

    @modal.clickCancelButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    @notifications.clickTheGearIcon()
    !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    selectTimeZone("(+02:00) EET (Eastern European Time)")
    sleep 1
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    @notifications.clickTheGearIcon()
    expect(@notifications.timeZoneOption(4)).to eq("(+02:00) EET (Eastern European Time)")
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }

    #verify that, notification settings displays previously stored time zone
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("Yes")
    !45.times{ break if (@notifications.timeZoneOption(4) == "(+02:00) EET (Eastern European Time)"); sleep 1 }

    expect(@notifications.timeZoneOption(4)).to  eq("(+02:00) EET (Eastern European Time)")
    #Saving time zone as default for next time testing
    selectTimeZone("(-05:00) America/New_York (Eastern)")
    sleep 1
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
    #opting out of notifications
    @notifications.clickTheGearIcon()
    @notifications.selectReceiveNotifications("No")
    @modal.clickSaveButton()
    !45.times{ break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
  end

end
=end