require_relative '../../globalized'
include Globalized

describe "Story# JRNL-2504: [Update Notifications to Support a Grouped View Format	", :regression => true do

  header_text = "Notifications"
  detail_header_text = "My VA Health App Notices"
  startDate = "startDate"
  endDate = "endDate"

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("notifications", "notificationsdb", "notifications747")
    resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    resetCollection("preferences", "notificationsdb", "preferences")
    updateDisplayDate
    initializeAllObjects
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @feature = "Notifications"
    @sections = ["All Notifications","My VA Health App Notices","VA Health Messages"]
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "#AC #JRNL-1543|TC #JRNL-1643: Left Panel Navigation" do

    it "Left Panel Navigation -- Notification group options" do
      @main.clickNavMenu
      @nav_menu.isNavVisible(@feature)
    end

    it "List of Notification types and headers" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='Notifications']").click
      waitForPageToFinishLoading
      #Verify Reminder group navigation options are available
      @sections.each_index { |i|
        sectionSelector = @misc.nthSectionButtonText(i + 1)
        #expect(getTextForElement(:css, sectionSelector)).to eq(@sections[i])
        click(:css, sectionSelector)
        waitForPageToFinishLoading()
        expect(getPrimaryHeader()).to eq(@sections[i])
      }
    end
  end

  context 'AC#JRNL-1538,3293,3294,3000|TC #JRNL-1643: My VA Health App - Filter Feature, Filter parameters, Filter button' do

    it "'My VA Health App Notices' view" do
      @main.clickNavMenu
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='Notifications']").click
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default my-va-health-app-notices']").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq("My VA Health App Notices")
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader()== detail_header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(detail_header_text)
    end

    it "Gear Icon", :broken => true do
      @notifications_reminders.clickTheGearIcon()
      !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
      @notifications_reminders.selectReceiveNotifications("No")
      @modal.clickSaveButton()
      !5.times{ break if (@notifications_reminders.isSettingPopupDisappeared == true); sleep 1 }
      @date_filter.clickFilterBtn
      waitForPageToFinishLoading
    end

    it "Filter Control", :broken => true do
      #Click the hide filter button
      @date_filter.clickFilterAccordion
      sleep 1
      #Verify the status filter options are hidden
      expect(@date_filter.isFilterAccordionExpanded).to eq(false)

      #Flip the hide filter button again
      @date_filter.clickFilterAccordion
      sleep 1
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)
    end

    it "Start Date" do
      expect(getTextForElement(:css, Notifications_Reminders::DATERANGE)).to eq("Date Range:")
      expect(getShortFieldLabelScreenReader(startDate, true)).to eq("Start Date:")
      expect(isFieldRequired(:css, Notifications_Reminders::STARTDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Notifications_Reminders::STARTDATE)).to eq("MM/DD/YYYY")
    end

    it "End Date" do
      expect(getShortFieldLabelScreenReader(endDate, true)).to eq("End Date:")
      expect(isFieldRequired(:css, Notifications_Reminders::ENDDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Notifications_Reminders::ENDDATE)).to eq("MM/DD/YYYY")
    end

    it "Source" do
      expect(@notifications_reminders.selectSource(2)).to eq("My VA Health App Notices")
      isThisElementDisabled(:css, "select[name='source'] > option:nth-of-type(2)")
    end

    it "Status" do
      expect(getTextForElement(:css, Notifications_Reminders::STATUSLABEL)).to eq("Status:")
      expect(@notifications_reminders.isStatusSelected("All")).to eq(true)
      expect(@notifications_reminders.isStatusSelected("Unread")).to eq(false)
      expect(@notifications_reminders.isStatusSelected("Read")).to eq(false)
    end

    it "Filter button " do
      expect(isFilterButtonVisible()).to eq(true)
      expect(getFilterButtonLabel()).to eq("Apply")
      expect(@notifications_reminders.getAltText(Notifications_Reminders::FILTER)).to eq("Apply Filter")
    end

    it "Display Error Message" do
      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      setDate(dayAfterTomorrow, "input[name='startDate']")
      setDate(tomorrow, "input[name='endDate']")
      @date_filter.clickFilterBtn
      @error.isErrorMessageDisplayed("filterForm","Start Date must occur before End Date")
      @error.isErrorMessageDisplayed("filterForm","Start date must be between 01/01/1900 and " + today + ".")
      @error.isErrorMessageDisplayed("filterForm","End date must be between 01/01/1900 and " + today + ".")
      sleep 2
      setDate("11/31/2013", "input[name='startDate']")
      setDate("09/31/2014", "input[name='endDate']")
      @date_filter.clickFilterBtn
      @error.isErrorMessageDisplayed("filterForm","Start Date is an invalid date")
      @error.isErrorMessageDisplayed("filterForm","End Date is an invalid date")
      sleep 2
    end
  end

  context 'AC#JRNL-1535|TC JRNL-1643: My VA Health App - Notifications in a table format' do

    it "Notifications in a table format", :broken => true do
      @date_filter.clickResetBtn
      waitForPageToFinishLoading()

      @date_filter.clickFilterBtn
      waitForPageToFinishLoading()

      @notifications_reminders.clickTheGearIcon()
      !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
      @notifications_reminders.selectReceiveNotifications("Yes")
      @modal.clickSaveButton()
      waitForPageToFinishLoading
    end
  end

  context 'Story JRNL-1696|AC JRNL-1583: Reset Button' do

    it "Visible" do
      expect(isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(getResetButtonLabel()).to eq("Reset")
    end

    it "Alt text" do
      expect(@notifications_reminders.getAltText(Notifications_Reminders::RESET)).to eq("Reset Filter")
    end

    it "Restore defaults" do
      @date_filter.clickResetBtn
      expect(getTextFromInput(:css, Notifications_Reminders::STARTDATE)). to eq(getDateNthDaysAgo(30, "%m/%d/%Y"))
      expect(getTextFromInput(:css, Notifications_Reminders::ENDDATE)). to eq(getDateNthDaysAgo(0, "%m/%d/%Y"))
      expect(@notifications_reminders.source()).to eq("All Notifications")
      isThisRadioButtonOrCheckBoxSelected("radio","All","statusOption")
    end

  end

  #######################
  ### Local Functions ###
  #######################
  def updateDisplayDate

    oneDayAgo = (Time.now - 1.days)
    updateDocument("notifications", "notificationsdb", "53fcbbbde4b0654c73d7cbca", "createDate", oneDayAgo)

    twoDaysAgo = (Time.now - 2.days)
    updateDocument("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "createDate", twoDaysAgo)

    tenDaysAgo = (Time.now - 10.days)
    updateDocument("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "createDate", tenDaysAgo)

    twentyDaysAgo = (Time.now - 20.days)
    updateDocument("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "createDate", twentyDaysAgo)

  end

  def getVAHealthMessages()
    return getTextForElement(:css, 'span.no-results-message:last-child')
  end

end










































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "Story# JRNL-2504: [Update Notifications to Support a Grouped View Format	", :regression => true do

  header_text = "Notifications"
  detail_header_text = "My VA Health App Notices"
  startDate = "startDate"
  endDate = "endDate"

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("notifications", "notificationsdb", "notifications747")
    resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    resetCollection("preferences", "notificationsdb", "preferences")
    updateDisplayDate

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @feature = "Notifications"
    @sections = ["All Notifications","My VA Health App Notices","VA Health Messages"]
  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-1543|TC #JRNL-1643: Left Panel Navigation" do

    it "Left Panel Navigation -- Notification group options" do

      @main.clickNavMenu

      @nav_menu.isNavVisible(@feature)
    end

    it "List of Notification types and headers" do

      @nav_menu.clickNotifications

      #Verify Reminder group navigation options are available

      @sections.each_index { |i|
        sectionSelector = @misc.nthSectionButtonText(i + 1)
        expect(getTextForElement(:css, sectionSelector)).to eq(@sections[i])

        click(:css, sectionSelector)
        waitForPageToFinishLoading()

        expect(getPrimaryHeader()).to eq(@sections[i])
      }
    end

  end

  context 'AC#JRNL-1538,3293,3294,3000|TC #JRNL-1643: My VA Health App - Filter Feature, Filter parameters, Filter button' do

    it "'My VA Health App Notices' view" do

      @main.clickNavMenu
      @nav_menu.clickNotifications
      !15.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      @main.clickNavMenu
      @nav_menu.clickMyVAHealthApp()
      !15.times{break if(getPrimaryHeader()== detail_header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(detail_header_text)
    end

    it "Gear Icon", :broken => true do
      @notifications_reminders.clickTheGearIcon()
      !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
      @notifications_reminders.selectReceiveNotifications("No")
      @modal.clickSaveButton()
      !45.times{ break if (@notifications_reminders.isSettingPopupDisappeared == true); sleep 1 }
      @date_filter.clickFilterBtn
      waitForPageToFinishLoading
    end

    it "Filter Control", :broken => true do
      #Click the hide filter button
      @date_filter.clickFilterAccordion
      sleep 1
      #Verify the status filter options are hidden
      expect(@date_filter.isFilterAccordionExpanded).to eq(false)

      #Flip the hide filter button again
      @date_filter.clickFilterAccordion
      sleep 1
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)
    end

    it "Start Date" do
      expect(getTextForElement(:css, Notifications_Reminders::DATERANGE)).to eq("Date Range:")
      expect(getShortFieldLabelScreenReader(startDate, true)).to eq("Start Date:")
      expect(isFieldRequired(:css, Notifications_Reminders::STARTDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Notifications_Reminders::STARTDATE)).to eq("MM/DD/YYYY")
    end

    it "End Date" do
      expect(getShortFieldLabelScreenReader(endDate, true)).to eq("End Date:")
      expect(isFieldRequired(:css, Notifications_Reminders::ENDDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Notifications_Reminders::ENDDATE)).to eq("MM/DD/YYYY")
    end

    it "Source" do
      expect(@notifications_reminders.selectSource(2)).to eq("My VA Health App Notices")
      isThisElementDisabled(:css, "select[name='source'] > option:nth-of-type(2)")
    end

    it "Status" do
      expect(getTextForElement(:css, Notifications_Reminders::STATUSLABEL)).to eq("Status:")
      expect(@notifications_reminders.isStatusSelected("All")).to eq(true)
      expect(@notifications_reminders.isStatusSelected("Unread")).to eq(false)
      expect(@notifications_reminders.isStatusSelected("Read")).to eq(false)
    end

    it "Filter button " do
      expect(isFilterButtonVisible()).to eq(true)
      expect(getFilterButtonLabel()).to eq("Apply")
      expect(@notifications_reminders.getAltText(Notifications_Reminders::FILTER)).to eq("Apply Filter")
    end

    it "Display Error Message" do
      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      setDate(dayAfterTomorrow, "input[name='startDate']")
      setDate(tomorrow, "input[name='endDate']")
      @date_filter.clickFilterBtn
      @error.isErrorMessageDisplayed("filterForm","Start Date must occur before End Date")
      @error.isErrorMessageDisplayed("filterForm","Start date must be between 01/01/1900 and " + today + ".")
      @error.isErrorMessageDisplayed("filterForm","End date must be between 01/01/1900 and " + today + ".")
      sleep 2
      setDate("11/31/2013", "input[name='startDate']")
      setDate("09/31/2014", "input[name='endDate']")
      @date_filter.clickFilterBtn
      @error.isErrorMessageDisplayed("filterForm","Start Date is an invalid date")
      @error.isErrorMessageDisplayed("filterForm","End Date is an invalid date")
      sleep 2
    end

  end

  context 'AC#JRNL-1535|TC JRNL-1643: My VA Health App - Notifications in a table format' do

    it "Notifications in a table format", :broken => true do
      @date_filter.clickResetBtn
      waitForPageToFinishLoading()

      @date_filter.clickFilterBtn
      waitForPageToFinishLoading()
      expect(getTableHeaders()).to eq(["Status","Notification","Date"])
      isSortedByChronologicalOrder("%m/%d/%Y", 3)

      @notifications_reminders.clickTheGearIcon()
      !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
      @notifications_reminders.selectReceiveNotifications("Yes")
      @modal.clickSaveButton()
      waitForPageToFinishLoading()

      clickNthRow(1)
      waitForPageToFinishLoading()
      expect(@notifications_reminders.getPrimaryHeader).to eq("View Notification")

      expect(@notifications_reminders.getSourceInDetail).to eq("My VA Health - My Reminders")
      expect(@notifications_reminders.getTextInDetail).to eq("Take 'Tylenol' now.")
      expect(@notifications_reminders.getTextInDetail.length).to be <= 250
      @notifications_reminders.clickCancelButton
      waitForPageToFinishLoading()

      @date_filter.clickResetBtn
      waitForPageToFinishLoading()
      clickNthRow(2)
      waitForPageToFinishLoading()
      expect(@notifications_reminders.getPrimaryHeader).to eq("View Notification")

      expect(@notifications_reminders.getSourceInDetail).to eq("My VA Health - Assessments")
      expect(@notifications_reminders.getTextInDetail).to eq("You will receive your assessment reminder in 4 weeks")
      expect(@notifications_reminders.getTextInDetail.length).to be <= 250
      waitForPageToFinishLoading
      @notifications_reminders.clickCancelButton
      waitForPageToFinishLoading()
    end

  end

  context 'Story JRNL-1696|AC JRNL-1583: Reset Button' do

    it "Visible" do
      expect(isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(getResetButtonLabel()).to eq("Reset")
    end

    it "Alt text" do
      expect(@notifications_reminders.getAltText(Notifications_Reminders::RESET)).to eq("Reset Filter")
    end

    it "Restore defaults" do
      @date_filter.clickResetBtn
      expect(getTextFromInput(:css, Notifications_Reminders::STARTDATE)). to eq(getDateNthDaysAgo(30, "%m/%d/%Y"))
      expect(getTextFromInput(:css, Notifications_Reminders::ENDDATE)). to eq(getDateNthDaysAgo(0, "%m/%d/%Y"))
      expect(@notifications_reminders.source()).to eq("All Notifications")
      isThisRadioButtonOrCheckBoxSelected("radio","All","statusOption")
    end

  end

  #######################
  ### Local Functions ###
  #######################
  def updateDisplayDate

    oneDayAgo = (Time.now - 1.days)
    updateDocument("notifications", "notificationsdb", "53fcbbbde4b0654c73d7cbca", "createDate", oneDayAgo)

    twoDaysAgo = (Time.now - 2.days)
    updateDocument("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "createDate", twoDaysAgo)

    tenDaysAgo = (Time.now - 10.days)
    updateDocument("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "createDate", tenDaysAgo)

    twentyDaysAgo = (Time.now - 20.days)
    updateDocument("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "createDate", twentyDaysAgo)

  end

  def getVAHealthMessages()
    return getTextForElement(:css, 'span.no-results-message:last-child')
  end

end
=end