require_relative '../../globalized'
include Globalized
describe "[ Story# JRNL-2527: Notifications_MVAH_5_spec ] ", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    removeCollection("notificationPreferences", "notificationsdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  after(:all) do
    resetCollection("notifications", "notificationsdb", "notifications")
    quitDriver()
  end

  #FIRST TIME USER
  it "AC(JRNL-3197|JRNL-3198|JRNL-3199), TC(NR-677|):Preferred email for first time user; Notification Settings - Preferred Email; Save Preferred Email Bug Fix for JRNL 2289 has been added", :broken => true do
    waitForPageToFinishLoading
    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='Notifications']").click
    waitForPageToFinishLoading
    !5.times{ break if (@notifications_reminders.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications_reminders.getTitle()).to eq("Notifications")

    @notifications_reminders.clickTheGearIcon()
    !5.times { break if(@modal.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@modal.getFocusedElementText()).to eq("")

    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("email910@gmail.com")

    expect(@landing.preferredEmailInstructionalText()).to eq("Your Preferred email for notifications applies to all VA Health apps.")
    expect(@notifications_reminders.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")

    @modal.clickSaveButton()
    !5.times{ break if (@notifications_reminders.isSettingPopupDisappeared() == true); sleep 1 }
    expect(@notifications_reminders.isSettingPopupDisappeared()).to eq(true)
  end

end











































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[ Story# JRNL-2527: Notifications_MVAH_5_spec ] ", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences","notificationsdb")
    deleteROAFromTable("D123401")
    removeCollection("notificationPreferences", "notificationsdb")
    initializeAllObjects
  end

  after(:all) do
    resetCollection("notifications", "notificationsdb", "notifications")
    quitDriver()
  end

  #FIRST TIME USER
  it "AC(JRNL-3197|JRNL-3198|JRNL-3199), TC(NR-677|):Preferred email for first time user; Notification Settings - Preferred Email; Save Preferred Email Bug Fix for JRNL 2289 has been added", :broken => true do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    @loginpage.passingByTheLandingPage()
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }

    @loginpage.loginAsVeteranAsFirstTimeUser("zztest.patient01")
    sleep 5

    @roa.clickNext()
    !45.times{ break if (getPageTitle() == "Review"); sleep 1 }

    @roa.clickVerify()

    ####################################################################################################################
    ####################################################################################################################
    ############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###############################
    ####################################################################################################################
    ####################################################################################################################


    waitForPageToFinishLoading
    if is_element_present(:css, "input[id='no-show-notice']") then
      click(:css, "input[id='no-show-notice']")
      @pleasenote.clickAccept
    end

    ####################################################################################################################
    ####################################################################################################################
    ############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###############################
    ####################################################################################################################
    ####################################################################################################################

    waitForPageToFinishLoading
    !45.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
    expect(@landing.notificationWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")

    #email preference
    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("email99@gmail.com")
    expect(@landing.emailAddressInstructionalText()).to eq("Your Preferred email for notifications applies to all VA Health apps. You may modify this email under the Settings feature shown under Notifications.")

    #app tour
    waitForPageToFinishLoading
    @app_tour.clickAppTourCloseButton

    #time zone
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    selectTimeZone("(+01:00) CET (Central European Time)")
    sleep 1

    @notifications_reminders.clickSaveButton
    #verify that notification settings displays the previously selected time zone
    !45.times{ break if(is_element_present(:css, "div.container-fluid.page.first") == false); sleep 1 }
    expect(is_element_present(:css, "div.container-fluid.page.first")).to eq(false)


    #app tour
    waitForPageToFinishLoading
    @app_tour.clickAppTourCloseButton

    waitForPageToFinishLoading
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickNotifications()
    !45.times{ break if (@notifications_reminders.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications_reminders.getTitle()).to eq("Notifications")

    @notifications_reminders.clickTheGearIcon()
    !30.times { break if(@modal.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@modal.getFocusedElementText()).to eq(@modal.getConfirmationHeading())

    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("email910@gmail.com")

    expect(@landing.preferredEmailInstructionalText()).to eq("Your Preferred email for notifications applies to all VA Health apps.")
    expect(@notifications_reminders.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")

    @modal.clickSaveButton()
    !45.times{ break if (@notifications_reminders.isSettingPopupDisappeared() == true); sleep 1 }
    expect(@notifications_reminders.isSettingPopupDisappeared()).to eq(true)
  end

end
=end
